/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.IPSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Search;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.IPSearchRun;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import java.util.Iterator;
import java.util.Properties;

public class IPSearch
implements Search {
    private IPSearchRun job;
    private SearchResult result;
    private IPSearchConfig searchConfig;
    public static final String sccs_id = "@(#)IPSearch.java\t1.4 04/21/03 SMI";

    public IPSearch(IPSearchConfig iPSearchConfig) {
        this.searchConfig = iPSearchConfig;
    }

    public SearchConfig getSearchConfig() {
        return this.searchConfig;
    }

    public SearchResult runSearch() {
        SearchResultImpl searchResultImpl = new SearchResultImpl(this.searchConfig);
        searchResultImpl.setStatus(1);
        this.result = searchResultImpl;
        this.job = new IPSearchRun(searchResultImpl);
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob((Runnable)this.job);
        return searchResultImpl;
    }

    public void stopSearch() {
        this.job.abort();
    }

    public SearchResult getSearchResult() {
        return this.result;
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
        }

        public static void main(String[] stringArray) {
            try {
                if (stringArray.length != 3) {
                    System.err.println("usage IPSearch <start ip> <end ip> <timeout>");
                    System.exit(1);
                }
                IPSearchConfig iPSearchConfig = new IPSearchConfig();
                iPSearchConfig.setIpStart(stringArray[0]);
                iPSearchConfig.setIpEnd(stringArray[1]);
                iPSearchConfig.setTimeout(Integer.parseInt(stringArray[2]));
                IPSearch iPSearch = new IPSearch(iPSearchConfig);
                SearchResultImpl searchResultImpl = (SearchResultImpl)iPSearch.runSearch();
                searchResultImpl.waitForComplete();
                String string = searchResultImpl.getErrorMsg();
                if (string == null) {
                    System.out.println("Search done");
                    Iterator iterator = searchResultImpl.getResults();
                    while (iterator.hasNext()) {
                        Properties properties = (Properties)iterator.next();
                        properties.list(System.out);
                    }
                } else {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
    }
}

