/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.OID;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.AdapterSticher;
import com.sun.netstorage.mgmt.esm.logic.device.protocol.raclient.AgentStore;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.AgentSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.StorADESearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DiscoveryStatusEvent;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.FCPProbe;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.IEProbe;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.StorADESearch;
import com.sun.netstorage.mgmt.fm.storade.client.StoradeAgentSummary;
import com.sun.netstorage.mgmt.fm.storade.client.StoradeClient;
import com.sun.netstorage.mgmt.fm.storade.client.StoradeDeviceSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

class AgentSearchRun
implements Runnable {
    private int numSAdevs;
    private AgentSearchConfig config;
    private SearchResultImpl sr;
    private boolean stop;
    private FCPProbe fcpProbe;
    private IEProbe ieProbe;
    private String host;
    private int numTargets;
    private int numIES;
    private int numFound;
    private int numNewDevs;
    public static final String sccs_id = "@(#)AgentSearchRun.java\t1.15 04/01/04 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory;

    AgentSearchRun(SearchResultImpl searchResultImpl) {
        this.sr = searchResultImpl;
        this.config = (AgentSearchConfig)searchResultImpl.getSearchConfig();
    }

    public void run() {
        if (!this.parseInput()) {
            return;
        }
        this.init();
        this.doDiscovery();
    }

    public void abort() {
        this.stop = true;
    }

    private boolean parseInput() {
        this.host = this.config.getHost();
        if (this.host == null) {
            this.sr.setErrorMsg("Host undefined.");
            return false;
        }
        return true;
    }

    private void init() {
        this.fcpProbe = new FCPProbe();
        this.ieProbe = new IEProbe();
        this.numFound = 0;
        this.numTargets = 0;
        this.numIES = 0;
    }

    private void setupStorADESearch() {
        StoradeClient storadeClient = new StoradeClient(this.host);
        StoradeAgentSummary[] storadeAgentSummaryArray = storadeClient.getAgentList();
        if (storadeAgentSummaryArray.length == 0) {
            this.numSAdevs = storadeAgentSummaryArray.length;
            return;
        }
        StoradeDeviceSummary[] storadeDeviceSummaryArray = storadeClient.getDeviceList();
        this.numSAdevs = storadeDeviceSummaryArray.length;
    }

    private void runStorADEDiscovery() {
        StoradeClient storadeClient = new StoradeClient(this.host);
        if (this.numNewDevs > 0) {
            storadeClient.runLocalProbe();
        }
    }

    private void runStorADESearch() {
        if (this.numSAdevs == 0) {
            return;
        }
        StorADESearchConfig storADESearchConfig = new StorADESearchConfig();
        storADESearchConfig.setHost(this.host);
        storADESearchConfig.setPort(7654);
        storADESearchConfig.setTimeout(20);
        StorADESearch storADESearch = new StorADESearch(storADESearchConfig);
        SearchResultImpl searchResultImpl = (SearchResultImpl)storADESearch.runSearch();
        searchResultImpl.waitForComplete();
        Iterator iterator = searchResultImpl.getResults();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (iterator != null) {
            Iterator iterator2;
            while (iterator.hasNext()) {
                iterator2 = (Properties)iterator.next();
                if (!this.checkProperties((Properties)((Object)iterator2))) continue;
                arrayList.add(iterator2);
            }
            iterator2 = arrayList.iterator();
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    Properties properties = (Properties)iterator2.next();
                    this.installDevice(properties);
                    searchResultImpl.addElement(properties);
                }
            }
        }
    }

    private void doDiscovery() {
        try {
            Iterator iterator;
            Collection collection;
            this.setupStorADESearch();
            AdapterSticher adapterSticher = new AdapterSticher(this.host);
            adapterSticher.instrumentAgent();
            AgentStore agentStore = new AgentStore();
            agentStore.storeHostData(adapterSticher);
            Collection collection2 = adapterSticher.getTargets();
            if (collection2 != null) {
                this.numTargets = collection2.size();
            }
            if ((collection = adapterSticher.getInterconnectElements()) != null) {
                this.numIES = collection.size();
            }
            int n = 0;
            if (this.numTargets > 0 && (iterator = collection2.iterator()) != null) {
                while (iterator.hasNext()) {
                    this.probeFCPTarget((DeviceClass)iterator.next());
                    this.updateResult(++n, 0);
                }
            }
            if (this.numIES > 0) {
                iterator = collection.iterator();
                n = 0;
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        this.probeIE((DeviceClass)iterator.next());
                        this.updateResult(this.numTargets, ++n);
                    }
                }
            }
            this.runStorADEDiscovery();
            this.runStorADESearch();
        }
        catch (Exception exception) {
            PACKAGE.ERROR("Agent Search Failed for host " + this.host, exception);
            DiscoveryStatusEvent.postFailedStatus("Agent", this.host, new LocalizedString(exception));
            this.sr.setErrorMsg(exception.toString());
            return;
        }
        DiscoveryStatusEvent.postStatus("Agent", this.host, this.numFound);
        this.sr.setComplete();
    }

    private void probeFCPTarget(DeviceClass deviceClass) {
        Properties properties = new Properties();
        this.setProperty(properties, "RHBA.Host", this.host);
        this.setProperty(properties, "RHBA.FCPTARGET.DeviceType", deviceClass.getProperty("DeviceType"));
        this.setProperty(properties, "RHBA.FCPTARGET.FabricName", deviceClass.getProperty("FabricName"));
        this.setProperty(properties, "RHBA.FCPTARGET.IpAddress", deviceClass.getProperty("IpAddress"));
        this.setProperty(properties, "RHBA.FCPTARGET.NodeWWN", deviceClass.getProperty("NodeWWN"));
        this.setProperty(properties, "RHBA.FCPTARGET.OSDeviceName", deviceClass.getProperty("OSDeviceName"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortFcID", deviceClass.getProperty("PortFcID"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortMaxFrameSize", deviceClass.getProperty("PortMaxFrameSize"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortSpeed", deviceClass.getProperty("PortSpeed"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortState", deviceClass.getProperty("PortState"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortSupportedSpeed", deviceClass.getProperty("PortSupportedSpeed"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortType", deviceClass.getProperty("PortType"));
        this.setProperty(properties, "RHBA.FCPTARGET.PortWWN", deviceClass.getProperty("PortWWN"));
        this.setProperty(properties, "RHBA.FCPTARGET.ProductId", deviceClass.getProperty("ProductId"));
        this.setProperty(properties, "RHBA.FCPTARGET.ProductRevision", deviceClass.getProperty("ProductRevision"));
        this.setProperty(properties, "RHBA.FCPTARGET.VendorId", deviceClass.getProperty("VendorId"));
        this.setProperty(properties, "RHBA.FCPTARGET.SystemId", deviceClass.getProperty("SystemId"));
        ProbeResult probeResult = this.fcpProbe.probe(properties);
        Iterator iterator = probeResult.getDevices().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Properties properties2 = (Properties)iterator.next();
                if (!this.checkProperties(properties2)) continue;
                this.installDevice(properties2);
                this.sr.addElement(properties2);
            }
        }
    }

    private void probeIE(DeviceClass deviceClass) {
        Object object;
        Properties properties;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = deviceClass.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                properties = (DeviceClass)iterator.next();
                object = properties.getProperty("Address");
                if (object == null) continue;
                stringBuffer.append((String)object);
                stringBuffer.append(",");
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        properties = new Properties();
        this.setProperty(properties, "RHBA.Host", this.host);
        this.setProperty(properties, "RHBA.IE.Address", stringBuffer.toString());
        this.setProperty(properties, "RHBA.IE.DomainId", deviceClass.getProperty("DomainId"));
        this.setProperty(properties, "RHBA.IE.FabricName", deviceClass.getProperty("FabricName"));
        this.setProperty(properties, "RHBA.IE.LogicalName", deviceClass.getProperty("LogicalName"));
        this.setProperty(properties, "RHBA.IE.MgmtId", deviceClass.getProperty("MgmtId"));
        this.setProperty(properties, "RHBA.IE.ModelName", deviceClass.getProperty("ModelName"));
        this.setProperty(properties, "RHBA.IE.ReleaseCode", deviceClass.getProperty("ReleaseCode"));
        this.setProperty(properties, "RHBA.IE.Type", deviceClass.getProperty("Type"));
        this.setProperty(properties, "RHBA.IE.VendorName", deviceClass.getProperty("VendorName"));
        this.setProperty(properties, "RHBA.IE.VendorSpecificInfo", deviceClass.getProperty("VendorSpecificInfo"));
        this.setProperty(properties, "RHBA.IE.WWN", deviceClass.getProperty("WWN"));
        object = this.ieProbe.probe(properties);
        Iterator iterator2 = ((ProbeResult)object).getDevices().iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                Properties properties2 = (Properties)iterator2.next();
                if (!this.checkProperties(properties2)) continue;
                this.installDevice(properties2);
                this.sr.addElement(properties2);
            }
        }
    }

    private void setProperty(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    private boolean checkProperties(Properties properties) {
        String string;
        String string2 = properties.getProperty("type");
        if (string2 == null || string2.equals("")) {
            return false;
        }
        if (null == properties.getProperty("OID")) {
            properties.setProperty("OID", OID.getKey());
        }
        if ((string = properties.getProperty("search.ib")) == null || string.equals("")) {
            properties.setProperty("search.ib", "" + System.currentTimeMillis());
        }
        properties.setProperty("active", "Y");
        return true;
    }

    private void installDevice(Properties properties) {
        try {
            FacadeFactory facadeFactory = (FacadeFactory)InstallerServiceFinder.findLocalService((Class)(class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory = AgentSearchRun.class$("com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory")) : class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory));
            if (facadeFactory == null) {
                Report.error.log((Object)"Error finding MF factory.");
                return;
            }
            if (facadeFactory.findDevice(properties) == null) {
                ++this.numNewDevs;
            }
            facadeFactory.discoverDevice(properties);
            ++this.numFound;
        }
        catch (Exception exception) {
            Report.error.log((Throwable)exception, (Object)("error loading device:" + AgentSearchRun.printProperties(properties)));
        }
    }

    private static String printProperties(Properties properties) {
        TreeMap<Object, Object> treeMap;
        Set<Map.Entry<Object, Object>> set;
        Iterator<Map.Entry<Object, Object>> iterator;
        StringBuffer stringBuffer = new StringBuffer();
        if (properties != null && (iterator = (set = (treeMap = new TreeMap<Object, Object>(properties)).entrySet()).iterator()) != null) {
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(string2);
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    private void updateResult(int n, int n2) {
        int n3 = this.numTargets + this.numIES;
        int n4 = n + n2;
        if (n3 > 0) {
            this.sr.setPercentComplete((n4 *= 100) / n3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Test
    extends UnitTest {
        public void test() throws Exception {
            SearchResultImpl searchResultImpl = new SearchResultImpl(new AgentSearchConfig());
            AgentSearchRun agentSearchRun = new AgentSearchRun(searchResultImpl);
            agentSearchRun.run();
            this.assertCondition(searchResultImpl.getStatus() == 3);
        }
    }
}

