/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.common;

import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_ManagedSystemElement;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.ComputerSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.ConcreteJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.LogicalElement;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.Recipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.common.Contract;
import com.sun.netstorage.mgmt.esm.util.beans.PropertyChangeSource;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;

public class TrackJobRecipe
extends Recipe
implements PropertyChangeSource {
    private static final String SCCS_ID = "@(#)TrackJobRecipe.java 1.4   03/09/19 SMI";
    public static final String TRACK_JOB_OPERATION = "job tracking";
    private final PropertyChangeSupport mySupport = new PropertyChangeSupport(this);
    private final ComputerSystem myComputerSystem;
    private ConcreteJob myConcreteJob = null;
    private LogicalElement myElement = null;
    private int myPercentComplete = 0;
    private int[] myOperationalStatus = null;
    private String myStatus = null;

    public TrackJobRecipe(ComputerSystem computerSystem, ConcreteJob concreteJob, LogicalElement logicalElement) {
        super(computerSystem);
        Contract.requires((computerSystem != null ? 1 : 0) != 0, (String)"theComputerSystem != null");
        Contract.requires((concreteJob != null ? 1 : 0) != 0, (String)"theConcreteJob != null");
        this.myComputerSystem = computerSystem;
        this.setConcreteJob(concreteJob);
        this.myElement = logicalElement;
    }

    public TrackJobRecipe(ComputerSystem computerSystem, ConcreteJob concreteJob) {
        this(computerSystem, concreteJob, null);
    }

    public final ComputerSystem getComputerSystem() {
        return this.myComputerSystem;
    }

    public final boolean hasConcreteJob() {
        return this.myConcreteJob != null;
    }

    public final ConcreteJob getConcreteJob() {
        return this.myConcreteJob;
    }

    public final void setConcreteJob(ConcreteJob concreteJob) {
        this.myConcreteJob = concreteJob;
    }

    public final boolean hasElement() {
        return this.myElement != null;
    }

    public final LogicalElement getElement() {
        return this.myElement;
    }

    public final int getPercentComplete() {
        return this.myPercentComplete;
    }

    private void setPercentComplete(int n) {
        if (this.myPercentComplete != n) {
            this.firePercentCompleteChange(this.myPercentComplete, n);
            this.myPercentComplete = n;
        }
    }

    public final int[] getOperationalStatus() {
        return this.myOperationalStatus;
    }

    private void setOperationalStatus(int[] nArray) {
        if (this.hasOperationalStatusChanged(nArray)) {
            this.fireOperationalStatusChange(this.myOperationalStatus, nArray);
            this.myOperationalStatus = nArray;
        }
    }

    private boolean hasOperationalStatusChanged(int[] nArray) {
        boolean bl = true;
        if (this.myOperationalStatus != null && Arrays.equals(this.myOperationalStatus, nArray)) {
            bl = false;
        }
        return bl;
    }

    public final String getStatus() {
        return this.myStatus;
    }

    private void setStatus(String string) {
        if (this.myStatus != string) {
            this.fireStatusChange(this.myStatus, string);
            this.myStatus = string;
        }
    }

    public final boolean isComplete() {
        return this.myPercentComplete >= 100;
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.mySupport.firePropertyChange(string, object, object2);
    }

    private void firePropertyChange(String string, int n, int n2) {
        this.mySupport.firePropertyChange(string, n, n2);
    }

    private void firePercentCompleteChange(int n, int n2) {
        this.firePropertyChange("PercentComplete", n, n2);
    }

    private void fireOperationalStatusChange(int[] nArray, int[] nArray2) {
        this.firePropertyChange("OperationalStatus", nArray, nArray2);
    }

    private void fireStatusChange(String string, String string2) {
        this.firePropertyChange("Status", string, string2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.mySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.mySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void cookRecipe() {
        Poller poller = new Poller(5);
        poller.run();
    }

    private class Listener
    extends Thread {
        private Listener() {
        }

        public void run() {
        }
    }

    private class Poller
    extends Thread {
        private final int myNapTime;
        private boolean myPolling = true;

        Poller(int n) {
            this.myNapTime = n;
        }

        long getNapTime() {
            return this.myNapTime * 1000;
        }

        private synchronized void pausePolling() {
            try {
                this.wait(this.getNapTime());
            }
            catch (InterruptedException interruptedException) {
                this.myPolling = false;
            }
        }

        public synchronized void stopPolling() {
            this.myPolling = false;
        }

        public void run() {
            ConcreteJob concreteJob = TrackJobRecipe.this.getConcreteJob();
            while (this.myPolling) {
                if (concreteJob.exists()) {
                    int n = concreteJob.getPercentComplete();
                    String string = concreteJob.getStatus();
                    int[] nArray = concreteJob.getOperationalStatus();
                    TrackJobRecipe.this.setPercentComplete(n);
                    TrackJobRecipe.this.setStatus(string);
                    TrackJobRecipe.this.setOperationalStatus(nArray);
                    if (n >= 100) {
                        this.stopPolling();
                        break;
                    }
                } else {
                    TrackJobRecipe.this.setPercentComplete(100);
                    TrackJobRecipe.this.setStatus(CIM_ManagedSystemElement.Status._UNKNOWN_);
                    this.stopPolling();
                    break;
                }
                this.pausePolling();
            }
        }
    }
}

