/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;

public class MappingModel {
    private static final String SCCS_ID = "@(#)MappingModel.java 1.3   03/09/09 SMI";
    private Volume myVolume;
    private int myDeviceNumber;
    private FCPort[] myFCPorts;

    public MappingModel(Volume volume, int n, FCPort[] fCPortArray) {
        Contract.requires((volume != null ? 1 : 0) != 0, (String)"theVolume != null");
        Contract.requires((n >= 0 ? 1 : 0) != 0, (String)"theDeviceNumber >= 0");
        Contract.requires((fCPortArray != null ? 1 : 0) != 0, (String)"theFCPorts != null");
        Contract.requires((fCPortArray.length > 0 ? 1 : 0) != 0, (String)"theFCPorts.length > 0");
        this.myVolume = volume;
        this.myDeviceNumber = n;
        this.myFCPorts = fCPortArray;
    }

    public final Volume getVolume() {
        return this.myVolume;
    }

    public final int getDeviceNumber() {
        return this.myDeviceNumber;
    }

    public final FCPort[] getFCPorts() {
        return this.myFCPorts;
    }

    String getPortString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = FCPort.toNameStrings(this.getFCPorts());
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append('#');
            stringBuffer.append(stringArray[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDeviceNumber());
        stringBuffer.append(" : ");
        stringBuffer.append(this.getVolume().toString());
        stringBuffer.append(" : ");
        stringBuffer.append(this.getPortString());
        return stringBuffer.toString();
    }
}

