/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.common.array.LunMaskingInfo;
import com.sun.netstorage.mgmt.esm.common.array.StoragePermission;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Privilege;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolController;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.AccessRecipe;

public class ListMaskingRecipe
extends AccessRecipe {
    private static final String SCCS_ID = "@(#)ListMaskingRecipe.java 1.7   03/09/25 SMI";
    private LunMaskingInfo myLunMasking;

    public ListMaskingRecipe(StorageSystem storageSystem, Volume volume) {
        super(storageSystem, volume);
        this.myLunMasking = new LunMaskingInfo(volume.getName());
    }

    public ListMaskingRecipe(StorageSystem storageSystem, String string) {
        super(storageSystem, string);
        this.myLunMasking = new LunMaskingInfo(string);
    }

    public final LunMaskingInfo getLunMasking() {
        return this.myLunMasking;
    }

    protected void cookRecipe() {
        ProtocolController[] protocolControllerArray;
        this.traceStep(1, "Get the permissions assigned to the volume.");
        FCPort[] fCPortArray = this.getStorageSystem().getFCPorts();
        Privilege[] privilegeArray = this.getVolume().getPrivileges();
        int n = 0;
        while (n < privilegeArray.length) {
            protocolControllerArray = privilegeArray[n].getHardwareID();
            if (protocolControllerArray != null) {
                StoragePermission storagePermission = this.getAccess(privilegeArray[n]);
                int n2 = 0;
                while (n2 < fCPortArray.length) {
                    this.myLunMasking.setPermission(fCPortArray[n2].getPermanentAddress(), protocolControllerArray.getStorageID(), storagePermission);
                    ++n2;
                }
            }
            ++n;
        }
        this.traceStep(2, "Get the default permissions.");
        protocolControllerArray = this.getVolume().getProtocolControllers();
        int n3 = 0;
        while (n3 < protocolControllerArray.length) {
            Privilege[] privilegeArray2 = protocolControllerArray[n3].getPrivileges();
            int n4 = 0;
            while (n4 < privilegeArray2.length) {
                HardwareID hardwareID = privilegeArray2[n4].getHardwareID();
                if (hardwareID != null) {
                    StoragePermission storagePermission = this.getAccess(privilegeArray2[n4]);
                    FCPort[] fCPortArray2 = protocolControllerArray[n3].getFCPorts();
                    int n5 = 0;
                    while (n5 < fCPortArray2.length) {
                        String string;
                        String string2 = fCPortArray2[n5].getPermanentAddress();
                        if (!this.myLunMasking.containsInitiator(string2, string = hardwareID.getStorageID())) {
                            this.myLunMasking.setPermission(string2, string, storagePermission);
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
            ++n3;
        }
    }

    private StoragePermission getAccess(Privilege privilege) {
        Object object = StoragePermission.NONE;
        int[] nArray = privilege.getPropertyValue("Activities").intValues();
        boolean bl = privilege.getPropertyValue("PrivilegeGranted").booleanValue();
        int n = 0;
        while (n < nArray.length) {
            if (object.equals((Object)StoragePermission.NONE)) {
                object = nArray[n] == 5 ? StoragePermission.READ : (nArray[n] == 6 && nArray.length == 1 ? StoragePermission.READ : StoragePermission.ALL);
            } else if (object.equals((Object)StoragePermission.READ) && nArray[n] == 6) {
                object = StoragePermission.ALL;
            }
            ++n;
        }
        if (!bl) {
            if (object.equals((Object)StoragePermission.ALL)) {
                object = StoragePermission.NONE;
            } else if (nArray.length == 1) {
                object = nArray[0] == 6 ? StoragePermission.READ : null;
            }
        }
        return object;
    }
}

