/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolController;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolControllerForUnit;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.AccessRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.MappingModel;
import java.util.ArrayList;

public class ListMappingRecipe
extends AccessRecipe {
    private static final String SCCS_ID = "@(#)ListMappingRecipe.java 1.6   03/09/09 SMI";
    public static final String LIST_MAPPING_OPERATION = "list mapping";
    private MappingModel[] myLunMapping;
    private final StorageSystem myStorageSystem;

    public ListMappingRecipe(StorageSystem storageSystem) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        this.myStorageSystem = storageSystem;
    }

    public final MappingModel[] getLunMapping() {
        return this.myLunMapping;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Get the storage volumes for the System.");
        Volume[] volumeArray = this.myStorageSystem.getVolumes();
        this.traceStep(2, "For each volume, get the lun mapping information.");
        ArrayList<MappingModel> arrayList = new ArrayList<MappingModel>();
        int n = 0;
        while (n < volumeArray.length) {
            ProtocolControllerForUnit[] protocolControllerForUnitArray = volumeArray[n].getProtocolControllerForUnits();
            if (protocolControllerForUnitArray != null) {
                int n2 = 0;
                while (n2 < protocolControllerForUnitArray.length) {
                    ProtocolController protocolController = protocolControllerForUnitArray[n2].getProtocolController();
                    arrayList.add(new MappingModel(volumeArray[n], protocolControllerForUnitArray[n2].getDeviceNumber(), protocolController.getFCPorts()));
                    ++n2;
                }
            }
            ++n;
        }
        this.myLunMapping = arrayList.toArray(new MappingModel[0]);
    }
}

