/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.Recipe;

public class FindPoolSummarizeRecipe
extends Recipe {
    public static final String NO_POOLS_COULD_BE_FOUND = "failed to find storage pools";
    private final StorageSystem myStorageSystem;
    private final long myTotalAllocatedSpaceToVolumes = 0L;
    private final long myTotalAvailableSpaceForVolumeCreation = 0L;

    public FindPoolSummarizeRecipe(StorageSystem storageSystem) {
        super(storageSystem);
        this.myStorageSystem = storageSystem;
    }

    public final long getTotalManagedSpaceOfPools() {
        return this.myStorageSystem.getArraySize();
    }

    public final long getTotalAvailableSpaceForPoolCreation() {
        return this.myStorageSystem.getUnallocatedSpace();
    }

    public final long getTotalAllocatedSpaceToVolumes() {
        return 0L;
    }

    public final long getTotalAvailableSpaceForVolumeCreation() {
        return 0L;
    }

    protected final void failNoPoolsFound() {
        this.failRecipe(NO_POOLS_COULD_BE_FOUND);
    }

    protected final void cookRecipe() {
        Pool[] poolArray = this.myStorageSystem.getPools();
        if (poolArray == null) {
            this.failNoPoolsFound();
        }
        int n = 0;
        while (n < poolArray.length) {
            if (!poolArray[n].isPrimordial()) {
                // empty if block
            }
            ++n;
        }
    }
}

