/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.common.array.LunNumberInfo;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ControllerConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolController;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.AccessRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.ListMappingRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.MappingModel;

public class FindLunNumberInfoRecipe
extends AccessRecipe {
    private static final String SCCS_ID = "@(#)FindLunNumberInfoRecipe.java 1.3   03/09/09 SMI";
    private LunNumberInfo myLunNumberInfo;

    public FindLunNumberInfoRecipe(StorageSystem storageSystem, FCPort[] fCPortArray) {
        super(storageSystem, fCPortArray);
    }

    public FindLunNumberInfoRecipe(StorageSystem storageSystem, String[] stringArray) {
        super(storageSystem, stringArray);
    }

    public final LunNumberInfo getLunNumberInfo() {
        return this.myLunNumberInfo;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Get the ControllerConfigurationService for the system.");
        ControllerConfigService controllerConfigService = this.getStorageSystem().getControllerConfigService();
        this.traceStep(2, "Use the service's `CreateProtocolController` method to create the view.");
        ProtocolController[] protocolControllerArray = new ProtocolController[1];
        controllerConfigService.createController(this.getFCPorts(), protocolControllerArray);
        if (protocolControllerArray[0] == null) {
            this.failCreateController();
        }
        this.traceStep(3, "Create the LUN Number information.");
        int n = protocolControllerArray[0].getMaxUnitsControlled();
        ListMappingRecipe listMappingRecipe = new ListMappingRecipe(this.getStorageSystem());
        listMappingRecipe.run();
        if (listMappingRecipe.wasSuccess()) {
            MappingModel[] mappingModelArray = listMappingRecipe.getLunMapping();
            if (mappingModelArray != null) {
                int[] nArray = new int[mappingModelArray.length];
                int n2 = 0;
                while (n2 < mappingModelArray.length) {
                    nArray[n2] = mappingModelArray[n2].getDeviceNumber();
                    ++n2;
                }
                this.myLunNumberInfo = new LunNumberInfo(n, nArray);
            }
        } else {
            this.failOperationFailed("LIST_MAPPING_OPERATION");
        }
    }
}

