/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ControllerConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolController;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.AccessRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Localization;

public class DetachDeviceRecipe
extends AccessRecipe {
    private static final String SCCS_ID = "@(#)DetachDeviceRecipe.java 1.7   04/04/13 SMI";
    public static final String NO_PROTOCOL_CONTROLLER = "The volume ({0}) is already unmapped.";

    public DetachDeviceRecipe(StorageSystem storageSystem, Volume volume, FCPort[] fCPortArray) {
        super(storageSystem, volume, fCPortArray);
    }

    public DetachDeviceRecipe(StorageSystem storageSystem, Volume volume, String[] stringArray) {
        super(storageSystem, volume, stringArray);
    }

    public DetachDeviceRecipe(StorageSystem storageSystem, String string, String[] stringArray) {
        super(storageSystem, string, stringArray);
    }

    protected void cookRecipe() {
        this.traceStep(1, "Locate the ControllerConfigurationService for the System.");
        ControllerConfigService controllerConfigService = this.getStorageSystem().getControllerConfigService();
        this.traceStep(2, "Obtain the protocol controller for the volume and the device number.");
        ProtocolController protocolController = this.getVolume().findProtocolController(this.getFCPorts());
        if (protocolController == null) {
            this.failNoProtocolController(this.getVolume());
        }
        this.traceStep(3, "Use the service's `DeleteProtocolController` to delete the view.");
        controllerConfigService.detachDevice(protocolController, this.getVolume());
    }

    protected final void failNoProtocolController(Volume volume) {
        String[] stringArray = new String[]{volume.getObjectPath().toString()};
        this.failRecipe(Localization.RES_NO_PROTOCOL_CONTROLLER, stringArray);
    }
}

