/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.ConfigRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;

public class DeletePoolRecipe
extends ConfigRecipe {
    private static final String SCCS_ID = "@(#)DeletePoolRecipe.java 1.3   03/08/08 SMI";
    public static final String DELETE_POOL_OPERATION = "pool deletion";
    private final AllocatedPool myPool;

    public DeletePoolRecipe(StorageSystem storageSystem, AllocatedPool allocatedPool) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((allocatedPool != null ? 1 : 0) != 0, (String)"thePool != null");
        this.myPool = allocatedPool;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Determine configuration service capabilities");
        ConfigService configService = this.getStorageSystem().getConfigService();
        ConfigCapabilities configCapabilities = configService.getConfigCapabilities();
        if (!configCapabilities.getPoolDeletion().isSupported()) {
            this.failOperationNotSupported("DELETE_POOL_OPERATION");
        }
        this.traceStep(2, "Verify the state of the pool will allow delete");
        this.traceStep(3, "Delete Storage Pool");
        ConfigJob[] configJobArray = new ConfigJob[1];
        configService.deletePool(this.myPool, configJobArray);
        if (configJobArray[0] != null) {
            this.setConfigJob(configJobArray[0]);
        } else if (configCapabilities.getPoolDeletion().isAsync()) {
            this.failOperationFailed("DELETE_POOL_OPERATION");
        }
    }
}

