/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.AllocatedPool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.CreateElementRecipe;

public class CreateVolumeRecipe
extends CreateElementRecipe {
    private static final String SCCS_ID = "@(#)CreateVolumeRecipe.java 1.5   03/09/19 SMI";
    public static final String CREATE_VOLUME_OPERATION = "volume creation";
    private final AllocatedPool myRequestedPool;
    private Volume myVolume = null;

    public CreateVolumeRecipe(StorageSystem storageSystem, StorageSetting storageSetting, long l, AllocatedPool allocatedPool) {
        super(storageSystem, storageSetting, l);
        this.myRequestedPool = allocatedPool;
    }

    public CreateVolumeRecipe(StorageSystem storageSystem, StorageSetting storageSetting, long l) {
        this(storageSystem, storageSetting, l, null);
    }

    public final boolean hasVolume() {
        return this.myVolume != null;
    }

    public final Volume getVolume() {
        return this.myVolume;
    }

    protected final void setVolume(Volume volume) {
        this.myVolume = volume;
    }

    protected void checkCreateSupported(ConfigCapabilities configCapabilities) {
        if (!configCapabilities.getElementCreation().isSupported() || !configCapabilities.isVolumeSupported()) {
            this.failOperationNotSupported("CREATE_VOLUME_OPERATION");
        }
    }

    protected Pool[] getSourcePools() {
        Pool[] poolArray;
        if (this.myRequestedPool != null) {
            Pool[] poolArray2 = new AllocatedPool[1];
            poolArray = poolArray2;
            poolArray2[0] = this.myRequestedPool;
        } else {
            poolArray = this.getStorageSystem().getAllocatedPools();
        }
        Pool[] poolArray3 = poolArray;
        return poolArray3;
    }

    protected void doCreate(Pool pool, VolumeSetting volumeSetting, long l) {
        AllocatedPool allocatedPool;
        String string = this.traceEntry("doCreate()", new Object[]{pool, volumeSetting, new Long(l)});
        boolean bl = true;
        AllocatedPool allocatedPool2 = allocatedPool = pool instanceof AllocatedPool ? (AllocatedPool)pool : null;
        if (allocatedPool != null) {
            Volume[] volumeArray = new Volume[1];
            ConfigJob[] configJobArray = new ConfigJob[1];
            allocatedPool.createVolume(volumeSetting, l, volumeArray, configJobArray);
            if (volumeArray[0] != null || configJobArray[0] != null) {
                this.setVolume(volumeArray[0]);
                this.setConfigJob(configJobArray[0]);
                bl = false;
            }
        }
        if (bl) {
            this.failOperationFailed("CREATE_VOLUME_OPERATION");
        }
        this.traceReturn(string);
    }
}

