/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.InitiatorRecipe;

public class CreateHardwareIDRecipe
extends InitiatorRecipe {
    private static final String SCCS_ID = "@(#)CreateHardwareIDRecipe.java 1.3   03/08/29 SMI";
    public static final String CREATE_HARDWAREID_OPERATION = "create hardware id";
    private final StorageSystem myStorageSystem;
    private final String myHardwareIDName;
    private HardwareID myHardwareID = null;

    public CreateHardwareIDRecipe(StorageSystem storageSystem, String string) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theHardwareIDName != null");
        this.myStorageSystem = storageSystem;
        this.myHardwareIDName = string;
    }

    public final boolean hasHardwareID() {
        return this.myHardwareID != null;
    }

    public final HardwareID getHardwareID() {
        return this.myHardwareID;
    }

    protected final void setHardwareID(HardwareID hardwareID) {
        this.myHardwareID = hardwareID;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Locate the StorageHardwareIDManagementService.");
        HardwareIDManagementService hardwareIDManagementService = this.myStorageSystem.getHardwareIDManagementService();
        this.traceStep(2, "Create the hardware id.");
        HardwareID[] hardwareIDArray = new HardwareID[1];
        hardwareIDManagementService.CreateStorageHardwareID(this.myHardwareIDName, hardwareIDArray);
        this.traceStep(3, "Retrive the new hardware id created from the output.");
        if (hardwareIDArray[0] != null) {
            this.setHardwareID(hardwareIDArray[0]);
        } else {
            this.failOperationFailed("CREATE_HARDWAREID_OPERATION");
        }
    }
}

