/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ConfigJob;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.ArrayRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Localization;

public abstract class ConfigRecipe
extends ArrayRecipe {
    private static final String SCCS_ID = "@(#)ConfigRecipe.java 1.5   03/10/27 SMI";
    public static final String NO_SOURCE_POOL_FOUND = "The storage system ({0}) does not have a source pool(either not properly specified or one could not be found).";
    public static final String NO_SOURCE_POOL_MEETS_CRITERIA = "The storage system ({0}) does not have a source poolthat satisfies the requested capabilities:\n\tNo single point of failure: {1}\n\tData Redundancy: {2}\n\tPackage Redundancy: {3}\n\tDelta Reservation: {4}\n";
    private ConfigJob myConfigJob = null;

    public ConfigRecipe(StorageSystem storageSystem) {
        super(storageSystem);
    }

    public final boolean hasConfigJob() {
        return this.myConfigJob != null;
    }

    public final ConfigJob getConfigJob() {
        return this.myConfigJob;
    }

    public final void setConfigJob(ConfigJob configJob) {
        this.myConfigJob = configJob;
    }

    protected final void failNoSourcePoolFound() {
        String[] stringArray = new String[]{this.getStorageSystem().getName()};
        this.failRecipe(Localization.RES_NO_SOURCE_POOL_FOUND, stringArray);
    }

    protected final void failNoSourcePoolMeetsCriteria(StorageSetting storageSetting) {
        String[] stringArray = new String[]{this.getStorageSystem().getName(), String.valueOf(storageSetting.isNoSinglePointOfFailure()), String.valueOf(storageSetting.getDataRedundancy()), String.valueOf(storageSetting.getPackageRedundancy()), String.valueOf(storageSetting.getDeltaReservation())};
        this.failRecipe(Localization.RES_NO_SOURCE_POOL_MEETS_CRITERIA, stringArray);
    }
}

