/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.ControllerConfigService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.MaskingCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolController;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.AccessRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Localization;

public class AttachDeviceRecipe
extends AccessRecipe {
    private static final String SCCS_ID = "@(#)AttachDeviceRecipe.java 1.11   04/05/10 SMI";
    public static final String ATTACH_DEVICE_OPERATION = "attach device";
    public static final String ATTACH_DEVICE_CANNOT_SELECT_DEVICE_NUMBER = "The user cannot specify the device number.";
    private int myDeviceNumber;
    private StorageSystem myStorageSystem;
    private int myDeviceNumberResult;

    public AttachDeviceRecipe(StorageSystem storageSystem, Volume volume, FCPort[] fCPortArray, int n) {
        super(storageSystem, volume, fCPortArray);
        this.init(storageSystem, n);
    }

    public AttachDeviceRecipe(StorageSystem storageSystem, Volume volume, String[] stringArray, int n) {
        super(storageSystem, volume, stringArray);
        this.init(storageSystem, n);
    }

    public AttachDeviceRecipe(StorageSystem storageSystem, String string, String[] stringArray, int n) {
        super(storageSystem, string, stringArray);
        this.init(storageSystem, n);
    }

    private void init(StorageSystem storageSystem, int n) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((n >= 0 ? 1 : 0) != 0, (String)"theDeviceNumber >= 0");
        this.myStorageSystem = storageSystem;
        this.myDeviceNumber = n;
    }

    public final int getDeviceNumberResult() {
        return this.myDeviceNumberResult;
    }

    public final void setDeviceNumberResult(String string) {
        this.myDeviceNumberResult = Integer.parseInt(string, 16);
    }

    protected final void failCouldNotSelectDeviceNumber() {
        this.failRecipe(Localization.RES_ATTACH_DEVICE_CANNOT_SELECT_DEVICE_NUMBER);
    }

    protected void cookRecipe() {
        this.traceStep(1, "Get the ControllerConfigurationService for the system and determine the capabilities.");
        ControllerConfigService controllerConfigService = this.myStorageSystem.getControllerConfigService();
        MaskingCapabilities maskingCapabilities = this.myStorageSystem.getMaskingCapabilities();
        if (!maskingCapabilities.isAttachDeviceSupported()) {
            this.failOperationNotSupported("ATTACH_DEVICE_OPERATION");
        }
        if (!maskingCapabilities.isClientSelectableDeviceNumbers()) {
            this.failCouldNotSelectDeviceNumber();
        }
        this.traceStep(2, "Use the service's `CreateProtocolController` method to create the view and pass in the desired ports and controller name for the view as arguments.");
        ProtocolController[] protocolControllerArray = new ProtocolController[1];
        controllerConfigService.createController(this.getFCPorts(), protocolControllerArray);
        if (protocolControllerArray[0] == null) {
            this.failCreateController();
        }
        this.traceStep(3, "Attach the volume to the device number: " + this.myDeviceNumber);
        String[] stringArray = new String[1];
        controllerConfigService.attachDevice(protocolControllerArray[0], this.getVolume(), Integer.toHexString(this.myDeviceNumber).toUpperCase(), stringArray);
        this.traceStep(4, "The actual device number returned: " + stringArray[0]);
        if (stringArray[0] != null && Integer.toHexString(this.myDeviceNumber).equalsIgnoreCase(stringArray[0])) {
            this.setDeviceNumberResult(stringArray[0]);
        } else {
            this.traceWarning("cookRecipe()", "AttachDevice result (" + stringArray[0] + ") does not" + " match requested device number (" + this.myDeviceNumber + ")");
        }
    }
}

