/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.SystemSpecificCollection;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.InitiatorRecipe;

public class AddToCollectionRecipe
extends InitiatorRecipe {
    private static final String SCCS_ID = "@(#)AddToCollectionRecipe.java 1.2   03/08/21 SMI";
    private final StorageSystem myStorageSystem;
    private final String myCollectionName;
    private final String[] myHardwareIDs;

    public AddToCollectionRecipe(StorageSystem storageSystem, String string, String[] stringArray) {
        super(storageSystem);
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theCollectionName != null");
        Contract.requires((stringArray != null ? 1 : 0) != 0, (String)"theHardwareIDs != null");
        Contract.requires((stringArray.length > 0 ? 1 : 0) != 0, (String)"theHardwareIDs.length > 0");
        this.myStorageSystem = storageSystem;
        this.myCollectionName = string;
        this.myHardwareIDs = stringArray;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Locate the StorageHardwareIDManagementService.");
        HardwareIDManagementService hardwareIDManagementService = this.myStorageSystem.getHardwareIDManagementService();
        this.traceStep(2, "Find the SystemSpecificCollection of the given colection name.");
        SystemSpecificCollection systemSpecificCollection = hardwareIDManagementService.getCollection(this.myCollectionName);
        if (systemSpecificCollection == null) {
            this.failInvalidGroup(this.myCollectionName);
        }
        this.traceStep(3, "Add the members to the collection.");
        hardwareIDManagementService.AddHardwareIDsToCollection(systemSpecificCollection, this.myHardwareIDs);
    }
}

