/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes;

import com.sun.netstorage.mgmt.esm.model.cim.recipes.Localization;
import com.sun.netstorage.mgmt.esm.util.l10n.Formatter;
import com.sun.netstorage.mgmt.esm.util.l10n.FormatterException;
import com.sun.netstorage.mgmt.esm.util.l10n.Localizable;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableThrowable;
import com.sun.netstorage.mgmt.util.StringUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class RecipeMessage
implements Localizable {
    public static final String CAUSE_ERROR = "Error: an internal operation failed due to an unexpected exception:\n\t{0}.";
    private final Resource myResource;
    private final Throwable myCause;
    private final String myLiteralMessage;
    private final ArrayList myMessageArgList = new ArrayList();

    protected RecipeMessage(Resource resource, Throwable throwable, String string) {
        this.myResource = resource;
        this.myCause = throwable;
        this.myLiteralMessage = string;
    }

    public RecipeMessage(Resource resource) {
        this(resource, null, null);
    }

    public RecipeMessage(Resource resource, String[] stringArray) {
        this(resource);
        this.addMessageArgs(stringArray);
    }

    public RecipeMessage(Throwable throwable) {
        this(null, throwable, null);
    }

    public RecipeMessage(String string) {
        this(null, null, string);
    }

    public RecipeMessage(String string, String[] stringArray) {
        this(string);
        this.addMessageArgs(stringArray);
    }

    protected final String getResourceText(Locale locale) {
        String string = null;
        if (this.myResource != null) {
            if (this.hasMessageArgs()) {
                String[] stringArray = this.getMessageArgs();
                Formatter formatter = new Formatter(this.myResource);
                stringArray = formatter.getLocalizedArgs((Serializable[])stringArray, locale);
                try {
                    string = formatter.getFormattedText((Serializable[])stringArray, locale);
                }
                catch (FormatterException formatterException) {
                    string = this.myResource.getLiteralText();
                }
            }
            if (string == null && (string = this.myResource.getLocalizedText(locale)) == null) {
                string = this.myResource.getLiteralText();
            }
        }
        return string;
    }

    protected final String getCauseText(Locale locale) {
        String string;
        block4: {
            string = null;
            if (this.myCause == null) break block4;
            if (this.myCause instanceof LocalizableThrowable) {
                LocalizableThrowable localizableThrowable = (LocalizableThrowable)this.myCause;
                string = localizableThrowable.getLocalizedMessage(locale);
            } else {
                try {
                    String[] stringArray = new String[]{this.myCause.toString(), StringUtils.getStackTrace((Throwable)this.myCause)};
                    string = Localization.FMT_CAUSE_ERROR.getFormattedText((Serializable[])stringArray, locale);
                }
                catch (FormatterException formatterException) {
                    string = Localization.RES_CAUSE_ERROR.getLiteralText();
                }
            }
        }
        return string;
    }

    public final String getCauseDetails() {
        String string = null;
        if (this.myCause != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.myCause.printStackTrace(printWriter);
            string = stringWriter.toString();
        }
        return string;
    }

    protected final String getLiteralMessageText() {
        String string = null;
        if (this.myLiteralMessage != null) {
            if (this.hasMessageArgs()) {
                String[] stringArray = this.getMessageArgs();
                Resource resource = new Resource("foo", "bar", this.myLiteralMessage);
                Formatter formatter = new Formatter(resource);
                try {
                    string = formatter.getLiteralFormattedText((Serializable[])stringArray);
                }
                catch (FormatterException formatterException) {
                    // empty catch block
                }
            }
            if (string == null) {
                string = this.myLiteralMessage;
            }
        }
        return string;
    }

    protected boolean hasMessageArgs() {
        return this.myMessageArgList.size() > 0;
    }

    public final void addMessageArg(String string) {
        this.myMessageArgList.add(string);
    }

    public final void addMessageArgs(String[] stringArray) {
        this.myMessageArgList.addAll(Arrays.asList(stringArray));
    }

    protected String[] getMessageArgs() {
        String[] stringArray = this.myMessageArgList.toArray(new String[this.myMessageArgList.size()]);
        return stringArray;
    }

    public final String toStringWithDetails() {
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        String string = this.getCauseDetails();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public final String getLocalizedText() {
        return this.getLocalizedText(Locale.getDefault());
    }

    public final String getLocalizedText(Locale locale) {
        String string = null;
        if (this.myResource != null) {
            string = this.getResourceText(locale);
        } else if (this.myCause != null) {
            string = this.getCauseText(locale);
        } else if (this.myLiteralMessage != null) {
            string = this.getLiteralMessageText();
        }
        return string;
    }

    public String toString() {
        return this.getLocalizedText();
    }
}

