/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes;

import com.sun.netstorage.mgmt.esm.model.cim.recipes.Localization;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.RecipeMessage;
import com.sun.netstorage.mgmt.esm.util.l10n.Localizable;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.util.ArrayList;
import java.util.Locale;

public class RecipeFailure
implements Localizable {
    public static final int RETURN_CODE_DEFAULT = Integer.MIN_VALUE;
    public static final String RETURN_CODE_ERROR = "Error: an internal operation failed with return code {0} ({1}).";
    public static final String ERROR_OP_NOT_SUPPORTED = "This operation ({0}) is not implemented yet.";
    private final int myReturnCode;
    private Throwable myCause = null;
    private final ArrayList myMessageList = new ArrayList();

    public static RecipeFailure createOpNotSupported(String string) {
        return new RecipeFailure(Localization.RES_ERROR_OP_NOT_SUPPORTED, new String[]{string});
    }

    private RecipeFailure(int n, Throwable throwable) {
        this.myReturnCode = n;
        this.myCause = throwable;
    }

    public RecipeFailure(int n) {
        this(n, null);
        String[] stringArray = new String[]{String.valueOf(n), "n/a"};
        this.addMessage(new RecipeMessage(Localization.RES_RETURN_CODE_ERROR, stringArray));
    }

    public RecipeFailure(Throwable throwable) {
        this(Integer.MIN_VALUE, throwable);
        this.addMessage(new RecipeMessage(throwable));
    }

    public RecipeFailure(Resource resource, String[] stringArray) {
        this(Integer.MIN_VALUE);
        this.addMessage(new RecipeMessage(resource, stringArray));
    }

    public RecipeFailure(Resource resource) {
        this(resource, null);
    }

    public RecipeFailure() {
        this(Integer.MIN_VALUE, null);
    }

    public boolean hasReturnCode() {
        return this.myReturnCode != Integer.MIN_VALUE;
    }

    public int getReturnCode() {
        return this.myReturnCode;
    }

    public final boolean hasCause() {
        return this.myCause != null;
    }

    public final Throwable getCause() {
        return this.myCause;
    }

    public final void setCause(Throwable throwable) {
        this.myCause = throwable;
    }

    private boolean hasMessages() {
        return this.myMessageList.size() > 0;
    }

    public final void addMessage(RecipeMessage recipeMessage) {
        this.myMessageList.add(recipeMessage);
    }

    public final void addMessage(Resource resource) {
        RecipeMessage recipeMessage = new RecipeMessage(resource);
        this.addMessage(recipeMessage);
    }

    public final void addMessage(Resource resource, String[] stringArray) {
        RecipeMessage recipeMessage = new RecipeMessage(resource, stringArray);
        this.addMessage(recipeMessage);
    }

    public final RecipeMessage[] getMessages() {
        RecipeMessage[] recipeMessageArray = this.myMessageList.toArray(new RecipeMessage[this.myMessageList.size()]);
        return recipeMessageArray;
    }

    public final String getLocalizedText() {
        return this.getLocalizedText(Locale.getDefault());
    }

    public final String getLocalizedText(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        RecipeMessage[] recipeMessageArray = this.getMessages();
        int n = 0;
        while (n < recipeMessageArray.length) {
            String string = recipeMessageArray[n].getLocalizedText(locale);
            if (n > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getLocalizedText();
    }
}

