/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes;

import com.sun.netstorage.mgmt.esm.model.cim.CimContext;
import com.sun.netstorage.mgmt.esm.model.cim.CimObjectException;
import com.sun.netstorage.mgmt.esm.model.cim.TraceableObject;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.RecipeFailure;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.RecipeStepException;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;

public abstract class Recipe
extends TraceableObject
implements Runnable {
    public static final String INTERNAL_ERROR = "internal error occurred: {0}";
    private final CimContext myContext;
    private boolean myRun = false;
    private boolean mySuccess = false;
    private RecipeFailure myFailure = null;

    public Recipe(CimContext cimContext) {
        Contract.requires((cimContext != null ? 1 : 0) != 0, (String)"theContext != null");
        this.myContext = cimContext;
    }

    protected final CimContext getContext() {
        Contract.ensures((this.myContext != null ? 1 : 0) != 0, (String)"CimContext != null");
        return this.myContext;
    }

    public final boolean wasRun() {
        return this.myRun;
    }

    protected final void checkRun() {
        Contract.guarantees((boolean)this.wasRun(), (String)"wasRun()");
    }

    private void setRun() {
        this.myRun = true;
    }

    public final boolean wasSuccess() {
        return this.mySuccess;
    }

    private void setSuccess() {
        this.mySuccess = true;
    }

    public final boolean wasFailure() {
        return this.myFailure != null;
    }

    public final RecipeFailure getFailure() {
        return this.myFailure;
    }

    protected final void setFailure(RecipeFailure recipeFailure) {
        Contract.requires((recipeFailure != null ? 1 : 0) != 0, (String)"theFailure != null");
        this.myFailure = recipeFailure;
        this.traceInfo(this.myFailure.toString());
    }

    protected final void setFailure(String string) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theMessage != null");
        Resource resource = new Resource("foo", "bar", string);
        this.setFailure(new RecipeFailure(resource));
    }

    protected final void setFailure(RecipeStepException recipeStepException) {
        Contract.requires((recipeStepException != null ? 1 : 0) != 0, (String)"theCause != null");
        this.setFailure(new RecipeFailure((Throwable)((Object)recipeStepException)));
    }

    protected final void setFailure(CimObjectException cimObjectException) {
        Contract.requires((cimObjectException != null ? 1 : 0) != 0, (String)"theCause != null");
        this.setFailure(new RecipeFailure((Throwable)((Object)cimObjectException)));
    }

    protected final void setFailure(Throwable throwable) {
        Contract.requires((throwable != null ? 1 : 0) != 0, (String)"theCause != null");
        this.setFailure(new RecipeFailure(throwable));
    }

    protected abstract void cookRecipe();

    protected final void failRecipe(Resource resource, String[] stringArray) throws RecipeStepException {
        throw new RecipeStepException(resource, stringArray);
    }

    protected final void failRecipe(Resource resource) throws RecipeStepException {
        throw new RecipeStepException(resource);
    }

    protected final void failRecipe(String string) throws RecipeStepException {
        Resource resource = new Resource("fubar", "foo", string);
        throw new RecipeStepException(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        String string;
        block7: {
            string = this.traceEntry("run()");
            if (!this.wasRun()) {
                try {
                    try {
                        this.traceRecipeStart();
                        this.cookRecipe();
                        this.setSuccess();
                    }
                    catch (RecipeStepException recipeStepException) {
                        this.setFailure(recipeStepException);
                        Object var6_3 = null;
                        this.setRun();
                        this.traceRecipeFinish();
                        break block7;
                    }
                    catch (CimObjectException cimObjectException) {
                        this.setFailure(cimObjectException);
                        Object var6_4 = null;
                        this.setRun();
                        this.traceRecipeFinish();
                        break block7;
                    }
                    catch (Throwable throwable) {
                        this.setFailure(throwable);
                        Object var6_5 = null;
                        this.setRun();
                        this.traceRecipeFinish();
                        break block7;
                    }
                    Object var6_2 = null;
                    this.setRun();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.setRun();
                    this.traceRecipeFinish();
                    throw throwable;
                }
                this.traceRecipeFinish();
            }
        }
        this.traceReturn(string);
    }
}

