/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.net;

import com.sun.netstorage.mgmt.esm.model.cim.net.CimomConstants;
import com.sun.netstorage.mgmt.esm.model.cim.net.CimomLocator;
import com.sun.netstorage.mgmt.esm.model.cim.net.CimomURL;
import com.sun.netstorage.mgmt.esm.model.cim.net.SlpTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class CimomProperties
implements CimomConstants {
    private static final String SCCS_ID = "@(#)CimomProperties.java 1.6   03/12/03 SMI";
    public static final String FILENAME_DEFAULT = "cimom.properties";
    public static final String FILE_HEADER = "CIMOM attributes as discovered via SLP";
    private final Properties myProperties;
    private String myCimomUID = null;
    private CimomURL myCimomURL = null;
    private Set myFunctionalProfilesSupported = null;
    private Set myRegisteredProfilesSupported = null;

    public static String[] toStringArray(String string) {
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    public CimomProperties(Properties properties) {
        this.myProperties = properties != null ? properties : System.getProperties();
    }

    public CimomProperties() {
        this(new Properties());
    }

    public final Properties toProperties() {
        return this.myProperties;
    }

    public final String getProperty(String string) {
        return this.myProperties.getProperty(string);
    }

    public final void setProperty(String string, String string2) {
        if (string != null && string2 != null) {
            this.myProperties.setProperty(string, string2);
        }
    }

    public final void setProperty(SlpTypes.SlpAttribute slpAttribute, String string) {
        if (slpAttribute != null) {
            String string2 = slpAttribute.toString();
            this.myProperties.setProperty(string2, string);
        }
    }

    public final String getCimomUID() {
        CimomURL cimomURL;
        if (this.myCimomUID == null && (cimomURL = this.getCimomURL()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cimomURL.getCanonicalHost());
            stringBuffer.append(':');
            stringBuffer.append(cimomURL.getCanonicalPort());
            this.myCimomUID = stringBuffer.toString();
        }
        return this.myCimomUID;
    }

    public final CimomURL getCimomURL() {
        block6: {
            if (this.myCimomURL != null) break block6;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                String string = this.getServiceProtocol();
                URI uRI = this.getServiceURI();
                if (string != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(":");
                }
                stringBuffer.append("//");
                if (uRI.getUserInfo() != null) {
                    stringBuffer.append(uRI.getUserInfo());
                    stringBuffer.append("@");
                }
                stringBuffer.append(uRI.getHost());
                if (uRI.getPort() > 0) {
                    stringBuffer.append(":");
                    stringBuffer.append(uRI.getPort());
                }
                this.myCimomURL = CimomURL.createCanonicalURL(stringBuffer.toString());
                if (this.myCimomURL == null) {
                    System.err.println("JTB: failed to build CimomURL: " + stringBuffer.toString());
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        return this.myCimomURL;
    }

    public final Set getFunctionalProfilesSupported() {
        if (this.myFunctionalProfilesSupported == null) {
            this.myFunctionalProfilesSupported = this.getValueSet("FunctionalProfilesSupported");
        }
        return this.myFunctionalProfilesSupported;
    }

    public final boolean isFunctionalProfileSupported(String string) {
        return this.getFunctionalProfilesSupported().contains(string);
    }

    public final Set getRegisteredProfilesSupported() {
        if (this.myRegisteredProfilesSupported == null) {
            this.myRegisteredProfilesSupported = this.getValueSet("RegisteredProfilesSupported");
        }
        return this.myRegisteredProfilesSupported;
    }

    public final boolean isServerProfileSupported() {
        return this.getRegisteredProfilesSupported().contains("SNIA:Server");
    }

    public final boolean isArrayProfileSupported() {
        return this.getRegisteredProfilesSupported().contains("SNIA:Array");
    }

    public final boolean isFabricProfileSupported() {
        return this.getRegisteredProfilesSupported().contains("SNIA:Fabric");
    }

    private URI getServiceURI() {
        URI uRI;
        block8: {
            String string;
            uRI = null;
            try {
                string = this.getServiceAddress();
                if (string != null) {
                    uRI = new URI(string);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                System.err.println("JTB: URI bug: " + uRISyntaxException);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (uRI != null) break block8;
            try {
                string = CimomLocator.getKey(this);
                if (string != null) {
                    int n = string.indexOf("http");
                    String string2 = string.substring(n);
                    uRI = new URI(string2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                System.err.println("JTB: URI bug: " + uRISyntaxException);
            }
            catch (RuntimeException runtimeException) {}
        }
        return uRI;
    }

    public final String getServiceName() {
        return this.myProperties.getProperty("CimomLocator.key");
    }

    public final String getServiceId() {
        return this.myProperties.getProperty("service-id");
    }

    public final String getServiceAddress() {
        return this.myProperties.getProperty("service-location-tcp");
    }

    public final String getServiceProtocol() {
        String string = this.myProperties.getProperty("CommunicationMechanism");
        if (string != null) {
            string = string.toLowerCase();
        }
        return string;
    }

    public final String getInteropNameSpace() {
        String string = this.myProperties.getProperty("CIM_InteropSchemaNamespace");
        if (string == null) {
            string = "interop";
        }
        return string;
    }

    private Set getValueSet(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = this.myProperties.getProperty(string);
        if (string2 != null) {
            String[] stringArray = CimomProperties.toStringArray(string2);
            hashSet.addAll(Arrays.asList(stringArray));
        }
        return hashSet;
    }

    public final boolean load(File file, String string) {
        boolean bl = false;
        try {
            File file2 = new File(file, string);
            if (file2.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file2);
                this.myProperties.load(fileInputStream);
                fileInputStream.close();
                bl = true;
            }
        }
        catch (IOException iOException) {}
        return bl;
    }

    public final boolean load(File file) {
        boolean bl = this.load(file, FILENAME_DEFAULT);
        return bl;
    }

    public final boolean store(File file, String string) {
        boolean bl = false;
        try {
            File file2 = new File(file, string);
            if (file2.exists()) {
                // empty if block
            }
            if (!file2.exists() || file2.canWrite()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                this.myProperties.store(fileOutputStream, FILE_HEADER);
                fileOutputStream.close();
                bl = true;
            }
        }
        catch (IOException iOException) {}
        return bl;
    }

    public final boolean store(File file) {
        boolean bl = this.store(file, FILENAME_DEFAULT);
        return bl;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.myProperties.list(printWriter);
        return stringWriter.toString();
    }
}

