/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.net;

import com.sun.netstorage.mgmt.esm.model.cim.net.CimomPasswordAccessor;
import com.sun.netstorage.mgmt.esm.model.cim.net.CimomURL;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;

public final class CimomPassword {
    private static final String SCCS_ID = "@(#)CimomPassword.java 1.7   04/03/05 SMI";
    public static final String CLEAR_SCHEME = "password";
    public static final String PROPERTY_SCHEME = "property";
    public static final String FILE_SCHEME = "file";
    public static final String CLASS_SCHEME = "class";
    private static boolean ourDebug = false;
    private static HashMap ourIndirectionSchemes = new HashMap();

    public static void addIndirectionScheme(IndirectionScheme indirectionScheme) {
        if (indirectionScheme != null) {
            String string = indirectionScheme.getName().toLowerCase();
            ourIndirectionSchemes.put(string, indirectionScheme);
        }
    }

    public static IndirectionScheme getIndirectionScheme(String string) {
        IndirectionScheme indirectionScheme = null;
        if (string != null) {
            String string2 = string.toLowerCase();
            if (ourIndirectionSchemes.size() == 0) {
                CimomPassword.initIndirectionSchemes();
            }
            indirectionScheme = (IndirectionScheme)ourIndirectionSchemes.get(string2);
        }
        return indirectionScheme;
    }

    private static void initIndirectionSchemes() {
        CimomPassword.addIndirectionScheme(new NoIndirectionScheme());
        CimomPassword.addIndirectionScheme(new PropertyIndirectionScheme());
        CimomPassword.addIndirectionScheme(new FileIndirectionScheme());
        CimomPassword.addIndirectionScheme(new ClassIndirectionScheme());
    }

    public static String getPassword(CimomURL cimomURL, String string, String string2) {
        IndirectionScheme indirectionScheme = CimomPassword.getIndirectionScheme(string);
        if (indirectionScheme == null) {
            CimomPassword.debug("fallback to default indirection scheme");
            indirectionScheme = new NoIndirectionScheme();
        }
        return indirectionScheme.getPassword(cimomURL, string2);
    }

    private static void debug(String string) {
        if (ourDebug) {
            System.err.println(string);
        }
    }

    public static void main(String[] stringArray) {
        ourDebug = true;
        CimomPassword.testFile(null, "/var/adm/cimom/127.0.0.1/.root");
        CimomURL cimomURL = CimomURL.create("cim-xml://pickle@123.123.123.123?file=/var/adm/cimom/123.123.123.123/.pickle");
        CimomPassword.testFile(cimomURL, "");
    }

    private static void testFile(CimomURL cimomURL, String string) {
        String string2 = CimomPassword.getPassword(cimomURL, FILE_SCHEME, string);
        System.err.println("password = \"" + string2 + "\"");
    }

    private CimomPassword() {
    }

    public static final class ClassIndirectionScheme
    extends IndirectionScheme {
        public ClassIndirectionScheme() {
            super(CimomPassword.CLASS_SCHEME);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private CimomPasswordAccessor newAccessor(Class clazz) {
            CimomPasswordAccessor cimomPasswordAccessor = null;
            try {
                Class[] classArray = new Class[]{};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{};
                Object t = constructor.newInstance(objectArray);
                if (!(t instanceof CimomPasswordAccessor)) return cimomPasswordAccessor;
                cimomPasswordAccessor = (CimomPasswordAccessor)t;
                return cimomPasswordAccessor;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            finally {
                return cimomPasswordAccessor;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private CimomPasswordAccessor getAccessor(Class clazz) {
            CimomPasswordAccessor cimomPasswordAccessor = null;
            try {
                String string = "getInstance";
                Class[] classArray = new Class[]{};
                Method method = clazz.getMethod(string, classArray);
                Object[] objectArray = new Object[]{};
                Object object = method.invoke(null, objectArray);
                if (!(object instanceof CimomPasswordAccessor)) return cimomPasswordAccessor;
                cimomPasswordAccessor = (CimomPasswordAccessor)object;
                return cimomPasswordAccessor;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            finally {
                return cimomPasswordAccessor;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final String getPassword(CimomURL cimomURL, String string) {
            String string2 = null;
            if (string == null || string.length() <= 0) return string2;
            try {
                Class<?> clazz = Class.forName(string);
                CimomPasswordAccessor cimomPasswordAccessor = this.newAccessor(clazz);
                if (cimomPasswordAccessor == null) {
                    cimomPasswordAccessor = this.getAccessor(clazz);
                }
                if (cimomPasswordAccessor == null) return string2;
                String string3 = cimomURL != null ? cimomURL.getUser() : "root";
                String string4 = cimomURL != null ? cimomURL.getHost() : "localhost";
                char[] cArray = cimomPasswordAccessor.getPassword(string3, string4);
                string2 = new String(cArray);
                return string2;
            }
            catch (ClassNotFoundException classNotFoundException) {}
            finally {
                return string2;
            }
        }
    }

    public static final class FileIndirectionScheme
    extends IndirectionScheme {
        public FileIndirectionScheme() {
            super(CimomPassword.FILE_SCHEME);
        }

        public final String getPassword(CimomURL cimomURL, String string) {
            String string2;
            block6: {
                Object object;
                Object object2;
                Comparable<StringBuffer> comparable;
                string2 = null;
                String string3 = string;
                if (string3 == null || string3.length() == 0 || "DEFAULT".equals(string3)) {
                    comparable = new StringBuffer();
                    object2 = cimomURL != null ? cimomURL.getUser() : "root";
                    object = cimomURL != null ? cimomURL.getCanonicalHost() : "localhost";
                    ((StringBuffer)comparable).append("/var/adm/cimom/");
                    ((StringBuffer)comparable).append((String)object);
                    ((StringBuffer)comparable).append("/.");
                    ((StringBuffer)comparable).append((String)object2);
                    string3 = ((StringBuffer)comparable).toString();
                }
                try {
                    comparable = new File(string3);
                    if (((File)comparable).exists() && ((File)comparable).canRead()) {
                        object2 = new FileReader((File)comparable);
                        object = new BufferedReader((Reader)object2);
                        string2 = ((BufferedReader)object).readLine();
                        ((BufferedReader)object).close();
                    } else if (ourDebug) {
                        CimomPassword.debug("file=" + string3 + " not accessible");
                    }
                }
                catch (IOException iOException) {
                    if (!ourDebug) break block6;
                    CimomPassword.debug("file=" + string3 + " failed because:");
                    iOException.printStackTrace(System.err);
                }
            }
            return string2;
        }
    }

    public static final class PropertyIndirectionScheme
    extends IndirectionScheme {
        public PropertyIndirectionScheme() {
            super(CimomPassword.PROPERTY_SCHEME);
        }

        public final String getPassword(CimomURL cimomURL, String string) {
            String string2 = string;
            if (string2 == null) {
                String string3 = cimomURL != null ? cimomURL.getUser() : "root";
                String string4 = cimomURL != null ? cimomURL.getHost() : "localhost";
                string2 = string3 + '@' + string4;
            }
            return System.getProperty(string2, null);
        }
    }

    public static final class NoIndirectionScheme
    extends IndirectionScheme {
        public NoIndirectionScheme() {
            super(CimomPassword.CLEAR_SCHEME);
        }

        public final String getPassword(CimomURL cimomURL, String string) {
            return string;
        }
    }

    public static abstract class IndirectionScheme {
        private final String myName;

        public IndirectionScheme(String string) {
            this.myName = string;
        }

        public final String getName() {
            return this.myName;
        }

        public abstract String getPassword(CimomURL var1, String var2);

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof IndirectionScheme) {
                IndirectionScheme indirectionScheme = (IndirectionScheme)object;
                if (this.myName.equals(indirectionScheme.myName)) {
                    bl = true;
                }
            }
            return bl;
        }

        public final int hashCode() {
            return this.myName.hashCode();
        }
    }
}

