/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.common;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.LogicalDevice;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Privilege;
import java.util.ArrayList;
import javax.wbem.cim.CIMObjectPath;

public class ProtocolController
extends LogicalDevice {
    private final StorageSystem myStorageSystem;
    private Privilege[] myPrivileges = null;
    private FCPort[] myFCPorts = null;

    public static ProtocolController create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        ProtocolController protocolController = null;
        if (cIMObjectPath != null) {
            protocolController = new ProtocolController(storageSystem, cIMObjectPath);
        }
        return protocolController;
    }

    public static ProtocolController[] create(StorageSystem storageSystem, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        Contract.requires((cIMObjectPathArray != null ? 1 : 0) != 0, (String)"theNames != null");
        ProtocolController[] protocolControllerArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<ProtocolController> arrayList = new ArrayList<ProtocolController>(cIMObjectPathArray.length);
            int n = 0;
            while (n < cIMObjectPathArray.length) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[n];
                if (cIMObjectPath != null) {
                    ProtocolController protocolController = new ProtocolController(storageSystem, cIMObjectPath);
                    arrayList.add(protocolController);
                }
                ++n;
            }
            protocolControllerArray = arrayList.toArray(new ProtocolController[arrayList.size()]);
        } else {
            protocolControllerArray = new ProtocolController[]{};
        }
        Contract.ensures((protocolControllerArray != null ? 1 : 0) != 0, (String)"result != null");
        return protocolControllerArray;
    }

    public ProtocolController(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    private final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    public final Privilege[] getPrivileges() {
        if (this.myPrivileges == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_AuthorizedTarget", "CIM_Privilege");
            this.myPrivileges = Privilege.create(this.getStorageSystem(), cIMObjectPathArray);
        }
        return this.myPrivileges;
    }

    public final FCPort[] getFCPorts() {
        if (this.myFCPorts == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_ProtocolControllerForPort", "CIM_FCPort");
            this.myFCPorts = FCPort.create(this.myStorageSystem, cIMObjectPathArray);
        }
        return this.myFCPorts;
    }

    public final int getMaxUnitsControlled() {
        int n = this.getPropertyValue("MaxUnitsControlled").intValue();
        return n;
    }
}

