/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.CimArgumentMap;
import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_PrivilegeManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.AbstractService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.ManagedElement;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Privilege;
import java.util.ArrayList;
import java.util.Iterator;
import javax.wbem.cim.CIMObjectPath;

public final class PrivilegeManagementService
extends AbstractService {
    private static final String SCCS_ID = "@(#)PrivilegeManagementService.java 1.5   04/05/10 SMI";
    private final StorageSystem myStorageSystem;

    public static PrivilegeManagementService create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        PrivilegeManagementService privilegeManagementService = null;
        if (cIMObjectPath != null) {
            privilegeManagementService = new PrivilegeManagementService(storageSystem, cIMObjectPath);
        }
        return privilegeManagementService;
    }

    public PrivilegeManagementService(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    public final void AssignAccess(HardwareID hardwareID, ManagedElement managedElement, boolean bl, boolean bl2, Privilege[] privilegeArray) {
        Contract.requires((hardwareID != null ? 1 : 0) != 0, (String)"theHardwareID != null");
        Contract.requires((managedElement != null ? 1 : 0) != 0, (String)"theElement != null");
        Contract.requires((privilegeArray != null ? 1 : 0) != 0, (String)"thePrivilege != null");
        Contract.requires((privilegeArray.length == 1 ? 1 : 0) != 0, (String)"thePrivilege.length == 1");
        CimArgumentMap cimArgumentMap = CIM_PrivilegeManagementService.AssignAccess.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_PrivilegeManagementService.AssignAccess.Factory.createOutputs();
        cimArgumentMap.getValue("Subject").setValue(hardwareID);
        boolean bl3 = bl || bl2;
        cimArgumentMap.getValue("PrivilegeGranted").setValue(bl3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (bl || !bl3) {
            arrayList.add(new Integer(5));
        }
        if (bl2 || !bl3) {
            arrayList.add(new Integer(6));
        }
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        cimArgumentMap.getValue("Activities").setValue(nArray, CimValue.NumberType.UINT16);
        cimArgumentMap.getValue("Target").setValue(managedElement);
        int n2 = this.intMethod("AssignAccess", cimArgumentMap, cimArgumentMap2);
        if (n2 == 0) {
            privilegeArray[0] = this.getPrivilege(cimArgumentMap2, "Privilege");
        } else {
            this.handleReturnCode(n2, CIM_PrivilegeManagementService.AssignAccess.VALUE_MAP, CIM_PrivilegeManagementService.AssignAccess.VALUES);
        }
    }

    public final void RemoveAccess(HardwareID hardwareID, Privilege privilege, Volume volume) {
        Contract.requires((hardwareID != null ? 1 : 0) != 0, (String)"theHardwareID != null");
        Contract.requires((privilege != null ? 1 : 0) != 0, (String)"thePrivileges != null");
        Contract.requires((volume != null ? 1 : 0) != 0, (String)"theVolume != null");
        CimArgumentMap cimArgumentMap = CIM_PrivilegeManagementService.RemoveAccess.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_PrivilegeManagementService.RemoveAccess.Factory.createOutputs();
        cimArgumentMap.getValue("Subject").setValue(hardwareID);
        cimArgumentMap.getValue("Privilege").setValue(privilege);
        cimArgumentMap.getValue("Target").setValue(volume);
        int n = this.intMethod("RemoveAccess", cimArgumentMap, cimArgumentMap2);
        if (n != 0) {
            this.handleReturnCode(n, CIM_PrivilegeManagementService.AssignAccess.VALUE_MAP, CIM_PrivilegeManagementService.AssignAccess.VALUES);
        }
    }

    private Privilege getPrivilege(CimArgumentMap cimArgumentMap, String string) {
        Privilege privilege = null;
        CIMObjectPath cIMObjectPath = cimArgumentMap.getValue(string).getObjectPathValue();
        if (cIMObjectPath != null) {
            privilege = new Privilege(this.getStorageSystem(), cIMObjectPath);
        }
        return privilege;
    }
}

