/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.model.cim.CimArgumentMap;
import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_StorageCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.AbstractCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Pool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeProfile;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import javax.wbem.cim.CIMObjectPath;

public final class PoolCapabilities
extends AbstractCapabilities {
    private static final String SCCS_ID = "@(#)PoolCapabilities.java 1.11   03/10/27 SMI";
    private final Pool myPool;
    private int myElementType = -1;

    public static PoolCapabilities create(Pool pool, CIMObjectPath cIMObjectPath) {
        Contract.requires((pool != null ? 1 : 0) != 0, (String)"theParent != null");
        PoolCapabilities poolCapabilities = null;
        if (cIMObjectPath != null) {
            poolCapabilities = new PoolCapabilities(pool, cIMObjectPath);
        }
        return poolCapabilities;
    }

    public PoolCapabilities(Pool pool, CIMObjectPath cIMObjectPath) {
        super(pool, cIMObjectPath);
        this.myPool = pool;
    }

    public final Pool getPool() {
        return this.myPool;
    }

    public final int getElementType() {
        if (this.myElementType < 0) {
            this.myElementType = this.getPropertyValue("ElementType").intValue();
        }
        return this.myElementType;
    }

    public final boolean isStorageVolume() {
        return this.getElementType() == 3;
    }

    public final boolean isStorageExtent() {
        return this.getElementType() == 4;
    }

    public final boolean isStoragePool() {
        return this.getElementType() == 5;
    }

    public final boolean isConfigService() {
        return this.getElementType() == 6;
    }

    public final boolean meetsCriteria(boolean bl, int n, int n2, int n3) {
        return this.meetsNoSinglePointOfFailure(bl) && this.meetsDataRedundancy(n) && this.meetsPackageRedundancy(n2);
    }

    public final boolean meetsCriteria(StorageSetting storageSetting) {
        boolean bl = false;
        if (storageSetting != null) {
            boolean bl2 = storageSetting.isNoSinglePointOfFailure();
            int n = storageSetting.getDataRedundancy();
            int n2 = storageSetting.getPackageRedundancy();
            int n3 = storageSetting.getDeltaReservation();
            bl = this.meetsCriteria(bl2, n, n2, n3);
        }
        return bl;
    }

    private boolean meetsNoSinglePointOfFailure(boolean bl) {
        boolean bl2 = false;
        if (bl == this.isNoSinglePointOfFailure()) {
            bl2 = true;
        }
        return bl2;
    }

    public final boolean isNoSinglePointOfFailure() {
        boolean bl = this.getPropertyValue("NoSinglePointOfFailure").booleanValue();
        return bl;
    }

    public final boolean isNoSinglePointOfFailureDefault() {
        boolean bl = this.getPropertyValue("NoSinglePointOfFailureDefault").booleanValue();
        return bl;
    }

    private boolean meetsDataRedundancy(int n) {
        boolean bl = false;
        if (n >= this.getDataRedundancyMin() && n <= this.getDataRedundancyMax()) {
            bl = true;
        }
        return bl;
    }

    public final int getDataRedundancyMin() {
        int n = this.getPropertyValue("DataRedundancyMin").intValue();
        return n;
    }

    public final int getDataRedundancyMax() {
        int n = this.getPropertyValue("DataRedundancyMax").intValue();
        return n;
    }

    public final int getDataRedundancyDefault() {
        int n = this.getPropertyValue("DataRedundancyDefault").intValue();
        return n;
    }

    private boolean meetsPackageRedundancy(int n) {
        boolean bl = false;
        if (n >= this.getPackageRedundancyMin() && n <= this.getPackageRedundancyMax()) {
            bl = true;
        }
        return bl;
    }

    public final int getPackageRedundancyMin() {
        int n = this.getPropertyValue("PackageRedundancyMin").intValue();
        return n;
    }

    public final int getPackageRedundancyMax() {
        int n = this.getPropertyValue("PackageRedundancyMax").intValue();
        return n;
    }

    public final int getPackageRedundancyDefault() {
        int n = this.getPropertyValue("PackageRedundancyDefault").intValue();
        return n;
    }

    private boolean meetsDeltaReservation(int n) {
        boolean bl = false;
        if (n >= this.getDeltaReservationMin() && n <= this.getDeltaReservationMax()) {
            bl = true;
        }
        return bl;
    }

    public final int getDeltaReservationMin() {
        int n = this.getPropertyValue("DeltaReservationMin").intValue();
        return n;
    }

    public final int getDeltaReservationMax() {
        int n = this.getPropertyValue("DeltaReservationMax").intValue();
        return n;
    }

    public final int getDeltaReservationDefault() {
        int n = this.getPropertyValue("DeltaReservationDefault").intValue();
        return n;
    }

    public final VolumeSetting createDefaultSetting() {
        return this.createSetting(2);
    }

    public final VolumeSetting createGoalSetting() {
        return this.createSetting(3);
    }

    protected final VolumeSetting createSetting(int n) {
        VolumeSetting volumeSetting = null;
        CimArgumentMap cimArgumentMap = CIM_StorageCapabilities.CreateSetting.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageCapabilities.CreateSetting.Factory.createOutputs();
        cimArgumentMap.getValue("SettingType").setValue(n, CimValue.NumberType.UINT16);
        int n2 = this.intMethod("CreateSetting", cimArgumentMap, cimArgumentMap2);
        if (n2 == 0) {
            volumeSetting = this.getVolumeSetting(cimArgumentMap2, "NewSetting");
        } else {
            this.handleReturnCode(n2, CIM_StorageCapabilities.CreateSetting.VALUE_MAP, CIM_StorageCapabilities.CreateSetting.VALUES);
        }
        return volumeSetting;
    }

    private VolumeSetting getVolumeSetting(CimArgumentMap cimArgumentMap, String string) {
        VolumeSetting volumeSetting = null;
        CIMObjectPath cIMObjectPath = cimArgumentMap.getValue(string).getObjectPathValue();
        if (cIMObjectPath != null && (volumeSetting = new VolumeSetting(this, cIMObjectPath)).isVolumeProfile()) {
            volumeSetting = new VolumeProfile(this, cIMObjectPath);
        }
        return volumeSetting;
    }
}

