/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.CimArgumentMap;
import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_StoragePool;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.LogicalElement;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PoolCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.VolumeSetting;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.cim.CIMObjectPath;

public class Pool
extends LogicalElement {
    private static final String SCCS_ID = "@(#)Pool.java 1.11   04/03/09 SMI";
    private final StorageSystem myStorageSystem;
    private PoolCapabilities myCapabilities = null;
    private long myTotalManagedSpace = 0L;
    private long myRemainingManagedSpace = 0L;

    public static Pool create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        Contract.requires((cIMObjectPath != null ? 1 : 0) != 0, (String)"theName != null");
        Pool pool = new Pool(storageSystem, cIMObjectPath);
        return pool;
    }

    public static Pool[] create(StorageSystem storageSystem, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        Contract.requires((cIMObjectPathArray != null ? 1 : 0) != 0, (String)"theNames != null");
        Pool[] poolArray = null;
        if (cIMObjectPathArray != null) {
            ArrayList<Pool> arrayList = new ArrayList<Pool>(cIMObjectPathArray.length);
            int n = 0;
            while (n < cIMObjectPathArray.length) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[n];
                if (cIMObjectPath != null) {
                    Pool pool = new Pool(storageSystem, cIMObjectPath);
                    arrayList.add(pool);
                }
                ++n;
            }
            poolArray = Pool.toPoolArray(arrayList);
        } else {
            poolArray = new Pool[]{};
        }
        Contract.ensures((poolArray != null ? 1 : 0) != 0, (String)"result != null");
        return poolArray;
    }

    public static Pool[] toPoolArray(List list) {
        int n = list != null ? list.size() : 0;
        Pool[] poolArray = new Pool[n];
        if (n > 0) {
            poolArray = list.toArray(poolArray);
        }
        return poolArray;
    }

    public Pool(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    public final PoolCapabilities getCapabilities() {
        if (this.myCapabilities == null) {
            CIMObjectPath cIMObjectPath = this.getAssociatedName("CIM_ElementCapabilities", "CIM_StorageCapabilities");
            this.myCapabilities = PoolCapabilities.create(this, cIMObjectPath);
        }
        Contract.ensures((this.myCapabilities != null ? 1 : 0) != 0, (String)"myCapabilities != null");
        return this.myCapabilities;
    }

    public final boolean isPrimordial() {
        return this.getPropertyValue("Primordial").booleanValue();
    }

    public final boolean isAllocated() {
        return !this.isPrimordial();
    }

    public final long getTotalManagedSpace() {
        this.myTotalManagedSpace = this.getPropertyValue("TotalManagedSpace").longValue();
        return this.myTotalManagedSpace;
    }

    public final long getUnallocatedSpace() {
        this.myRemainingManagedSpace = this.getPropertyValue("RemainingManagedSpace").longValue();
        return this.myRemainingManagedSpace;
    }

    public final long getAvailableSize(VolumeSetting volumeSetting, long l) {
        long l2;
        String string;
        block11: {
            string = this.traceEntry("getAvailableSize()");
            l2 = 0L;
            try {
                long[] lArray = this.getSupportedSizes(volumeSetting);
                if (lArray != null) {
                    int n = 0;
                    while (n < lArray.length) {
                        long l3 = lArray[n];
                        this.traceFinest("supported size: " + l3);
                        if (l <= l3) {
                            this.traceFinest("    found size: " + l3);
                            l2 = l3;
                            break block11;
                        }
                        ++n;
                    }
                    break block11;
                }
                lArray = this.getSupportedSizeRange(volumeSetting);
                if (lArray != null && lArray.length == 3) {
                    long l4 = lArray[0];
                    long l5 = lArray[1];
                    long l6 = lArray[2];
                    this.traceFinest("supported size range: min=" + l4 + ", max=" + l5 + ", div=" + l6);
                    if (l < l4) {
                        l2 = l4;
                    } else if (l % l6 == 0L) {
                        l2 = l;
                    } else if (l >= l4 && l <= l5) {
                        l2 = (l / l6 + 1L) * l6;
                    }
                }
            }
            catch (Exception exception) {
                this.traceError("should never happen:" + exception);
            }
        }
        this.traceReturn(string, new Long(l2));
        return l2;
    }

    public long[] getSupportedSizes(VolumeSetting volumeSetting) {
        return this.getSupportedSizes(volumeSetting, 2);
    }

    protected final long[] getSupportedSizes(VolumeSetting volumeSetting, int n) {
        String string = this.traceEntry("getSupportedSizes()");
        long[] lArray = null;
        CimArgumentMap cimArgumentMap = CIM_StoragePool.GetSupportedSizes.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StoragePool.GetSupportedSizes.Factory.createOutputs();
        cimArgumentMap.getValue("ElementType").setValue(n, CimValue.NumberType.UINT16);
        cimArgumentMap.getValue("Goal").setValue(volumeSetting);
        int n2 = this.intMethod("GetSupportedSizes", cimArgumentMap, cimArgumentMap2);
        switch (n2) {
            case 0: {
                lArray = cimArgumentMap2.getValue("Sizes").longValues();
                break;
            }
        }
        this.traceFinest(string + " rc: " + n2);
        this.traceReturn(string, lArray);
        return lArray;
    }

    public long[] getSupportedSizeRange(VolumeSetting volumeSetting) {
        return this.getSupportedSizes(volumeSetting, 2);
    }

    protected final long[] getSupportedSizeRange(VolumeSetting volumeSetting, int n) {
        long[] lArray = new long[3];
        CimArgumentMap cimArgumentMap = CIM_StoragePool.GetSupportedSizeRange.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StoragePool.GetSupportedSizeRange.Factory.createOutputs();
        cimArgumentMap.getValue("ElementType").setValue(n, CimValue.NumberType.UINT16);
        cimArgumentMap.getValue("Goal").setValue(volumeSetting);
        int n2 = this.intMethod("GetSupportedSizeRange", cimArgumentMap, cimArgumentMap2);
        switch (n2) {
            case 0: {
                lArray = new long[]{cimArgumentMap2.getValue("MinimumVolumeSize").longValue(0L), cimArgumentMap2.getValue("MaximumVolumeSize").longValue(0L), cimArgumentMap2.getValue("VolumeSizeDivisor").longValue(0L)};
                break;
            }
        }
        return lArray;
    }
}

