/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.CimArgumentMap;
import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_StorageHardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.AbstractService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.SystemSpecificCollection;
import javax.wbem.cim.CIMObjectPath;

public final class HardwareIDManagementService
extends AbstractService {
    private static final String SCCS_ID = "@(#)HardwareIDManagementService.java 1.4   03/09/11 SMI";
    private final StorageSystem myStorageSystem;
    private HardwareID[] myHardwareIDs = null;
    private SystemSpecificCollection[] myCollections = null;

    public static HardwareIDManagementService create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        HardwareIDManagementService hardwareIDManagementService = null;
        if (cIMObjectPath != null) {
            hardwareIDManagementService = new HardwareIDManagementService(storageSystem, cIMObjectPath);
        }
        return hardwareIDManagementService;
    }

    public HardwareIDManagementService(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    public final HardwareID[] getHardwareIDs() {
        if (this.myHardwareIDs == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_ConcreteDependency", "CIM_StorageHardwareID");
            this.myHardwareIDs = HardwareID.create(this.getStorageSystem(), cIMObjectPathArray);
        }
        Contract.ensures((this.myHardwareIDs != null ? 1 : 0) != 0, (String)"myHardwareIDs != null");
        return this.myHardwareIDs;
    }

    public final void clearHardwareIDs() {
        this.myHardwareIDs = null;
    }

    public final SystemSpecificCollection[] getCollections() {
        if (this.myCollections == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_ConcreteDependency", "CIM_SystemSpecificCollection");
            this.myCollections = SystemSpecificCollection.create(this.getStorageSystem(), cIMObjectPathArray);
        }
        Contract.ensures((this.myCollections != null ? 1 : 0) != 0, (String)"myCollections != null");
        return this.myCollections;
    }

    public final void clearCollections() {
        this.myCollections = null;
    }

    public final HardwareID getHardwareID(String string) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theHardwareID != null");
        HardwareID hardwareID = HardwareID.getHardwareID(this.getHardwareIDs(), string);
        return hardwareID;
    }

    public final SystemSpecificCollection getCollection(String string) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theCollection != null");
        SystemSpecificCollection systemSpecificCollection = SystemSpecificCollection.getCollection(this.getCollections(), string);
        return systemSpecificCollection;
    }

    public final void CreateStorageHardwareID(String string, HardwareID[] hardwareIDArray) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theHardwareIDName != null");
        Contract.requires((hardwareIDArray != null ? 1 : 0) != 0, (String)"theHardwareID != null");
        Contract.requires((hardwareIDArray.length == 1 ? 1 : 0) != 0, (String)"theHardwareID.length == 1");
        CimArgumentMap cimArgumentMap = CIM_StorageHardwareIDManagementService.CreateStorageHardwareID.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageHardwareIDManagementService.CreateStorageHardwareID.Factory.createOutputs();
        cimArgumentMap.getValue("StorageID").setValue(string);
        cimArgumentMap.getValue("IDType").setValue(2, CimValue.NumberType.UINT16);
        int n = this.intMethod("CreateStorageHardwareID", cimArgumentMap, cimArgumentMap2);
        if (n == 0) {
            hardwareIDArray[0] = this.getHardwareID(cimArgumentMap2, "HardwareID");
            this.clearHardwareIDs();
        } else {
            this.handleReturnCode(n, CIM_StorageHardwareIDManagementService.CreateStorageHardwareID.VALUE_MAP, CIM_StorageHardwareIDManagementService.CreateStorageHardwareID.VALUES);
        }
    }

    public final void DeleteStorageHardwareID(HardwareID hardwareID) {
        Contract.requires((hardwareID != null ? 1 : 0) != 0, (String)"theHardwareID != null");
        CimArgumentMap cimArgumentMap = CIM_StorageHardwareIDManagementService.DeleteStorageHardwareID.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageHardwareIDManagementService.DeleteStorageHardwareID.Factory.createOutputs();
        cimArgumentMap.getValue("HardwareID").setValue(hardwareID);
        int n = this.intMethod("DeleteStorageHardwareID", cimArgumentMap, cimArgumentMap2);
        if (n == 0) {
            this.clearHardwareIDs();
        } else {
            this.handleReturnCode(n, CIM_StorageHardwareIDManagementService.DeleteStorageHardwareID.VALUE_MAP, CIM_StorageHardwareIDManagementService.DeleteStorageHardwareID.VALUES);
        }
    }

    public final void CreateHardwareIDCollection(String string, String[] stringArray, SystemSpecificCollection[] systemSpecificCollectionArray) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theCollectionName != null");
        Contract.requires((stringArray != null ? 1 : 0) != 0, (String)"theHardwareIDs != null");
        Contract.requires((stringArray.length > 0 ? 1 : 0) != 0, (String)"theHardwareIDs.length > 0");
        Contract.requires((systemSpecificCollectionArray != null ? 1 : 0) != 0, (String)"theCollection != null");
        Contract.requires((systemSpecificCollectionArray.length == 1 ? 1 : 0) != 0, (String)"theCollection.length == 1");
        CimArgumentMap cimArgumentMap = CIM_StorageHardwareIDManagementService.CreateHardwareIDCollection.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageHardwareIDManagementService.CreateHardwareIDCollection.Factory.createOutputs();
        cimArgumentMap.getValue("ElementName").setValue(string);
        cimArgumentMap.getValue("HardwareIDs").setValue(stringArray);
        int n = this.intMethod("CreateHardwareIDCollection", cimArgumentMap, cimArgumentMap2);
        if (n == 0) {
            systemSpecificCollectionArray[0] = this.getCollection(cimArgumentMap2, "Collection");
            this.clearHardwareIDs();
            this.clearCollections();
        } else {
            this.handleReturnCode(n, CIM_StorageHardwareIDManagementService.CreateHardwareIDCollection.VALUE_MAP, CIM_StorageHardwareIDManagementService.CreateHardwareIDCollection.VALUES);
        }
    }

    public final void AddHardwareIDsToCollection(SystemSpecificCollection systemSpecificCollection, String[] stringArray) {
        Contract.requires((systemSpecificCollection != null ? 1 : 0) != 0, (String)"theCollection != null");
        Contract.requires((stringArray != null ? 1 : 0) != 0, (String)"theHardwareIDs != null");
        Contract.requires((stringArray.length > 0 ? 1 : 0) != 0, (String)"theHardwareIDs.length > 0");
        CimArgumentMap cimArgumentMap = CIM_StorageHardwareIDManagementService.AddHardwareIDsToCollection.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_StorageHardwareIDManagementService.AddHardwareIDsToCollection.Factory.createOutputs();
        cimArgumentMap.getValue("Collection").setValue(systemSpecificCollection);
        cimArgumentMap.getValue("HardwareIDs").setValue(stringArray);
        int n = this.intMethod("AddHardwareIDsToCollection", cimArgumentMap, cimArgumentMap2);
        if (n == 0) {
            this.clearHardwareIDs();
        } else {
            this.handleReturnCode(n, CIM_StorageHardwareIDManagementService.CreateHardwareIDCollection.VALUE_MAP, CIM_StorageHardwareIDManagementService.CreateHardwareIDCollection.VALUES);
        }
    }

    private HardwareID getHardwareID(CimArgumentMap cimArgumentMap, String string) {
        HardwareID hardwareID = null;
        CIMObjectPath cIMObjectPath = cimArgumentMap.getValue(string).getObjectPathValue();
        if (cIMObjectPath != null) {
            hardwareID = HardwareID.create(this.getStorageSystem(), cIMObjectPath);
        }
        return hardwareID;
    }

    private SystemSpecificCollection getCollection(CimArgumentMap cimArgumentMap, String string) {
        SystemSpecificCollection systemSpecificCollection = null;
        CIMObjectPath cIMObjectPath = cimArgumentMap.getValue(string).getObjectPathValue();
        if (cIMObjectPath != null) {
            systemSpecificCollection = new SystemSpecificCollection(this.getStorageSystem(), cIMObjectPath);
        }
        return systemSpecificCollection;
    }
}

