/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients.array;

import com.sun.netstorage.mgmt.esm.model.cim.CimArgumentMap;
import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_ControllerConfigurationService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.AbstractService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.LogicalDevice;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.FCPort;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.ProtocolController;
import javax.wbem.cim.CIMObjectPath;

public final class ControllerConfigService
extends AbstractService {
    private static final String SCCS_ID = "@(#)ControllerConfigService.java 1.9   04/05/10 SMI";
    private final StorageSystem myStorageSystem;

    public static ControllerConfigService create(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theParent != null");
        ControllerConfigService controllerConfigService = null;
        if (cIMObjectPath != null) {
            controllerConfigService = new ControllerConfigService(storageSystem, cIMObjectPath);
        }
        return controllerConfigService;
    }

    public ControllerConfigService(StorageSystem storageSystem, CIMObjectPath cIMObjectPath) {
        super(storageSystem, cIMObjectPath);
        this.myStorageSystem = storageSystem;
    }

    public final StorageSystem getStorageSystem() {
        return this.myStorageSystem;
    }

    private ProtocolController getProtocolController(CimArgumentMap cimArgumentMap, String string) {
        ProtocolController protocolController = null;
        CIMObjectPath cIMObjectPath = cimArgumentMap.getValue(string).getObjectPathValue();
        if (cIMObjectPath != null) {
            protocolController = new ProtocolController(this.getStorageSystem(), cIMObjectPath);
        }
        return protocolController;
    }

    public final void createController(FCPort[] fCPortArray, ProtocolController[] protocolControllerArray) {
        Contract.requires((fCPortArray != null ? 1 : 0) != 0, (String)"thePorts != null");
        Contract.requires((fCPortArray.length > 0 ? 1 : 0) != 0, (String)"thePorts.length > 0");
        Contract.requires((protocolControllerArray != null ? 1 : 0) != 0, (String)"theNewController != null");
        Contract.requires((protocolControllerArray.length == 1 ? 1 : 0) != 0, (String)"theNewController.length == 1");
        CimArgumentMap cimArgumentMap = CIM_ControllerConfigurationService.CreateProtocolControllerWithPorts.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_ControllerConfigurationService.CreateProtocolControllerWithPorts.Factory.createOutputs();
        cimArgumentMap.getValue("ElementName").setValue("theView");
        cimArgumentMap.getValue("Ports").setValue(fCPortArray);
        cimArgumentMap.getValue("Protocol").setValue(2, CimValue.NumberType.UINT16);
        int n = this.intMethod("CreateProtocolControllerWithPorts", cimArgumentMap, cimArgumentMap2);
        if (n == 0) {
            protocolControllerArray[0] = this.getProtocolController(cimArgumentMap2, "ProtocolController");
            if (protocolControllerArray[0] == null) {
                // empty if block
            }
        } else {
            this.handleReturnCode(n, CIM_ControllerConfigurationService.CreateProtocolControllerWithPorts.VALUE_MAP, CIM_ControllerConfigurationService.CreateProtocolControllerWithPorts.VALUES);
        }
    }

    public final void deleteController(ProtocolController protocolController, boolean bl, boolean bl2) {
        Contract.requires((protocolController != null ? 1 : 0) != 0, (String)"theController != null");
        CimArgumentMap cimArgumentMap = CIM_ControllerConfigurationService.DeleteProtocolController.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_ControllerConfigurationService.DeleteProtocolController.Factory.createOutputs();
        cimArgumentMap.getValue("ProtocolController").setValue(protocolController);
        cimArgumentMap.getValue("DeleteChildrenProtocolControllers").setValue(bl);
        cimArgumentMap.getValue("DeleteUnits").setValue(bl2);
        int n = this.intMethod("DeleteProtocolController", cimArgumentMap, cimArgumentMap2);
        if (n != 0) {
            this.handleReturnCode(n, CIM_ControllerConfigurationService.DeleteProtocolController.VALUE_MAP, CIM_ControllerConfigurationService.DeleteProtocolController.VALUES);
        }
    }

    public final void attachDevice(ProtocolController protocolController, LogicalDevice logicalDevice, String string, String[] stringArray) {
        Contract.requires((protocolController != null ? 1 : 0) != 0, (String)"theController != null");
        Contract.requires((logicalDevice != null ? 1 : 0) != 0, (String)"theDevice != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theDeviceNumber != null");
        Contract.requires((stringArray != null ? 1 : 0) != 0, (String)"theOutDeviceNumber != null");
        Contract.requires((stringArray.length == 1 ? 1 : 0) != 0, (String)"theOutDeviceNumber.length == 1");
        CimArgumentMap cimArgumentMap = CIM_ControllerConfigurationService.AttachDevice.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_ControllerConfigurationService.AttachDevice.Factory.createOutputs();
        cimArgumentMap.getValue("ProtocolController").setValue(protocolController);
        cimArgumentMap.getValue("Device").setValue(logicalDevice);
        cimArgumentMap.getValue("DeviceNumber").setValue(string);
        int n = this.intMethod("AttachDevice", cimArgumentMap, cimArgumentMap2);
        if (n == 0) {
            stringArray[0] = this.getDeviceNumber(cimArgumentMap2, "DeviceNumber");
        } else {
            this.handleReturnCode(n, CIM_ControllerConfigurationService.AttachDevice.VALUE_MAP, CIM_ControllerConfigurationService.AttachDevice.VALUES);
        }
    }

    public final void detachDevice(ProtocolController protocolController, LogicalDevice logicalDevice) {
        Contract.requires((protocolController != null ? 1 : 0) != 0, (String)"theController != null");
        Contract.requires((logicalDevice != null ? 1 : 0) != 0, (String)"theDevice != null");
        CimArgumentMap cimArgumentMap = CIM_ControllerConfigurationService.DetachDevice.Factory.createInputs();
        CimArgumentMap cimArgumentMap2 = CIM_ControllerConfigurationService.DetachDevice.Factory.createOutputs();
        cimArgumentMap.getValue("ProtocolController").setValue(protocolController);
        cimArgumentMap.getValue("Device").setValue(logicalDevice);
        int n = this.intMethod("DetachDevice", cimArgumentMap, cimArgumentMap2);
        if (n != 0) {
            this.handleReturnCode(n, CIM_ControllerConfigurationService.DetachDevice.VALUE_MAP, CIM_ControllerConfigurationService.DetachDevice.VALUES);
        }
    }

    private String getDeviceNumber(CimArgumentMap cimArgumentMap, String string) {
        String string2 = null;
        CimValue cimValue = cimArgumentMap.getValue(string);
        if (cimValue == null || (string2 = cimValue.getStringValue()) == null) {
            // empty if block
        }
        return string2;
    }
}

