/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients;

import com.sun.netstorage.mgmt.esm.model.cim.constants.CIM_ComputerSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.ComputerSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.Product;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;

public class ProductData {
    private static final String SCCS_ID = "@(#)ProductData.java 1.5   04/04/13 SMI";
    public static final String DISPLAY_NAME_KEY = "ElementName";
    public static final String DESCRIPTION_KEY = "Description";
    public static final String CLASS_NAME_KEY = "CreationClassName";
    public static final String NAME_KEY = "Name";
    public static final String NAME_FORMAT_KEY = "NameFormat";
    public static final String HOST_NAME_KEY = "Name-hostname";
    public static final String HOST_ADDRESS_KEY = "Name-ip";
    public static final String HOST_WWN_KEY = "Name-wwn";
    public static final String PORT_WWN_KEY = "Name-wwn-port";
    public static final String VENDOR_KEY = "Vendor";
    public static final String MODEL_KEY = "Model";
    public static final String DISPLAY_MODEL_KEY = "DisplayModel";
    public static final String SERIAL_NUMBER_KEY = "IdentifyingNumber";
    public static final String VERSION_KEY = "Version";
    private final Properties myProperties = new Properties();

    public static ProductData create(ComputerSystem computerSystem, Product product) {
        ProductData productData = new ProductData();
        if (computerSystem != null) {
            productData.merge(computerSystem);
        }
        if (product != null) {
            productData.merge(product);
        }
        return productData;
    }

    public final Properties toProperties() {
        return this.myProperties;
    }

    private String getProperty(String string) {
        return this.myProperties.getProperty(string);
    }

    private void setProperty(String string, String string2) {
        if (string2 != null) {
            this.myProperties.setProperty(string, string2);
        }
    }

    public String getDisplayName() {
        return this.getProperty(DISPLAY_NAME_KEY);
    }

    public void setDisplayName(String string) {
        this.setProperty(DISPLAY_NAME_KEY, string);
    }

    public String getDescription() {
        return this.getProperty(DESCRIPTION_KEY);
    }

    public void setDescription(String string) {
        this.setProperty(DESCRIPTION_KEY, string);
    }

    public String getCreationClassName() {
        return this.getProperty(CLASS_NAME_KEY);
    }

    public void setCreationClassName(String string) {
        this.setProperty(CLASS_NAME_KEY, string);
    }

    public String getName() {
        return this.getProperty(NAME_KEY);
    }

    public void setName(String string) {
        this.setProperty(NAME_KEY, string);
    }

    public String getNameFormat() {
        return this.getProperty(NAME_FORMAT_KEY);
    }

    public void setNameFormat(String string) {
        this.setProperty(NAME_FORMAT_KEY, string);
    }

    public String getHostName() {
        return this.getProperty(HOST_NAME_KEY);
    }

    public void setHostName(String string) {
        this.setProperty(HOST_NAME_KEY, string);
    }

    public String getHostAddress() {
        return this.getProperty(HOST_ADDRESS_KEY);
    }

    public void setHostAddress(String string) {
        this.setProperty(HOST_ADDRESS_KEY, string);
    }

    public String getHostWWN() {
        return this.getProperty(HOST_WWN_KEY);
    }

    public void setHostWWN(String string) {
        this.setProperty(HOST_WWN_KEY, string);
    }

    public String getPortWWN() {
        return this.getProperty(PORT_WWN_KEY);
    }

    public void setPortWWN(String string) {
        this.setProperty(PORT_WWN_KEY, string);
    }

    public String getVendor() {
        return this.getProperty(VENDOR_KEY);
    }

    public void setVendor(String string) {
        this.setProperty(VENDOR_KEY, string);
    }

    public String getModel() {
        return this.getProperty(MODEL_KEY);
    }

    public void setModel(String string) {
        this.setProperty(MODEL_KEY, string);
    }

    public String getDisplayModel() {
        return this.getProperty(DISPLAY_MODEL_KEY);
    }

    public void setDisplayModel(String string) {
        this.setProperty(DISPLAY_MODEL_KEY, string);
    }

    public String getSerialNumber() {
        return this.getProperty(SERIAL_NUMBER_KEY);
    }

    public void setSerialNumber(String string) {
        this.setProperty(SERIAL_NUMBER_KEY, string);
    }

    public String getVersion() {
        return this.getProperty(VERSION_KEY);
    }

    public void setVersion(String string) {
        this.setProperty(VERSION_KEY, string);
    }

    public ProductData merge(ComputerSystem computerSystem) {
        if (computerSystem != null) {
            String string = computerSystem.getName();
            String string2 = computerSystem.getNameFormat();
            this.setDisplayName(computerSystem.getElementName());
            this.setDescription(computerSystem.getDescription());
            this.setCreationClassName(computerSystem.getCreationClassName());
            this.setName(string);
            this.setNameFormat(string2);
            if (CIM_ComputerSystem.NameFormat._IP_.equals(string2)) {
                this.setInetAddress(string);
            } else if (CIM_ComputerSystem.NameFormat._WWN_.equals(string2)) {
                this.setHostWWN(string);
            } else if (CIM_ComputerSystem.NameFormat._OTHER_.equals(string2)) {
                this.setInetAddress(string);
            }
            this.mergeOtherIdentities(computerSystem);
        }
        return this;
    }

    public ProductData merge(Product product) {
        if (product != null) {
            this.setVendor(product.getVendor());
            this.setModel(product.getModel());
            this.setDisplayModel(product.getDisplayModel());
            this.setSerialNumber(product.getIdentifyingNumber());
            this.setVersion(product.getVersion());
        }
        return this;
    }

    private void mergeOtherIdentities(ComputerSystem computerSystem) {
        CharSequence charSequence;
        String[] stringArray = computerSystem.getOtherIdentifyingInfo();
        String[] stringArray2 = computerSystem.getIdentifyingDescriptions();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            charSequence = stringArray2[n];
            String string = stringArray[n];
            if (CIM_ComputerSystem.NameFormat._WWN_.equals(charSequence)) {
                this.setHostWWN(string);
            } else if (CIM_ComputerSystem.NameFormat._IP_.equals(charSequence)) {
                this.setInetAddress(string);
            } else if (charSequence != null) {
                String string2 = ((String)charSequence).toLowerCase();
                if (string2.indexOf("host") >= 0 && string2.indexOf("name") >= 0) {
                    this.setHostName(string);
                } else if (string2.indexOf("host") >= 0 && string2.indexOf("wwn") >= 0) {
                    this.setHostWWN(string);
                } else if (string2.indexOf("node") >= 0 && string2.indexOf("wwn") >= 0) {
                    this.setHostWWN(string);
                } else if (string2.indexOf("port") >= 0 && string2.indexOf("wwn") >= 0) {
                    arrayList.add(string);
                }
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            charSequence = new StringBuffer();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                if (n2 > 0) {
                    ((StringBuffer)charSequence).append(',');
                }
                ((StringBuffer)charSequence).append(arrayList.get(n2));
                ++n2;
            }
            this.setPortWWN(((StringBuffer)charSequence).toString());
        }
    }

    private void setInetAddress(String string) {
        block3: {
            if (string == null) break block3;
            String string2 = string;
            int n = string2.indexOf("?");
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(string2);
                this.setHostName(inetAddress.getHostName());
                this.setHostAddress(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }
}

