/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.ingredients;

import com.sun.netstorage.mgmt.esm.model.cim.CimContext;
import com.sun.netstorage.mgmt.esm.model.cim.CimObjectManager;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.AbstractSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.PhysicalPackage;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.Product;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.ProductData;
import javax.wbem.cim.CIMObjectPath;

public class ComputerSystem
extends AbstractSystem {
    private static final String SCCS_ID = "@(#)ComputerSystem.java 1.15   03/11/24 SMI";
    private PhysicalPackage myPhysicalPackage = null;
    private Product myProduct = null;
    private ComputerSystem myCluster = null;
    private ComputerSystem[] myComponentSystems = null;
    private int[] myDedicated = null;

    public static ComputerSystem[] create(CimObjectManager cimObjectManager, CIMObjectPath[] cIMObjectPathArray) {
        Contract.requires((cimObjectManager != null ? 1 : 0) != 0, (String)"theContext != null");
        int n = cIMObjectPathArray != null ? cIMObjectPathArray.length : 0;
        ComputerSystem[] computerSystemArray = new ComputerSystem[n];
        if (cIMObjectPathArray != null) {
            int n2 = 0;
            while (n2 < cIMObjectPathArray.length) {
                CIMObjectPath cIMObjectPath = cIMObjectPathArray[n2];
                computerSystemArray[n2] = new ComputerSystem(cimObjectManager, cIMObjectPath);
                ++n2;
            }
        }
        Contract.ensures((computerSystemArray != null ? 1 : 0) != 0, (String)"result != null");
        return computerSystemArray;
    }

    public static ComputerSystem create(CimObjectManager cimObjectManager, CIMObjectPath cIMObjectPath) {
        Contract.requires((cimObjectManager != null ? 1 : 0) != 0, (String)"theContext != null");
        Contract.requires((cIMObjectPath != null ? 1 : 0) != 0, (String)"theName != null");
        ComputerSystem computerSystem = new ComputerSystem(cimObjectManager, cIMObjectPath);
        return computerSystem;
    }

    public ComputerSystem(CimContext cimContext, CIMObjectPath cIMObjectPath) {
        super(cimContext, cIMObjectPath);
    }

    public PhysicalPackage getPhysicalPackage() {
        CIMObjectPath cIMObjectPath;
        if (this.myPhysicalPackage == null && (cIMObjectPath = this.getAssociatedName("CIM_ComputerSystemPackage", "CIM_PhysicalPackage")) != null) {
            this.myPhysicalPackage = new PhysicalPackage(this, cIMObjectPath);
        }
        return this.myPhysicalPackage;
    }

    public Product getProduct() {
        if (this.myProduct == null && this.getPhysicalPackage() != null) {
            this.myProduct = this.getPhysicalPackage().getProduct();
        }
        return this.myProduct;
    }

    public ProductData getProductProperties() {
        return this.getVitalProductData();
    }

    public ProductData getVitalProductData() {
        ProductData productData = null;
        if (this.getProduct() != null && (productData = this.getProduct().getVitalProductData()) != null) {
            productData.merge(this);
        }
        return productData;
    }

    public ComputerSystem getCluster() {
        CIMObjectPath cIMObjectPath;
        if (this.myCluster == null && (cIMObjectPath = this.getAssociatedName("CIM_ComponentCS", "CIM_ComputerSystem", "PartComponent", "GroupComponent")) != null) {
            this.myCluster = new ComputerSystem(this, cIMObjectPath);
        }
        return this.myCluster;
    }

    public boolean isClusterComponent() {
        return this.getCluster() != null;
    }

    public final ComputerSystem[] getComponentSystems() {
        if (this.myComponentSystems == null) {
            CIMObjectPath[] cIMObjectPathArray = this.getAssociatedNames("CIM_ComponentCS", "CIM_ComputerSystem", "GroupComponent", "PartComponent");
            this.myComponentSystems = ComputerSystem.create((CimObjectManager)this.getContext(), cIMObjectPathArray);
        }
        Contract.ensures((this.myComponentSystems != null ? 1 : 0) != 0, (String)"myComponentSystems != null");
        return this.myComponentSystems;
    }

    public final boolean isCluster() {
        return this.getComponentSystems() != null && this.getComponentSystems().length > 0;
    }

    protected final int[] getDedicated() {
        if (this.myDedicated == null) {
            this.myDedicated = this.getPropertyValue("Dedicated").intValues();
        }
        return this.myDedicated;
    }

    protected final boolean isDedicated(int n) {
        boolean bl = false;
        int[] nArray = this.getDedicated();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public final boolean isDedicatedStorage() {
        return this.isDedicated(3);
    }

    public final boolean isDedicatedBlockServer() {
        return this.isDedicated(15);
    }

    public final boolean isDedicatedSwitch() {
        return this.isDedicated(5);
    }

    public boolean isTopLevelStorageSystem() {
        return this.isStorageSystem() && !this.isClusterComponent();
    }

    public boolean isStorageSystem() {
        return this.isDedicatedStorage() || this.isDedicatedBlockServer();
    }

    public boolean isSwitchSystem() {
        return this.isDedicatedSwitch();
    }

    public String getCSName() {
        String string = this.getPropertyValue("NameFormat").getStringValue();
        return this.getPropertyValue("Name").getStringValue();
    }

    public String getNameFormat() {
        return this.getPropertyValue("NameFormat").getStringValue();
    }

    public String getDescription() {
        return this.getPropertyValue("Description").getStringValue();
    }

    public String getElementName() {
        return this.getPropertyValue("ElementName").getStringValue();
    }

    public String[] getOtherIdentifyingInfo() {
        return this.getPropertyValue("OtherIdentifyingInfo").getStringValues();
    }

    public String[] getIdentifyingDescriptions() {
        return this.getPropertyValue("IdentifyingDescriptions").getStringValues();
    }

    public String getCreationClassName() {
        return this.getPropertyValue("CreationClassName").getStringValue();
    }
}

