/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim;

import com.sun.netstorage.mgmt.esm.model.cim.Tracer;
import java.util.logging.Level;

public abstract class TraceableObject {
    private static final String SCCS_ID = "@(#)TraceableObject.java 1.5  03/12/01 SMI";
    public static final String SOURCE_METHOD_DEFAULT = "";
    private final Tracer myTracer = Tracer.getInstance();
    private String myTracerClassName = null;
    private String myTracerDisplayName = null;

    protected final Tracer getTracer() {
        return this.myTracer;
    }

    private void trace(Level level, String string, String string2) {
        if (this.myTracer.isEnabled()) {
            this.myTracer.getLogger().logp(level, this.getTracerDisplayName(), string, string2);
        }
    }

    private void trace(Level level, String string) {
        this.trace(level, SOURCE_METHOD_DEFAULT, string);
    }

    protected final String getTracerClassName() {
        if (this.myTracerClassName == null) {
            this.myTracerClassName = this.getClass().getName();
        }
        return this.myTracerClassName;
    }

    protected final String getTracerDisplayName() {
        if (this.myTracerDisplayName == null) {
            String string = this.getTracerClassName();
            int n = string.lastIndexOf(".");
            this.myTracerDisplayName = n > 0 ? string.substring(n + 1) : string;
        }
        return this.myTracerDisplayName;
    }

    protected final boolean isTraceError() {
        return this.myTracer.isEnabled() && this.myTracer.getLogger().isLoggable(Level.SEVERE);
    }

    protected final boolean isTraceWarning() {
        return this.myTracer.isEnabled() && this.myTracer.getLogger().isLoggable(Level.WARNING);
    }

    protected final boolean isTraceInfo() {
        return this.myTracer.isEnabled() && this.myTracer.getLogger().isLoggable(Level.INFO);
    }

    protected final boolean isTraceMethods() {
        return this.isTraceFiner();
    }

    protected final boolean isTraceFine() {
        return this.myTracer.isEnabled() && this.myTracer.getLogger().isLoggable(Level.FINE);
    }

    protected final boolean isTraceFiner() {
        return this.myTracer.isEnabled() && this.myTracer.getLogger().isLoggable(Level.FINER);
    }

    protected final boolean isTraceFinest() {
        return this.myTracer.isEnabled() && this.myTracer.getLogger().isLoggable(Level.FINEST);
    }

    protected final String traceEntry(String string) {
        if (this.myTracer.isEnabled()) {
            this.myTracer.getLogger().entering(this.getTracerDisplayName(), string);
        }
        return string;
    }

    protected final String traceEntry(String string, Object[] objectArray) {
        if (this.myTracer.isEnabled()) {
            this.myTracer.getLogger().entering(this.getTracerDisplayName(), string, objectArray);
        }
        return string;
    }

    protected final void traceReturn(String string) {
        if (this.myTracer.isEnabled()) {
            this.myTracer.getLogger().exiting(this.getTracerDisplayName(), string);
        }
    }

    protected final void traceReturn(String string, Object object) {
        if (this.myTracer.isEnabled()) {
            this.myTracer.getLogger().exiting(this.getTracerDisplayName(), string, object);
        }
    }

    protected final void traceThrowing(String string, Throwable throwable) {
        if (this.myTracer.isEnabled()) {
            this.myTracer.getLogger().throwing(this.getTracerDisplayName(), string, throwable);
        }
    }

    protected final void traceError(String string, String string2) {
        this.trace(Level.SEVERE, string, string2);
    }

    protected final void traceError(String string) {
        this.trace(Level.SEVERE, string);
    }

    protected final void traceWarning(String string, String string2) {
        this.trace(Level.WARNING, string, string2);
    }

    protected final void traceWarning(String string) {
        this.trace(Level.WARNING, string);
    }

    protected final void traceInfo(String string, String string2) {
        this.trace(Level.INFO, string, string2);
    }

    protected final void traceInfo(String string) {
        this.trace(Level.INFO, string);
    }

    protected final void traceFine(String string, String string2) {
        this.trace(Level.FINE, string, string2);
    }

    protected final void traceFine(String string) {
        this.trace(Level.FINE, string);
    }

    protected final void traceFiner(String string, String string2) {
        this.trace(Level.FINER, string, string2);
    }

    protected final void traceFiner(String string) {
        this.trace(Level.FINER, string);
    }

    protected final void traceFinest(String string, String string2) {
        this.trace(Level.FINEST, string, string2);
    }

    protected final void traceFinest(String string) {
        this.trace(Level.FINEST, string);
    }

    protected final void traceRecipeStart() {
        if (this.isTraceInfo()) {
            this.traceInfo("cooking...");
        }
    }

    protected final void traceRecipeFinish() {
        if (this.isTraceInfo()) {
            this.traceInfo("finished.");
        }
    }

    protected final void traceStep(int n, String string) {
        if (this.isTraceInfo()) {
            this.traceInfo("Step " + n + ": " + string);
        }
    }

    protected final void traceStep(int n) {
        if (this.isTraceInfo()) {
            this.traceInfo("Step " + n);
        }
    }
}

