/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim;

import com.sun.netstorage.mgmt.esm.model.cim.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.constants.ConstantResources;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;

public class CimValueMap {
    private static final String SCCS_ID = "@(#)CimValueMap.java 1.1  03/07/23 SMI";
    private final String[] myValueNumbers;
    private final String[] myValueStrings;

    public static Integer toInteger(String string) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theValue != null");
        Integer n = null;
        int n2 = 10;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            string = string.substring(2);
            n2 = 16;
        }
        try {
            n = Integer.valueOf(string, n2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public static int toInt(String string) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theValue != null");
        int n = -1;
        Integer n2 = CimValueMap.toInteger(string);
        if (n2 == null) {
            throw new NumberFormatException();
        }
        n = n2;
        return n;
    }

    public CimValueMap(String[] stringArray, String[] stringArray2) {
        Contract.requires((stringArray != null ? 1 : 0) != 0, (String)"theValueNumbers != null");
        Contract.requires((stringArray2 != null ? 1 : 0) != 0, (String)"theValueStrings != null");
        Contract.requires((stringArray.length == stringArray2.length ? 1 : 0) != 0, (String)"theValueNumbers.length == theValueStrings.length");
        this.myValueNumbers = stringArray;
        this.myValueStrings = stringArray2;
    }

    protected final String[] getValueNumbers() {
        return this.myValueNumbers;
    }

    protected final String[] getValueStrings() {
        return this.myValueStrings;
    }

    public final boolean isMember(int n) {
        return this.getString(n) != null;
    }

    public final Resource getResource(int n) {
        Resource resource = null;
        String string = this.getString(n);
        if (string != null) {
            resource = ConstantResources.getResource(string);
        }
        return resource;
    }

    public final String getString(int n) {
        String string = null;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.myValueNumbers.length) {
            block14: {
                String string2 = this.myValueNumbers[n3];
                if (string2 != null) {
                    try {
                        int n4 = CimValueMap.toInt(string2);
                        if (n == n4) {
                            string = this.myValueStrings[n3];
                            break;
                        }
                        n2 = n4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string3;
                        int n5 = string2.indexOf("..");
                        if (n5 < 0) break block14;
                        int n6 = 0;
                        int n7 = n5 + 2;
                        Integer n8 = null;
                        Integer n9 = null;
                        if (n6 < n5) {
                            string3 = string2.substring(n6, n5);
                            n8 = CimValueMap.toInteger(string3);
                        }
                        if (n7 < string2.length()) {
                            string3 = string2.substring(n7);
                            n9 = CimValueMap.toInteger(string3);
                        }
                        if (n8 == null) {
                            n8 = new Integer(++n2);
                        }
                        if (n9 == null) {
                            if (n3 + 1 < this.myValueNumbers.length) {
                                string2 = this.myValueNumbers[n3 + 1];
                                n5 = string2.indexOf("..");
                                if (n5 > 0) {
                                    string2 = string2.substring(0, n5);
                                }
                                try {
                                    int n10 = CimValueMap.toInt(string2);
                                    n9 = new Integer(--n10);
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    // empty catch block
                                }
                            }
                            if (n9 == null) {
                                n9 = new Integer(Integer.MAX_VALUE);
                            }
                        }
                        if (n < n8 || n > n9) break block14;
                        string = this.myValueStrings[n3];
                        break;
                    }
                }
            }
            ++n3;
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.myValueNumbers.length) {
            stringBuffer.append(this.myValueNumbers[n]);
            stringBuffer.append("\t(");
            stringBuffer.append(this.myValueStrings[n]);
            stringBuffer.append(")");
            ++n;
        }
        return stringBuffer.toString();
    }
}

