/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim;

import com.sun.netstorage.mgmt.esm.model.cim.CimValue;
import java.util.ArrayList;
import java.util.HashMap;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMValue;

public final class CimArgumentMap {
    private static final String SCCS_ID = "@(#)CimArgumentMap.java 1.3  03/07/17 SMI";
    private final boolean myInput;
    private final CIMArgument[] myArguments;
    private final HashMap myArgumentMap = new HashMap();

    private CimArgumentMap(boolean bl, int n) {
        this.myInput = bl;
        this.myArguments = new CIMArgument[n];
    }

    public CimArgumentMap(int n) {
        this(false, n);
    }

    public CimArgumentMap(String[] stringArray) {
        this(true, stringArray != null ? stringArray.length : 0);
        if (stringArray != null) {
            CIMArgument[] cIMArgumentArray = this.getArguments();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string != null) {
                    CIMValue cIMValue = new CIMValue(null);
                    cIMArgumentArray[n] = new CIMArgument(string, cIMValue);
                }
                ++n;
            }
        }
    }

    public final CIMArgument[] getArguments() {
        return this.myArguments;
    }

    public final CIMArgument[] toArray() {
        CIMArgument[] cIMArgumentArray = this.myArguments;
        if (this.myInput) {
            ArrayList<CIMArgument> arrayList = new ArrayList<CIMArgument>(this.myArguments.length);
            int n = 0;
            while (n < this.myArguments.length) {
                CIMArgument cIMArgument = this.myArguments[n];
                if (cIMArgument != null && cIMArgument.getValue() != null && cIMArgument.getValue().getValue() != null) {
                    arrayList.add(cIMArgument);
                }
                ++n;
            }
            cIMArgumentArray = arrayList.toArray(new CIMArgument[arrayList.size()]);
        }
        return cIMArgumentArray;
    }

    private String getArgumentKey(String string) {
        return string != null ? string.toLowerCase() : null;
    }

    private void initArgumentMap() {
        if (this.myArguments != null) {
            int n = 0;
            while (n < this.myArguments.length) {
                CIMArgument cIMArgument = this.myArguments[n];
                String string = cIMArgument != null ? cIMArgument.getName() : null;
                String string2 = this.getArgumentKey(string);
                if (string2 != null) {
                    this.myArgumentMap.put(string2, cIMArgument);
                }
                ++n;
            }
        }
    }

    public boolean hasArgument(String string) {
        return this.getArgument(string) != null;
    }

    public CIMArgument getArgument(String string) {
        CIMArgument cIMArgument = null;
        String string2 = this.getArgumentKey(string);
        if (string2 != null) {
            if (this.myArgumentMap.size() == 0) {
                this.initArgumentMap();
            }
            cIMArgument = (CIMArgument)this.myArgumentMap.get(string2);
        }
        return cIMArgument;
    }

    public CimValue getValue(String string) {
        CimValue cimValue = null;
        CIMArgument cIMArgument = this.getArgument(string);
        if (cIMArgument != null) {
            cimValue = new CimValue(cIMArgument);
        }
        return cimValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        int n = 0;
        while (n < this.myArguments.length) {
            CIMValue cIMValue;
            CIMArgument cIMArgument = this.myArguments[n];
            String string = cIMArgument != null ? cIMArgument.getName() : null;
            CIMValue cIMValue2 = cIMValue = cIMArgument != null ? cIMArgument.getValue() : null;
            if (n > 0) {
                stringBuffer.append(", ");
            }
            if (string != null) {
                stringBuffer.append(string);
                stringBuffer.append(" = ");
            }
            stringBuffer.append(cIMValue);
            ++n;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

