/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.rack.serack.service;

import com.sun.jade.device.rack.serack.io.SERackTokenList;
import com.sun.jade.device.rack.serack.service.RackReportTranslator;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.logic.wbem.ReportGenerator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;

public class SERackReportGenerator
implements ReportGenerator {
    private Properties props;
    private String systemName;
    private String hostIP;
    private String deviceKey;
    private int port;
    public static final String sccs_id = "@(#)SERackReportGenerator.java\t1.0 05/09/02 SMI";

    public SERackReportGenerator(Properties properties) {
        this.props = properties;
        this.hostIP = this.props.getProperty("ip");
        this.systemName = this.props.getProperty("deviceKey");
        this.deviceKey = this.props.getProperty("deviceKey");
        String string = properties.getProperty("port");
        try {
            this.port = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.port = 7443;
        }
    }

    public String generateReport() {
        RackReportTranslator rackReportTranslator = new RackReportTranslator(this.systemName, this.hostIP, this.port, this.deviceKey);
        return rackReportTranslator.createReport();
    }

    private void storeReport(String string) {
        try {
            File file = new File("xmlReport.xml");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String retrieveReport() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            File file = new File("xmlReport.xml");
            FileReader fileReader = new FileReader(file);
            char[] cArray = new char[1024];
            while ((n = fileReader.read(cArray)) != -1) {
                String string = new String(cArray, 0, n);
                stringBuffer.append(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public void updateReport(String string) {
        SERackTokenList sERackTokenList = new SERackTokenList(string);
        String string2 = this.retrieveReport();
        DeviceReport deviceReport = new DeviceReport(string2);
        DeviceClass deviceClass = deviceReport.getDeviceClass();
        string2 = deviceClass.toXML();
        this.storeReport(string2);
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("ip", "diag244");
        properties.setProperty("name", "Rack001");
        properties.setProperty("deviceKey", "se:6910.83061b3a");
        SERackReportGenerator sERackReportGenerator = new SERackReportGenerator(properties);
        String string = sERackReportGenerator.generateReport();
        sERackReportGenerator.storeReport(string);
    }
}

