/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.rack.serack.service;

import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.log.Report;
import java.util.Collection;

public class PersistenceHelper {
    public static final String sccs_id = "@(#)PersistenceHelper.java\t1.0 07/11/02 SMI";

    private static CIMBeanPersistence connectToPersistence() throws ConnectionException {
        CIMBeanPersistence cIMBeanPersistence = null;
        if (StoradeEnvironment.getState() == 2) {
            throw new ConnectionException("Can't connect to Persistence, application is stopping.");
        }
        cIMBeanPersistence = PersistenceService.getService().getCIMBeanPersistence();
        return cIMBeanPersistence;
    }

    public static void storeBean(CIMBean cIMBean) {
        if (cIMBean == null) {
            return;
        }
        try {
            CIMBeanPersistence cIMBeanPersistence = PersistenceHelper.connectToPersistence();
            cIMBeanPersistence.storeCIMBean(cIMBean);
        }
        catch (ConnectionException connectionException) {
            Report.error.log((Object)("Error Connecting to Persistence" + (Object)((Object)connectionException)));
        }
        catch (Exception exception) {
            Report.error.log((Object)("Error Persisting CIMBean." + exception));
        }
    }

    public static void storeBeans(CIMBean[] cIMBeanArray) {
        if (cIMBeanArray == null) {
            return;
        }
        try {
            CIMBeanPersistence cIMBeanPersistence = PersistenceHelper.connectToPersistence();
            cIMBeanPersistence.storeCIMBeans(cIMBeanArray);
        }
        catch (ConnectionException connectionException) {
            Report.error.log((Object)("Error Connecting to Persistence" + (Object)((Object)connectionException)));
        }
        catch (Exception exception) {
            Report.error.log((Object)("Error Persisting CIMBeans." + exception));
        }
    }

    public static CIMBean retrieveBean(CIMBean cIMBean) {
        if (cIMBean == null) {
            return null;
        }
        CIMBean cIMBean2 = null;
        try {
            CIMBeanPersistence cIMBeanPersistence = PersistenceHelper.connectToPersistence();
            cIMBean2 = cIMBeanPersistence.retrieveBean(cIMBean);
        }
        catch (ConnectionException connectionException) {
            Report.error.log((Object)("Error Connecting to Persistence" + (Object)((Object)connectionException)));
        }
        catch (Exception exception) {
            Report.error.log((Object)("Error retrieving CIMBean." + exception));
        }
        return cIMBean2;
    }

    public static void removeBean(CIMBean cIMBean) {
        if (cIMBean == null) {
            return;
        }
        try {
            CIMBeanPersistence cIMBeanPersistence = PersistenceHelper.connectToPersistence();
            cIMBeanPersistence.removeBean(cIMBean);
        }
        catch (ConnectionException connectionException) {
            Report.error.log((Object)("Error Connecting to Persistence" + (Object)((Object)connectionException)));
        }
        catch (Exception exception) {
            Report.error.log((Object)("Error deleting CIMBean." + exception));
        }
    }

    public static Collection getAssociatedBeans(Class clazz, CIMBean cIMBean) {
        Collection collection = null;
        if (clazz == null || cIMBean == null) {
            System.out.println("Trying to get associated beans, a parameter is null");
            return collection;
        }
        try {
            CIMBeanPersistence cIMBeanPersistence = PersistenceHelper.connectToPersistence();
            collection = cIMBeanPersistence.retrieveBeans(clazz, cIMBean);
        }
        catch (ConnectionException connectionException) {
            Report.error.log((Object)("Error Connecting to Persistence" + (Object)((Object)connectionException)));
        }
        catch (Exception exception) {
            Report.error.log((Object)("Error deleting CIMBean." + exception));
        }
        return collection;
    }

    public static Collection getAllAssociatedBeans(CIMBean cIMBean) {
        Collection collection = null;
        if (cIMBean == null) {
            System.out.println("Trying to get associated beans, a parameter is null");
            return collection;
        }
        try {
            CIMBeanPersistence cIMBeanPersistence = PersistenceHelper.connectToPersistence();
            collection = cIMBeanPersistence.retrieveBeans(cIMBean);
        }
        catch (ConnectionException connectionException) {
            Report.error.log((Object)("Error Connecting to Persistence" + (Object)((Object)connectionException)));
        }
        catch (Exception exception) {
            Report.error.log((Object)("Error deleting CIMBean." + exception));
        }
        return collection;
    }
}

