/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.array.api;

import com.sun.netstorage.mgmt.esm.logic.array.api.Contract;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import java.io.Serializable;

public class LunMapping
implements Serializable {
    private static final String SCCS_ID = "@(#)LunMapping.java 1.3   03/09/11 SMI";
    private final Identity myVolumeId;
    private final int myLunNumber;
    private final Identity[] myTargetIds;

    public LunMapping(Identity identity, int n, Identity[] identityArray) {
        Contract.requires((identity != null ? 1 : 0) != 0, (String)"theVolumeId != null");
        Contract.requires((n >= 0 ? 1 : 0) != 0, (String)"theLunNumber >= 0");
        Contract.requires((identityArray != null ? 1 : 0) != 0, (String)"theTargetIds != null");
        Contract.requires((identityArray.length > 0 ? 1 : 0) != 0, (String)"theTargetIds.length > 0");
        this.myVolumeId = identity;
        this.myLunNumber = n;
        this.myTargetIds = identityArray;
    }

    public final Identity getVolumeId() {
        return this.myVolumeId;
    }

    public final int getLunNumber() {
        return this.myLunNumber;
    }

    public final Identity[] getTargetIds() {
        return this.myTargetIds;
    }

    String getTargetIdString() {
        StringBuffer stringBuffer = new StringBuffer();
        Identity[] identityArray = this.getTargetIds();
        int n = 0;
        while (n < identityArray.length) {
            stringBuffer.append('#');
            stringBuffer.append(identityArray[n].getValue());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getVolumeId().getValue());
        stringBuffer.append(" : ");
        stringBuffer.append(this.getLunNumber());
        stringBuffer.append(" : ");
        stringBuffer.append(this.getTargetIdString());
        return stringBuffer.toString();
    }
}

