/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.provisioning.api;

import com.sun.netstorage.mgmt.esm.logic.provisioning.api.Localization;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.io.Serializable;

public class ProvisioningException
extends LocalizableException {
    public static final String DATABASE_ACCESS_ERROR = "ERROR: Database accesses error.";
    public static final String SERVICE_ACCESS_ERROR = "ERROR: Error occurred when accessing the service: {0}.";
    public static final String ARRAY_PORT_MISMATCH = "ERROR: The supplied array port, {0}, does not match any of the ports on {1}.";
    public static final String NO_ARRAY_PORTS = "ERROR: No ports were found for {0}.";
    public static final String JOB_SERVICE_ERROR = "ERROR: Problem occurred when running {0}. See logs for details.";
    static final String sccs_id = "@(#)ProvisioningException.java 1.5    04/03/09 SMI";

    private ProvisioningException(Resource resource, Throwable throwable) {
        super(null);
        super.getSupport().initMessage(resource);
    }

    private ProvisioningException(String[] stringArray, Resource resource, Throwable throwable) {
        super(null);
        super.getSupport().addMessageArgs((Serializable[])stringArray);
        super.getSupport().initMessage(resource);
    }

    private ProvisioningException(String[] stringArray, Resource resource) {
        super.getSupport().addMessageArgs((Serializable[])stringArray);
        super.getSupport().initMessage(resource);
    }

    public static final ProvisioningException databaseAccessError(Throwable throwable) {
        return new ProvisioningException(Localization.RES_DATABASE_ACCESS_ERROR, throwable);
    }

    public static final ProvisioningException serviceAccessError(String string, Throwable throwable) {
        return new ProvisioningException(new String[]{string}, Localization.RES_SERVICE_ACCESS_ERROR, throwable);
    }

    public static final ProvisioningException arrayPortMismatch(String string, String string2) {
        return new ProvisioningException(new String[]{string, string2}, Localization.RES_ARRAY_PORT_MISMATCH);
    }

    public static final ProvisioningException noArrayPorts(String string) {
        return new ProvisioningException(new String[]{string}, Localization.RES_NO_ARRAY_PORTS);
    }

    public static final ProvisioningException jobServiceError(String string, Throwable throwable) {
        return new ProvisioningException(new String[]{string}, Localization.RES_JOB_SERVICE_ERROR);
    }
}

