/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.jobservice.api;

import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementType;
import com.sun.netstorage.mgmt.util.result.ESMException;
import java.io.Serializable;

public class JobConfig
implements Cloneable,
Serializable {
    public static final String Name = "Name";
    public static final String Category = "Category";
    public static final String ElementTypes = "ElementTypes";
    public static final String Characteristics = "Characteristics";
    private String name;
    private String category;
    private ElementType[] elementTypes;
    private String[] characteristics;

    public JobConfig() {
    }

    public JobConfig(String string, String string2, ElementType[] elementTypeArray, String[] stringArray) throws ESMException {
        if (string == null || string2 == null || elementTypeArray == null || stringArray == null) {
            throw new ESMException("JobConfig: null configuration definition");
        }
        if (elementTypeArray.length == 0 || stringArray.length == 0) {
            throw new ESMException("JobConfig: types and charactristics must be supplied");
        }
        this.category = string2;
        this.elementTypes = elementTypeArray;
        this.name = string;
        this.characteristics = stringArray;
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        return object;
    }

    public boolean equals(JobConfig jobConfig) {
        ElementType[] elementTypeArray = jobConfig.getElementTypes();
        String[] stringArray = jobConfig.getCharacteristics();
        if (!this.name.equals(jobConfig.getName())) {
            return false;
        }
        if (elementTypeArray.length != this.elementTypes.length) {
            return false;
        }
        if (stringArray.length != this.characteristics.length) {
            return false;
        }
        if (!this.category.equals(jobConfig.getCategory())) {
            return false;
        }
        if (!this.matchElemTypes(jobConfig.getElementTypes())) {
            return false;
        }
        return this.matchCharacteristics(jobConfig.getCharacteristics());
    }

    public boolean matchElemTypes(ElementType[] elementTypeArray) {
        if (elementTypeArray.length == 0) {
            return true;
        }
        int n = 0;
        while (n < elementTypeArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.elementTypes.length) {
                if (this.elementTypes[n2].equals(elementTypeArray[n])) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean matchCharacteristics(String[] stringArray) {
        if (stringArray.length == 0) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.characteristics.length) {
                if (this.characteristics[n2].equals(stringArray[n])) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public ElementType[] getElementTypes() {
        return this.elementTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String[] getCharacteristics() {
        return this.characteristics;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JobConfig{");
        stringBuffer.append("name=");
        stringBuffer.append(this.name);
        stringBuffer.append("category=");
        stringBuffer.append(this.category);
        stringBuffer.append(", elementTypes=");
        if (this.elementTypes != null) {
            n = 0;
            while (n < this.elementTypes.length) {
                stringBuffer.append(this.elementTypes[n]);
                ++n;
            }
        }
        stringBuffer.append(", characteristics=");
        if (this.characteristics != null) {
            n = 0;
            while (n < this.characteristics.length) {
                stringBuffer.append(this.characteristics[n]);
                ++n;
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

