/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.identity.api;

import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class Identity
implements Comparable,
Serializable {
    private static final String SCCS_ID = "@(#)Identity.java 1.17   04/01/08 SMI";
    static final long serialVersionId = -1436007311644724526L;
    private static final char DELIMITER = '%';
    private static final char DELIMITER1 = '[';
    private static final char DELIMITER2 = ']';
    private static final char[] reservedChar = new char[]{'%', ':', '&', '?', '.', ',', '=', '\'', '\"', '/'};
    private static final char[] substituteChar = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'a'};
    private Identity myParent = null;
    private final String myValue;
    private final IdentityType myType;

    protected static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = -1;
            int n3 = 0;
            while (n3 < reservedChar.length) {
                if (c == reservedChar[n3]) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 != -1) {
                stringBuffer.append('[').append(']');
                stringBuffer.append(substituteChar[n2]);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '[') {
                if (n > n2 + 1 && string.charAt(n2 + 1) == ']') {
                    char c2;
                    n2 += 2;
                    try {
                        c2 = string.charAt(n2);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        throw new IllegalArgumentException("Invalid string");
                    }
                    int n3 = 0;
                    while (n3 < substituteChar.length) {
                        if (c2 == substituteChar[n3]) {
                            stringBuffer.append(reservedChar[n3]);
                            break;
                        }
                        ++n3;
                    }
                } else {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final Identity reconstitute(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return Identity.reconstitute(stringArray);
    }

    public static final Identity reconstitute(String[] stringArray) {
        Identity identity = null;
        if (stringArray != null) {
            Identity identity2 = null;
            int n = 0;
            while (n < stringArray.length) {
                Identity identity3;
                String string = stringArray[n];
                int n2 = string.indexOf(58);
                String string2 = n2 > -1 ? string.substring(0, n2) : null;
                String string3 = n2 > -1 ? string.substring(n2 + 1) : string;
                string3 = Identity.decode(string3);
                IdentityType identityType = string2 != null ? IdentityType.getInstance(string2) : IdentityType.UNKNOWN;
                identity2 = identity3 = new Identity(identity2, string3, identityType);
                identity = identity3;
                ++n;
            }
        }
        return identity;
    }

    public Identity(Identity identity, String string, IdentityType identityType) {
        if (identityType.equals(IdentityType.WWN) || identityType.equals(IdentityType.HOSTNAME)) {
            string = string.toLowerCase();
        } else if (identityType.equals(IdentityType.COP)) {
            string = CIMBeanUtil.getCOPSubject((String)string);
        } else if (identityType.equals(IdentityType.GUID)) {
            if (string != null && !string.startsWith("~")) {
                string = CIMBeanUtil.getCOPSubject((String)string);
            }
        } else if (identityType.equals(IdentityType.IP)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                string = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.myParent = identity;
        this.myValue = string;
        this.myType = identityType;
    }

    public Identity(String string, IdentityType identityType) {
        this(null, string, identityType);
    }

    public Identity(String string) {
        this(string, IdentityType.UNKNOWN);
    }

    public boolean hasParent() {
        return this.myParent != null;
    }

    public Identity getParent() {
        return this.myParent;
    }

    public void setParent(Identity identity) {
        this.myParent = identity;
    }

    public String getValue() {
        return this.myValue;
    }

    public boolean hasType() {
        return this.myType != null;
    }

    public IdentityType getType() {
        return this.myType;
    }

    public String toCondensedString() {
        String string = null;
        if (this.myParent != null) {
            string = this.myParent.toCondensedString();
        }
        String string2 = this.myValue;
        string2 = Identity.encode(string2);
        String string3 = this.myType.toString() + ':' + string2;
        if (string != null) {
            string3 = string + '/' + string3;
        }
        return string3;
    }

    public int compareTo(Object object) {
        Identity identity = object instanceof Identity ? (Identity)object : null;
        String string = identity != null ? identity.toString() : null;
        return this.toString().compareTo(string);
    }

    public String toString() {
        String string = this.myParent != null ? this.myParent.toString() + '/' : null;
        String string2 = string != null ? string + this.getValue() : this.getValue();
        return string2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Identity) {
            Identity identity = (Identity)object;
            if (this.getValue().equals(identity.getValue()) && this.getType().equals(identity.getType())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }
}

