/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.api;

import com.sun.jade.util.unittest.ClassTest;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Search;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.IPSearch;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Properties;

public class IPSearchConfig
implements SearchConfig {
    public static final String NAME = "IP";
    public static final String PROPERTY_IPSTART = "ipstart";
    public static final String PROPERTY_IPEND = "ipend";
    public static final String PROPERTY_TIMEOUT = "timeout";
    public static final String PROPERTY_SLAVE = "slave";
    private String ipEnd;
    private int timeout;
    private String ipStart;
    private int interval;
    private String slaveIP;
    public static final String sccs_id = "@(#)IPSearchConfig.java\t1.9 11/05/03 SMI";

    public String getIpStart() {
        return this.ipStart;
    }

    public String getIpStartAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(this.ipStart);
        return inetAddress.getHostAddress();
    }

    public void setIpStart(String string) {
        this.ipStart = string;
    }

    public String getIpEnd() {
        return this.ipEnd == null ? this.ipStart : this.ipEnd;
    }

    public String getIpEndAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(this.ipEnd == null ? this.ipStart : this.ipEnd);
        return inetAddress.getHostAddress();
    }

    public void setIpEnd(String string) {
        this.ipEnd = string;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public Properties getSearchProperties() {
        Properties properties = new Properties();
        properties.setProperty(PROPERTY_IPSTART, this.getIpStart());
        properties.setProperty(PROPERTY_IPEND, this.getIpEnd());
        properties.setProperty(PROPERTY_TIMEOUT, "" + this.getTimeout());
        if (this.getSlaveIP() != null) {
            properties.setProperty(PROPERTY_SLAVE, this.getSlaveIP());
        }
        return properties;
    }

    public String getName() {
        return NAME;
    }

    public Search newSearch() {
        return new IPSearch(this);
    }

    public int getSearchInterval() {
        return this.interval;
    }

    public void setSearchInterval(int n) {
        this.interval = n;
    }

    public Date getLastSearchTime() {
        return null;
    }

    public String getSlaveIP() {
        return this.slaveIP == null ? "localhost" : this.slaveIP;
    }

    public void setSlaveIP(String string) {
        this.slaveIP = string;
    }

    public static class Test
    extends ClassTest {
        public void test() throws Exception {
            IPSearchConfig iPSearchConfig = new IPSearchConfig();
            this.verifySerialization(iPSearchConfig);
            iPSearchConfig.setIpStart("a");
            iPSearchConfig.setIpEnd("b");
            Properties properties = iPSearchConfig.getSearchProperties();
            this.assertEquals("a", properties.getProperty(IPSearchConfig.PROPERTY_IPSTART));
            this.assertEquals("b", properties.getProperty(IPSearchConfig.PROPERTY_IPEND));
            this.assertEquals(IPSearchConfig.NAME, iPSearchConfig.getName());
            this.assertNotNull(iPSearchConfig.newSearch());
        }
    }
}

