<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="commonimages.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes.xsl"/>
<xsl:include href="errors.xsl"/>
<xsl:include href="context.xsl"/>
<xsl:include href="css-select.xsl"/>
<xsl:template match="/">
  <xsl:variable name="abperson" select="/xslui/iab/bookentry/abperson" /> 

<html>
<head>
<title>
  <xsl:text>_View Contact</xsl:text>
</title>      
<script src="../absjs/browserVersion.js"></script>
<script src="../absjs/scripts.js"></script>
<script>         
    window.focus();
    if (is_ie5up) // IE5
    {    
     document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
    }
    else if (is_gecko) // Netscape 6/7 or Mozilla
    {
      document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
    }
    else  // All others
    {
     document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
    }
</script>
<script language="javascript" src="../absjs/common.js"/>
<script language="javascript" src="../absjs/contact.js"/>
<script language="javascript" src="../absjs/integration.js"/>
<script language="javascript" src="../absjs/entries.js"/>
<script language="javascript">
<xsl:call-template name="commonjavascript"/>  
function edit() {
  url = "editcontact-main.xml?entryid=" + document.iabform.entryid.value;
  parent.window.location = url;
}

function deleteentry() {
  if( confirm(i18n['Are you sure you want to delete this contact'] + "?") ) {
    deleteEntry(document.iabform.entryid.value);  
  }
}

function help() {
 var helpurl = '<xsl:value-of select="/xslui/@contexturi"/>/help/<xsl:text>_languagepath</xsl:text>/addressbk/viewcond.html';
 openhelp(helpurl);
}

function initPage() 
{
  var errornum = '<xsl:value-of select="/xslui/errormessages/error/@errnum"/>';
                                                                                                             
  if( errornum != null &#38;&#38;  errornum != '' &#38;&#38;  errornum == '5' ) {
      //the contact has been deleted hence tell the parent
      var isFromViewGroup = parent.opener.fromViewGroup;
      if( isFromViewGroup ) {
        parent.opener.memberContactDeleted();
      } else {
        reloadParent(true);
      }

      parent.close();
  }
}

<xsl:variable name="isRemoteAB" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@bookremoteurl)"/>    
<xsl:choose>
    <xsl:when test="$isRemoteAB = true()">
	parent.bottom.location.href="popup-bottom.xml";
    </xsl:when>
    <xsl:otherwise>
	parent.bottom.location.href="editdel-popup-bottom.xml";
    </xsl:otherwise>
</xsl:choose>
</script>
</head>
    
<body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0" onload="initPage()">
<form method="POST" name="iabform">

  <table cellspacing="0" cellpadding="0" width="100%" border="0" bgcolor="#CCCCFF">
    <tr>
      <td class="SkpMst"><a href="#nameandcompany">
      <img src="{$spacer.gif}" height="1" width="1" border="0"> 
      <xsl:attribute name="alt">
        <xsl:text>_skipToNameCompany</xsl:text>
      </xsl:attribute>
      </img></a></td>
    <td class="SkpMst"><a href="#phone">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToPhone</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#email">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToEmail</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#addresses">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToAddress</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#online">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToOnline</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#dates">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToDates</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#notes">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToNotes</xsl:text>
      </xsl:attribute>
    </img></a></td>
  </tr>
</table>

  <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
  <input type="hidden" name="uiaction" value=""/>
  <input type="hidden" name="nextview" value="viewcontact.xml"/>
  <input type="hidden" name="entryid" value="{$abperson/entry/@entryID}"/> 
  <xsl:call-template name="contextKeeper">
    <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
  </xsl:call-template>

  <xsl:variable name="err" select="/xslui/errormessages/error"/>
  <xsl:choose>
    <xsl:when test="$err/@errnum = '5'">
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="/xslui/errormessages/error" mode="plain"/>    
    </xsl:otherwise>
  </xsl:choose>
  <span class="PopupTitleText"><a name="top"></a></span> 
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr> 
      <td class="PopupTitle" colspan="4">
      <span class="PopupTitleText">
      <xsl:value-of select="$abperson/person/surname"/>,&nbsp;
      <xsl:value-of select="$abperson/person/givenname"/> &nbsp; 
      <xsl:value-of select="$abperson/person/middlename"/>
      </span></td>
    </tr>
    <tr> 
      <td colspan="4"> 
        <div class="ConJmpScnDiv"> 
          <table border="0" cellspacing="0" cellpadding="0" summary="This table contains contact properties">
                  <tbody>
                <tr>
                  <td valign="top">
                    <div class="ConJmpLnkDiv"><a href="#nameandcompany" class="JmpLnk" tabindex="1">
                   <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Name and Company Section</xsl:text>
                   </xsl:attribute>
                   <img src="../absimx//LrlToAnchor_1.gif" alt="Jump Down to the Online Section" width="16" height="10" border="0"/>
                   <xsl:text>_Name and Company</xsl:text></a></div>
                  </td>
                  <td valign="top">
                    <div class="ConJmpLnkDiv"><a href="#phone" class="JmpLnk" tabindex="2">
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Phone Section</xsl:text>                    
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Phone Section" width="16" height="10" border="0"/>        
                   <xsl:text>_Phone</xsl:text></a></div>
                  </td>
                  <td valign="top">
                    <div class="ConJmpLnkDiv"><a href="#email" class="JmpLnk" tabindex="3">                            
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Email Section</xsl:text>                    
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Email Section" width="16" height="10" border="0"/>
                    <xsl:text>_Email</xsl:text></a></div>
                  </td>
                  <td valign="top">
                    <div class="ConJmpLnkDiv"><a href="#addresses" class="JmpLnk" tabindex="4">                     
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Addresses Section</xsl:text>                    
                    </xsl:attribute><img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Addresses Section" width="16" height="10" border="0"/>           
                    <xsl:text>_Addresses</xsl:text></a></div>
                  </td>
                </tr>
                <tr>
                  <td valign="top">
                    <div class="ConJmpLnkDiv"><a href="#online" class="JmpLnk" tabindex="5">                         
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Addresses Section</xsl:text>                    
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Online Section" width="16" height="10" border="0"/>
                    <xsl:text>_Online</xsl:text></a></div>
                  </td>

                  <td valign="top">
                    <div class="ConJmpLnkDiv"><a href="#dates" class="JmpLnk" tabindex="6">                    
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the dates Section</xsl:text>                    
                    </xsl:attribute>                    
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Dates Section" width="16" height="10" border="0"/>
                    <xsl:text>_Dates</xsl:text></a></div>
                  </td>
                  <td valign="top">
                    <div class="ConJmpLnkDiv"><a href="#notes" class="JmpLnk" tabindex="7">
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the notes Section</xsl:text>                    
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Notes Section" width="16" height="10" border="0"/>
                   <xsl:text>_Notes</xsl:text></a></div>
                  </td>
                  <td valign="top">&nbsp;</td>
                </tr>
                </tbody>
          </table>
        </div>
      </td>
    </tr> 
    <tr> 
      <td colspan="4"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
            <td width="100%" class="SectionDivider"><img alt="" src="../absimx/spacer.gif" width="1" height="5"/></td>
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" colspan="4"><span class="SectionHeader">
      <xsl:text>_Name and Company</xsl:text>
      </span></td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%"><span class="Lbl2">
      <xsl:text>_Display Name</xsl:text>:</span></td>
      <td width="21%"><xsl:value-of select="$abperson/entry/displayname"/></td>
      <td width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:text>_Company</xsl:text>:</span></td>
      <td width="21%"><xsl:value-of select="$abperson/organization/company"/></td>
      <td class="PropLabelAb" width="17%">
      <span class="Lbl2"><xsl:text>_Job Title</xsl:text>: </span></td>
      <td width="41%"><xsl:value-of select="$abperson/organization/title"/></td>
    </tr>   
    <tr> 
      <td colspan="4"><img alt="" src="../absimx/spacer.gif" width="10" height="8"/><span class="SectionHeader"><a name="phone"></a></span></td>
    </tr>
    <tr> 
      <td colspan="4"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
            <td width="100%" class="SectionDivider"><img alt="" src="../absimx/spacer.gif" width="1" height="5"/></td>
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" colspan="4"><span class="SectionHeader"><xsl:text>_Phone</xsl:text></span></td>
    </tr>
    <tr> 
      <xsl:call-template name="view-contactInfo">
	<xsl:with-param name="contactInfo" select="$abperson/phone[@priority='1']"/>
	<xsl:with-param name="contactType" select="'phone'"/>
      </xsl:call-template>
      <xsl:call-template name="view-contactInfo">
	<xsl:with-param name="contactInfo" select="$abperson/phone[@priority='2']"/>
	<xsl:with-param name="contactType" select="'phone'"/>
      </xsl:call-template>
    </tr>
    <tr> 
      <xsl:call-template name="view-contactInfo">
	<xsl:with-param name="contactInfo" select="$abperson/phone[@priority='3']"/>
	<xsl:with-param name="contactType" select="'phone'"/>
      </xsl:call-template>
      <xsl:call-template name="view-contactInfo">
	<xsl:with-param name="contactInfo" select="$abperson/phone[@priority='4']"/>
	<xsl:with-param name="contactType" select="'phone'"/>
      </xsl:call-template>
    </tr>
    <tr> 
      <xsl:call-template name="view-contactInfo">
	<xsl:with-param name="contactInfo" select="$abperson/phone[@priority='5']"/>
	<xsl:with-param name="contactType" select="'phone'"/>
      </xsl:call-template>
      <td width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td width="21%"> 
        <div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" tabindex="8">
         <xsl:attribute name="title">
           <xsl:text>_Jump Down to top</xsl:text>
         </xsl:attribute>
        <img src="../absimx/LrlToTop_1.gif" alt="Jump to Top of Page" width="11" height="10" border="0"/><xsl:text>_Jump Down to top</xsl:text></a></div>
      </td>
      <td width="21%">&nbsp;</td>
      <td width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="4"><img alt="" src="../absimx/spacer.gif" width="10" height="8"/><span class="SectionHeader"><a name="email"></a></span></td>
    </tr>
    <tr> 
      <td colspan="4"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
            <td width="100%" class="SectionDivider"><img alt="" src="../absimx/spacer.gif" width="1" height="5"/></td>
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" colspan="4"><span class="SectionHeader"><xsl:text>_Email</xsl:text></span></td>
    </tr>
    <tr> 
      <xsl:call-template name="view-contactInfo">
	<xsl:with-param name="contactInfo" select="$abperson/email[@priority='1']"/>
	<xsl:with-param name="contactType" select="'email'"/>
        <xsl:with-param name="tabindex" select="'9'"/>
      </xsl:call-template>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <xsl:call-template name="view-contactInfo">
	<xsl:with-param name="contactInfo" select="$abperson/email[@priority='2']"/>
	<xsl:with-param name="contactType" select="'email'"/>
        <xsl:with-param name="tabindex" select="'10'"/>
      </xsl:call-template>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <xsl:call-template name="view-contactInfo">
	<xsl:with-param name="contactInfo" select="$abperson/email[@priority='3']"/>
	<xsl:with-param name="contactType" select="'email'"/>
        <xsl:with-param name="tabindex" select="'11'"/>
      </xsl:call-template>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td width="21%"> 
        <div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" tabindex="12">
       <xsl:attribute name="title">
           <xsl:text>_Jump Down to top</xsl:text>
       </xsl:attribute>
       <img src="../absimx/LrlToTop_1.gif" alt="Jump to Top of Page" width="11" height="10" border="0"/><xsl:text>_Jump Down to top</xsl:text></a></div>
      </td>
      <td colspan="2">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="4"><img alt="" src="../absimx/spacer.gif" width="10" height="8"/><span class="SectionHeader"><a name="addresses"></a></span></td>
    </tr>
    <tr> 
      <td colspan="4"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
            <td width="100%" class="SectionDivider"><img alt="" src="../absimx/spacer.gif" width="1" height="5"/></td>
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" width="21%"><span class="SectionHeader"><xsl:text>_Addresses</xsl:text></span></td>
      <td width="21%">&nbsp;</td>
      <td width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%" valign="top"><span class="Lbl2"><xsl:text>_Work</xsl:text>:</span></td>
      <td colspan="2" valign="top">
         <xsl:call-template name="break-new-lines">
           <xsl:with-param name="text" select="$abperson/postaladdress[@type='work']/street"/>
         </xsl:call-template><br/>
         <xsl:value-of select="$abperson/postaladdress[@type='work']/city"/>&nbsp;<xsl:value-of select="$abperson/postaladdress[@type='work']/state"/>
         &nbsp;<xsl:value-of select="$abperson/postaladdress[@type='work']/postalcode"/></td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="4" valign="top"><img alt="" src="../absimx/spacer.gif" width="1" height="10"/></td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%" valign="top"><span class="Lbl2"><xsl:text>_Home</xsl:text>:</span></td>
      <td colspan="2" valign="top"><xsl:call-template name="break-new-lines">
         <xsl:with-param name="text" select="$abperson/postaladdress[@type='home']/street"/>
         </xsl:call-template><br/>
         <xsl:value-of select="$abperson/postaladdress[@type='home']/city"/>&nbsp;<xsl:value-of select="$abperson/postaladdress[@type='home']/state"/>
         &nbsp;<xsl:value-of select="$abperson/postaladdress[@type='home']/postalcode"/></td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td width="21%"> 
        <div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" tabindex="13">
        <xsl:attribute name="title">
           <xsl:text>_Jump Down to top</xsl:text>
         </xsl:attribute><img src="../absimx/LrlToTop_1.gif" alt="Jump to Top of Page" width="11" height="10" border="0"/><xsl:text>_Jump Down to top</xsl:text></a></div>
      </td>
      <td width="21%" valign="top">&nbsp;</td>
      <td width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="4"><img alt="" src="../absimx/spacer.gif" width="10" height="8"/><span class="SectionHeader"><a name="online"></a></span></td>
    </tr>
    <tr> 
      <td colspan="4"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
            <td width="100%" class="SectionDivider"><img alt="" src="../absimx/spacer.gif" width="1" height="5"/></td>
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" width="21%"><span class="SectionHeader"><xsl:text>_Online</xsl:text></span></td>
      <td width="21%">&nbsp;</td>
      <td width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:text>_Web Address (1)</xsl:text>:</span></td>
      <td colspan="3">
	<xsl:call-template name="view-contactInfo">
	  <xsl:with-param name="contactInfo" select="$abperson/weburl[@priority='1']"/>
	  <xsl:with-param name="contactType" select="'misc'"/>
          <xsl:with-param name="tabindex" select="'14'"/>
	</xsl:call-template>
      </td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:text>_Web Address (2)</xsl:text>:</span></td>
      <td colspan="3">
	<xsl:call-template name="view-contactInfo">
	  <xsl:with-param name="contactInfo" select="$abperson/weburl[@priority='2']"/>
	  <xsl:with-param name="contactType" select="'misc'"/>
          <xsl:with-param name="tabindex" select="'15'"/>
	</xsl:call-template>
      </td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:text>_Calendar Address</xsl:text>:</span></td>
      <td colspan="3">
	<xsl:call-template name="view-contactInfo">
	  <xsl:with-param name="contactInfo" select="$abperson/calendar[@type='calendar']"/>
	  <xsl:with-param name="contactType" select="'misc'"/>
          <xsl:with-param name="tabindex" select="'16'"/>
	</xsl:call-template>
      </td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:text>_Availability Address</xsl:text>:</span></td>
      <td colspan="3">
	<xsl:call-template name="view-contactInfo">
	  <xsl:with-param name="contactInfo" select="$abperson/calendar[@type='freebusy']"/>
	  <xsl:with-param name="contactType" select="'misc'"/>
          <xsl:with-param name="tabindex" select="'17'"/>
	</xsl:call-template>
      </td>
    </tr>
    <tr> 
      <td class="SubSectionHdrAb" colspan="4"><span class="SubSectionHeader"><xsl:text>_Instant Messaging (IM) Nickname and Service</xsl:text></span></td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:text>_Nickname (1)</xsl:text>:</span></td>
      <td width="21%"><xsl:value-of select="$abperson/im[@priority='1']"/></td>
      <td class="PropLabelAb" width="17%"><span class="Lbl2"><xsl:text>_Nickname (2)</xsl:text>:</span></td>
      <td width="41%"><xsl:value-of select="$abperson/im[@priority='2']"/></td>
    </tr>
    <tr> 
      <td width="21%"> 
        <div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" tabindex="18">
       <xsl:attribute name="title">
           <xsl:text>_Jump Down to top</xsl:text>
         </xsl:attribute><img src="../absimx/LrlToTop_1.gif" alt="Jump to Top of Page" width="11" height="10" border="0"/><xsl:text>_Jump Down to top</xsl:text></a></div>
      </td>
      <td width="21%">&nbsp;</td>
      <td class="PropLabelAb" width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="4"><img alt="" src="../absimx/spacer.gif" width="10" height="8"/><span class="SectionHeader"><a name="dates"></a></span></td>
    </tr>
    <tr> 
      <td colspan="4"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
            <td width="100%" class="SectionDivider"><img alt="" src="../absimx/spacer.gif" width="1" height="5"/></td>
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" width="21%"><span class="SectionHeader"><xsl:text>_Dates</xsl:text></span></td>
      <td width="21%">&nbsp;</td>
      <td width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:text>_Birthday</xsl:text>:</span></td>
      <td width="21%"><xsl:value-of select="$abperson/person/date[@type='birthday']"/></td>
      <td class="PropLabelAb"  width="17%"><span class="Lbl2"><xsl:text>_Anniversary</xsl:text>:</span></td>
      <td width="41%"><xsl:value-of select="$abperson/person/date[@type='anniversary']"/></td>
    </tr>
    <tr> 
      <td width="21%"> 
        <div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" tabindex="19">
        <xsl:attribute name="title">
           <xsl:text>_Jump Down to top</xsl:text>
         </xsl:attribute><img src="../absimx/LrlToTop_1.gif" alt="Jump to Top of Page" width="11" height="10" border="0"/><xsl:text>_Jump Down to top</xsl:text></a></div>
      </td>
      <td width="21%">&nbsp;</td>
      <td class="PropLabelAb"  width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="4"><img alt="" src="../absimx/spacer.gif" width="10" height="8"/><span class="SectionHeader"><a name="notes"></a></span></td>
    </tr>
    <tr> 
      <td colspan="4"> 
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
            <td width="100%" class="SectionDivider"><img alt="" src="../absimx/spacer.gif" width="1" height="5"/></td>
            <td width="1%"><img alt="" src="../absimx/spacer.gif" width="10" height="5"/></td>
          </tr>
        </table>
      </td>
    </tr>
    <tr> 
      <td class="SectionHeader" width="21%"><span class="SectionHeader"><xsl:text>_Notes</xsl:text></span></td>
      <td width="21%">&nbsp;</td>
      <td width="17%">&nbsp;</td>
      <td width="41%">&nbsp;</td>
    </tr>
    <tr> 
      <td class="PropLabelAb" colspan="4">
        <xsl:call-template name="break-new-lines">
          <xsl:with-param name="text" select="$abperson/entry/description"/>
        </xsl:call-template>
      </td>
    </tr>
    <tr> 
      <td colspan="4"> 
        <div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" tabindex="20">
          <xsl:attribute name="title">
            <xsl:text>_Jump Down to top</xsl:text>
          </xsl:attribute>
         <img src="../absimx/LrlToTop_1.gif" alt="Jump to Teop of Page" width="11" height="10" border="0"/><xsl:text>_Jump Down to top</xsl:text></a></div>
      </td>
    </tr>
  </table>
  <xsl:for-each select="/xslui/iab/alreadyselected/*">
    <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
  </xsl:for-each>
  <xsl:apply-templates select="/xslui/iab/alreadyselected" mode="hidden"/>  
  </form>
</body>
</html>
</xsl:template>

<!--
*******************************************************************************
* This prints the contact info (phone or email) labelled as the correct type
* @param contactInfo The phone or the email element which has to be printed
*******************************************************************************
-->
<xsl:template name="view-contactInfo">
  <xsl:param name="contactInfo"/>
  <xsl:param name="contactType"/>
  <xsl:param name="tabindex"/>

  <xsl:variable name="displayType">
    <xsl:if test="$contactInfo/@type = 'work'"><xsl:text>_Work</xsl:text></xsl:if>
    <xsl:if test="$contactInfo/@type = 'home'"><xsl:text>_Home</xsl:text></xsl:if>
    <xsl:if test="$contactInfo/@type = 'mobile'"><xsl:text>_Mobile</xsl:text></xsl:if>
    <xsl:if test="$contactInfo/@type = 'pager'"><xsl:text>_Pager</xsl:text></xsl:if>
    <xsl:if test="$contactInfo/@type = 'fax'"><xsl:text>_Fax</xsl:text></xsl:if>
    <xsl:if test="$contactInfo/@type = 'sms'"><xsl:text>_SMS</xsl:text></xsl:if>
    <xsl:if test="$contactInfo/@type = 'other'"><xsl:text>_Other</xsl:text></xsl:if>
  </xsl:variable>
  <xsl:if test="string-length($contactInfo) &gt; 0">
    <xsl:if test="$contactType = 'phone'">	
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:value-of select="$displayType"/>
      <xsl:if test="$contactInfo/@priority = '1'">&nbsp;(<xsl:text>_(Primary)</xsl:text>)</xsl:if>:
      </span></td>
      <td width="21%"><xsl:value-of select="$contactInfo"/></td>
    </xsl:if>
    <xsl:if test="$contactType = 'email'">	
      <td class="PropLabelAb" width="21%"><span class="Lbl2"><xsl:value-of select="$displayType"/>
      <xsl:if test="$contactInfo/@priority = '1'">&nbsp;(<xsl:text>_(Primary)</xsl:text>)</xsl:if>:
      </span></td>
      <td colspan="2">
        <xsl:variable name="mailpref">
          <xsl:choose>
          <xsl:when test="/xslui/profileinfo/xmlprofile/generalprefs/@webmail='uc' and /xslui/usersession/@mailenabled='true'">
            <xsl:value-of select="'uc'"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'desktop'"/>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:variable>
	<a class="Lnk">
          <xsl:attribute name="href">
            <xsl:text>javascript:sendMail("</xsl:text>
            <xsl:value-of select="/xslui/usersession/@mailurl"/>
            <xsl:text>","</xsl:text>
            <xsl:value-of select="$mailpref"/>
            <xsl:text>","</xsl:text>
	    <xsl:value-of select="$contactInfo"/>
            <xsl:text>");</xsl:text>
	  </xsl:attribute>
	  <xsl:attribute name="tabindex">
	    <xsl:value-of select="$tabindex"/>
	  </xsl:attribute>
	  <xsl:value-of select="$contactInfo"/>
	</a>
      </td>
    </xsl:if>
    <xsl:if test="$contactType = 'misc'">	
	<a class="Lnk" target="_blank">
          <xsl:attribute name="href">
	    <xsl:value-of select="$contactInfo"/>
	  </xsl:attribute>
	  <xsl:attribute name="tabindex">
	    <xsl:value-of select="$tabindex"/>
	  </xsl:attribute>
	  <xsl:value-of select="$contactInfo"/>
	</a>
    </xsl:if>
  </xsl:if>
</xsl:template>

<!--
*******************************************************************************
* This prints the error messages on the search page
* @param err The error element from which to extract the error code
*******************************************************************************
-->
<xsl:template name="error-message">
  <xsl:param name="err" select="." />

  <xsl:choose>
    <xsl:when test="$err/@errnum = '270'">
      <b>
        <xsl:text>_An error ocurred while trying to retrieve contact info</xsl:text>&nbsp;
      </b>
      <br/><br/>
        <xsl:text>_Entry ID is invalid</xsl:text>&nbsp;
        (<xsl:value-of select="$err/@entryid" />).
      <br/><br/>
      <xsl:text>_If this error persists, contact your system administrator</xsl:text>.
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>_Unknown error (</xsl:text>
      <xsl:value-of select="$err/@errnum" /> 
      <xsl:text>)</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$err/@rawmsg">
    <br/><br/>
    <xsl:value-of select="$err/@rawmsg" />&nbsp;
  </xsl:if> 
</xsl:template> 


</xsl:stylesheet>

