<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
<xsl:output method="html" version="4" encoding="UTF-8"/>
<xsl:variable name="valueSeparator" select="';'"/>

<xsl:include href="banner.xsl"/>
<xsl:include href="commonimages.xsl"/>
<xsl:include href="commonattributes.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="commonattributes-list.xsl"/>
<xsl:include href="entries-list.xsl"/>
<xsl:include href="errors.xsl"/>
<xsl:include href="search-template.xsl"/>
<xsl:include href="search-images.xsl"/>
<xsl:include href="context.xsl"/>
<xsl:include href="css-select.xsl"/>
  
<!--
*******************************************************************************
* This template formats and prints the tool bar
* @param iconDisplay The icon display mode (1: both images and text, 2: images, 3: text
* @param isRemoteAB Wether or not the current address book is a corporate one
*******************************************************************************
-->
<xsl:template name="search-template-toolbar">
  <xsl:param name="iconDisplay" select="'1'"/>
  <xsl:param name="isRemoteAB" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@bookremoteurl)" />
  <xsl:param name="selectedBook" select="/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]"/>

  <xsl:variable name="currentbookid">
    	<xsl:value-of select="/xslui/iab/pagedsearch/searchresult/@bookid"/>
    </xsl:variable>
    
  <xsl:variable name="totalentries">
       <xsl:value-of select="number(/xslui/iab/pagedsearch/searchresult/@totalentries)"/>
  </xsl:variable>

  <a name="toolbar"></a>
  <div class="Toolbar"> 
    <table cellspacing="0" cellpadding="0" border="0">
      <xsl:attribute name="title"><xsl:text>_Toolbar</xsl:text></xsl:attribute>
      <xsl:attribute name="summary"><xsl:text>_Toolbar Summary</xsl:text></xsl:attribute>
      <tr> 
        <xsl:choose>
        <xsl:when test="not($isRemoteAB)">
          <td>        
          <xsl:attribute name="nowrap"/>
           <a href="javascript:void(0)" accesskey="c" onMouseOver="over('newContact')" onFocus="over('newContact')" onMouseOut="out('newContact')" onBlur="out('newContact')"  >
             <xsl:attribute name="onClick">
               <xsl:text>javascript:openWinAutoHeight('addcontact-main.xml?bookid=</xsl:text>
               <xsl:value-of select="$selectedBook/entry/@entryID"/>
               <xsl:text>', 'NewContact', 'scrollbars=yes,resizable=yes,width=700');</xsl:text>
             </xsl:attribute>
             <xsl:attribute name="onKeyPress">
               <xsl:text>javascript:openWinAutoHeight('addcontact-main.xml?bookid=</xsl:text>
               <xsl:value-of select="$selectedBook/entry/@entryID"/>
               <xsl:text>', 'NewContact', 'scrollbars=yes,resizable=yes,width=700');</xsl:text>
             </xsl:attribute>
             <xsl:attribute name="title"><xsl:text>_Create New Contact</xsl:text></xsl:attribute>
             <img name="newContact" src="{$new_user.gif}" width="24" height="24" border="0" align="absmiddle">
               <xsl:attribute name="title"><xsl:text>_Create New Contact</xsl:text></xsl:attribute>
               <xsl:attribute name="alt"><xsl:text>_Create New Contact</xsl:text></xsl:attribute>
             </img>
           </a> 
           <a class="ToolLbl" href="javascript:void(0)">
             <xsl:attribute name="onClick">
               <xsl:text>javascript:openWinAutoHeight('addcontact-main.xml?bookid=</xsl:text>
               <xsl:value-of select="$selectedBook/entry/@entryID"/>
               <xsl:text>', 'NewContact', 'scrollbars=yes,resizable=yes,width=700');</xsl:text>
            </xsl:attribute>
             <xsl:attribute name="onKeyPress">
               <xsl:text>javascript:openWinAutoHeight('addcontact-main.xml?bookid=</xsl:text>
               <xsl:value-of select="$selectedBook/entry/@entryID"/>
               <xsl:text>', 'NewContact', 'scrollbars=yes,resizable=yes,width=700');</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="title"><xsl:text>_Create New Contact</xsl:text></xsl:attribute>
            <xsl:text>_New Contact</xsl:text></a>
          </td>
          <td class="ToolbarItem">
          <xsl:attribute name="nowrap"/>
            <a href="javascript:void(0)" onMouseOver="over('newGroup')" onFocus="over('newGroup')" onMouseOut="out('newGroup')" onBlur="out('newGroup')">
            <xsl:attribute name="title"><xsl:text>_Create New Group</xsl:text></xsl:attribute>
            <xsl:attribute name="onClick">
            <xsl:text>javascript:openWinAutoHeight('addgroup-main.xml?bookid=</xsl:text>
             <xsl:value-of select="$selectedBook/entry/@entryID"/>
             <xsl:text>', 'NewGroup', 'scrollbars=yes,resizable=yes,width=700');</xsl:text>
             </xsl:attribute>
            <xsl:attribute name="onKeyPress">
            <xsl:text>javascript:openWinAutoHeight('addgroup-main.xml?bookid=</xsl:text>
             <xsl:value-of select="$selectedBook/entry/@entryID"/>
             <xsl:text>', 'NewGroup', 'scrollbars=yes,resizable=yes,width=700');</xsl:text>
             </xsl:attribute>
             <img name="newGroup" src="{$new_group.gif}" width="24" height="24" border="0" align="absmiddle">
               <xsl:attribute name="title"><xsl:text>_Create New Group</xsl:text></xsl:attribute>
               <xsl:attribute name="alt"><xsl:text>_Create New Group</xsl:text></xsl:attribute>
             </img>
            </a> 
            <a class="ToolLbl" href="javascript:void(0)" onClick="javascript:openPopup('addgroup.xml','newgroup')">
            <xsl:attribute name="onClick">
            <xsl:text>javascript:openWinAutoHeight('addgroup-main.xml?bookid=</xsl:text>
            <xsl:value-of select="$selectedBook/entry/@entryID"/>
            <xsl:text>', 'NewGroup', 'scrollbars=yes,resizable=yes,width=700');</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="onKeyPress">
            <xsl:text>javascript:openWinAutoHeight('addgroup-main.xml?bookid=</xsl:text>
            <xsl:value-of select="$selectedBook/entry/@entryID"/>
            <xsl:text>', 'NewGroup', 'scrollbars=yes,resizable=yes,width=700');</xsl:text>
            </xsl:attribute>            
            <xsl:attribute name="title"><xsl:text>_Create New Group</xsl:text></xsl:attribute>
            <xsl:text>_New Group</xsl:text></a>
          </td>
          <td class="ToolbarItem">
          <xsl:attribute name="nowrap"/>
          <xsl:choose>
            <xsl:when test="$totalentries > 0">  
           <a href="javascript:void(0)" accesskey="p" onMouseOver="over('printCopy')" onFocus="over('printCopy')" onMouseOut="out('printCopy')" onBlur="out('printCopy')">
             <xsl:attribute name="title"><xsl:text>_Create New Group</xsl:text></xsl:attribute>
             <xsl:attribute name="onClick">
       		<xsl:text>openWinAutoHeight('abprnlist.xml?bookid=</xsl:text>
       		<xsl:value-of select="$currentbookid"/>
       		<xsl:text>','printCopy','scrollbars=yes,resizable=yes,menubar=yes')</xsl:text>
             </xsl:attribute>                   
             <xsl:attribute name="onKeyPress">
       		<xsl:text>openWinAutoHeight('abprnlist.xml?bookid=</xsl:text>
       		<xsl:value-of select="$currentbookid"/>
       		<xsl:text>','printCopy','scrollbars=yes,resizable=yes,menubar=yes')</xsl:text>
             </xsl:attribute>  
             <img name="printCopy" src="{$print_page.gif}" width="24" height="24" border="0" align="absmiddle">
               <xsl:attribute name="title"><xsl:text>_Printable Format</xsl:text></xsl:attribute>
               <xsl:attribute name="alt"><xsl:text>_Printable Format</xsl:text></xsl:attribute>
             </img>
           </a> 
           <a class="ToolLbl" href="javascript:void(0)">
           <xsl:attribute name="onClick">
       	     <xsl:text>openWinAutoHeight('abprnlist.xml?bookid=</xsl:text>
       	     <xsl:value-of select="$currentbookid"/>
       	     <xsl:text>','printable','scrollbars=yes,resizable=yes,menubar=yes')</xsl:text>
           </xsl:attribute>
           <xsl:attribute name="onKeyPress">
       	     <xsl:text>openWinAutoHeight('abprnlist.xml?bookid=</xsl:text>
       	     <xsl:value-of select="$currentbookid"/>
       	     <xsl:text>','printable','scrollbars=yes,resizable=yes,menubar=yes')</xsl:text>
           </xsl:attribute>
           <xsl:attribute name="title"><xsl:text>_Printable Format</xsl:text></xsl:attribute>
           <xsl:text>_Printable</xsl:text>
           </a> 
           </xsl:when>
           <xsl:otherwise>
             <img name="printCopy" src="{$print_page_grey.gif}" width="24" height="24" border="0" align="absmiddle">
              <xsl:attribute name="title"><xsl:text>_Printable Format</xsl:text></xsl:attribute>
              <xsl:attribute name="alt"><xsl:text>_Printable Format</xsl:text></xsl:attribute>
             </img>
             <span class="DisIcnTxt">
              <xsl:attribute name="title"><xsl:text>_Printable Format</xsl:text></xsl:attribute>
               <xsl:text>_Printable</xsl:text>
             </span>
           </xsl:otherwise>
          </xsl:choose>
          </td>
          <td class="ToolbarItem">
          <xsl:attribute name="nowrap"/>
            <a href="javascript:void(0)" onMouseOver="over('importExport')" onFocus="over('importExport')" onMouseOut="out('importExport')" onBlur="out('importExport')" onClick="javascript:goToImportExport()" onKeyPress="javascript:goToImportExport()" >
                <xsl:attribute name="title"><xsl:text>_Import/Export Address Book</xsl:text></xsl:attribute>
              <img name="importExport" src="{$imp_exp_add_book.gif}" width="24" height="24" border="0" align="absmiddle">
                <xsl:attribute name="title"><xsl:text>_Import/Export Address Book</xsl:text></xsl:attribute>
                <xsl:attribute name="alt"><xsl:text>_Import/Export Address Book</xsl:text></xsl:attribute>
            </img></a> 
            <a class="ToolLbl" href="javascript:void(0)" onClick="javascript:goToImportExport()" onKeyPress="javascript:goToImportExport()">
            <xsl:attribute name="title"><xsl:text>_Import/Export Address Book</xsl:text></xsl:attribute>
           <xsl:text>_Import/Export</xsl:text></a> 
          </td>
        </xsl:when>
        <xsl:otherwise>          
          <td>        
          <xsl:attribute name="nowrap"/>
           <img name="newContact" src="{$new_user_grey.gif}" width="24" height="24" border="0" align="absmiddle"><xsl:attribute name="title"><xsl:text>_Create New Contact</xsl:text></xsl:attribute></img><span class="DisIcnTxt"><xsl:attribute name="title"><xsl:text>_Create New Contact</xsl:text></xsl:attribute><xsl:text>_New Contact</xsl:text></span>
          </td>
          <td class="ToolbarItem">
          <xsl:attribute name="nowrap"/>
           <img name="newGroup" src="{$new_group_grey.gif}" width="24" height="24" border="0" align="absmiddle"><xsl:attribute name="title"><xsl:text>_Create New Group</xsl:text></xsl:attribute></img><span class="DisIcnTxt"><xsl:attribute name="title"><xsl:text>_Create New Group</xsl:text></xsl:attribute><xsl:text>_New Group</xsl:text></span>
          </td>
          <td class="ToolbarItem">
          <xsl:attribute name="nowrap"/>
            <img name="printable" src="{$print_page_grey.gif}" width="24" height="24" border="0" align="absmiddle"><xsl:attribute name="title"><xsl:text>_Printable Format</xsl:text></xsl:attribute><xsl:attribute name="alt"><xsl:text>_Printable Format</xsl:text></xsl:attribute></img><span class="DisIcnTxt"><xsl:attribute name="title"><xsl:text>_Printable Format</xsl:text></xsl:attribute><xsl:text>_Printable</xsl:text></span>
          </td>
          <td class="ToolbarItem">
          <xsl:attribute name="nowrap"/>
            <img name="importexport" src="{$imp_exp_add_book_grey.gif}" width="24" height="24" border="0" align="absmiddle"> <xsl:attribute name="title"><xsl:text>_Import/Export Address Book</xsl:text></xsl:attribute></img><span class="DisIcnTxt"><xsl:attribute name="title"><xsl:text>_Import/Export Address Book</xsl:text></xsl:attribute><xsl:text>_Import/Export</xsl:text></span>
          </td>
         </xsl:otherwise>
        </xsl:choose>
      </tr>
    </table>
  </div>    
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr> 
      <td width="100%" class="TlLin"><img src="{$spacer.gif}"  width="1" height="1" alt=""/></td>
    </tr>
  </table>      
</xsl:template>


<!--
*******************************************************************************
* This templates prints the action bar
* @param id The unique id of the action bar. It is used when generating the field names
* @param searchResult The node containing the results of the current search. It is only used for page navigation.
*******************************************************************************
-->
<xsl:template name="search-actionbar">
<xsl:param name="id" select="'0'" />
<xsl:param name="searchResult" /> 
<xsl:param name="showResult"/> 
<xsl:param name="colspan" select="5"/>
<xsl:param name="displaySeparators" select="0" />
<xsl:param name="tdClass" select="'TblActTd'"/>  
<xsl:param name="isRemoteAB" select="false()"/> 

<xsl:variable name="calenabled" select="/xslui/usersession/@calendarenabled"/>
<xsl:variable name="mailpref">
<xsl:choose>
  <xsl:when test="/xslui/profileinfo/xmlprofile/generalprefs/@webmail='uc' and /xslui/usersession/@mailenabled='true'">
    <xsl:value-of select="'uc'"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of select="'desktop'"/>
  </xsl:otherwise>
</xsl:choose>
</xsl:variable>

 <xsl:choose>
 <xsl:when test="$isRemoteAB">    
  <tr>      
   <td colspan="3">                      
     <xsl:attribute name="class"><xsl:value-of select="$tdClass"/></xsl:attribute>  
     <input type="submit" class="Btn1Dis" name="deleteButton" value="Delete" onFocus="if (this.disabled==0) this.className='Btn1Hov'"  onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'">
      <xsl:attribute name="disabled"/>
      <xsl:attribute name="value">
        <xsl:text>_Delete</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="title">
        <xsl:text>_Delete is disabled</xsl:text>
      </xsl:attribute>
     </input>&nbsp;
     <xsl:choose>
     <xsl:when test="$showResult='1'">
      <input class="Btn1" type="submit" name="addtoaddressbutton" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'"  onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'">
      <xsl:attribute name="onClick">
       <xsl:text>javascript:copySelected()</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="onKeyPress">
       <xsl:text>javascript:copySelected()</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="value">
        <xsl:text>_Add To Personal Address Book</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="title">
        <xsl:text>_Add to Address Book is Enabled</xsl:text>
      </xsl:attribute>
      </input>
     </xsl:when>
     <xsl:otherwise>
       <input class="Btn1Dis" type="submit" name="addtoaddressbutton" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'">
        <xsl:attribute name="disabled"/>
        <xsl:attribute name="value">
        <xsl:text>_Add To Personal Address Book</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="title">
        <xsl:text>_Add to Address Book is Disabled</xsl:text>
        </xsl:attribute>
       </input>
     </xsl:otherwise>
     </xsl:choose>&nbsp;
     <xsl:choose>
     <xsl:when test="$showResult='1' or $showResult='2'">
       <select class="ActMenu" name="abaction" id="abActions" tabindex="3" onChange="execSelectAction(this)">
         <xsl:attribute name="title">
           <xsl:text>_Select action</xsl:text>
         </xsl:attribute>
        <option><xsl:text>_Select action</xsl:text></option>
        <option>
         <xsl:attribute name="value">
           <xsl:text>javascript:sendMailFromSelected('</xsl:text>
           <xsl:value-of select="/xslui/usersession/@mailurl"/>
           <xsl:text>', '</xsl:text>
           <xsl:value-of select="$mailpref"/>
           <xsl:text>')</xsl:text>
         </xsl:attribute>
         <xsl:text>_Send Email</xsl:text>
         </option>
        <xsl:if test="$calenabled='true'"> 
          <option>
          <xsl:attribute name="value">
           <xsl:text>javascript:viewCalendarFromSelected('</xsl:text>
           <xsl:value-of select="/xslui/@contexturi"/>
           <xsl:text>')</xsl:text>
           </xsl:attribute>
           <xsl:text>_View Calendar</xsl:text>
          </option>
        </xsl:if>
       </select>
     </xsl:when>
     <xsl:otherwise>
      <select class="ActMenu" name="abaction" id="abActions" tabindex="3" onChange="go(this)">
       <xsl:attribute name="disabled"/>
       <xsl:attribute name="title">
         <xsl:text>_Select action</xsl:text>
       </xsl:attribute>
       <option><xsl:text>_Select action</xsl:text></option>
      </select>
      </xsl:otherwise>
     </xsl:choose>
   </td>    
    <xsl:choose>
      <xsl:when test="$showResult='1'">
        <xsl:call-template name="search-template-paging">
          <xsl:with-param name="searchresult" select="$searchResult"/>          
          <xsl:with-param name="tdClass" select="$tdClass"/>
          <xsl:with-param name="colspan" select="number($colspan)-3"/>
          <xsl:with-param name="popup" select="false()"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <td class="TblActTd">
           <xsl:attribute name="colspan">
              <xsl:value-of select="number($colspan)-3"/>
           </xsl:attribute>
           <xsl:attribute name="nowrap"/>
           <xsl:text>&nbsp;</xsl:text>
        </td>
      </xsl:otherwise>
      </xsl:choose>
   </tr>   
</xsl:when>
<xsl:otherwise>          
 <tr>        
 <td colspan="3">     
 <xsl:attribute name="class"><xsl:value-of select="$tdClass"/></xsl:attribute>                         
 <xsl:choose>
 <xsl:when test="$showResult!='1'">
   <input type="submit" class="Btn1Dis" name="deleteButton" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'">
      <xsl:attribute name="disabled"/>
       <xsl:attribute name="value">
        <xsl:text>_Delete</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="title">
        <xsl:text>_Delete is disabled</xsl:text>
      </xsl:attribute>
   </input>&nbsp;
   <select class="ActMenu" name="abaction" id="abActions" tabindex="3" onChange="go(this)">
       <xsl:attribute name="disabled"/>
       <xsl:attribute name="title">
         <xsl:text>_Select action</xsl:text>
       </xsl:attribute>
       <option><xsl:text>_Select action</xsl:text></option>
      </select>
  </xsl:when>
  <xsl:otherwise> 
  <input class="Btn1" type="button" name="Button" id="button" value=" Delete " onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" title="Delete Selected Address Book Entries">
   <xsl:attribute name="onClick">
     <xsl:text>javascript:deleteSelected()</xsl:text>
   </xsl:attribute>  
   <xsl:attribute name="onKeyPress">
     <xsl:text>javascript:deleteSelected()</xsl:text>
   </xsl:attribute>  
    <xsl:attribute name="value">
        <xsl:text>_Delete</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="title">
        <xsl:text>_Delete Selected Address Book Entries</xsl:text>
      </xsl:attribute>                 
  </input>    
  &nbsp;&nbsp;
  <select class="ActMenu" name="abaction" id="abActions" tabindex="3" onChange="execSelectAction(this)">
    <xsl:attribute name="title">
      <xsl:text>_Select action</xsl:text>
    </xsl:attribute>
  <option>
   <xsl:attribute name="selected"/>
   <xsl:text>_Select action</xsl:text>
  </option>
  <option>
  <xsl:attribute name="value">
    <xsl:text>javascript:sendMailFromSelected('</xsl:text>
    <xsl:value-of select="/xslui/usersession/@mailurl"/>
    <xsl:text>', '</xsl:text>
    <xsl:value-of select="$mailpref"/>
    <xsl:text>')</xsl:text>
  </xsl:attribute>
  <xsl:text>_Send Email</xsl:text>
  </option>
<!--
 <option value="javascript:sendiPlanetIMFromSelected();">
   <xsl:text>_Initiate an IM Conference</xsl:text>
 </option>
-->
 <xsl:if test="$calenabled='true'"> 
 <option>
  <xsl:attribute name="value">
   <xsl:text>javascript:viewCalendarFromSelected('</xsl:text>
   <xsl:value-of select="/xslui/@contexturi"/>
   <xsl:text>')</xsl:text>
  </xsl:attribute>
  <xsl:text>_View Calendar</xsl:text>
 </option>
 </xsl:if>
<!--
TODO
 <option value="javascript:open_popup_newevent()">
   <xsl:text>_Invite to Meeting</xsl:text>
 </option>
 <option value="forward.html">
   <xsl:text>_Forward</xsl:text>
 </option>
-->
 </select>              
 </xsl:otherwise>
 </xsl:choose>
 </td>                          
 <xsl:call-template name="search-template-paging">
   <xsl:with-param name="searchresult" select="$searchResult"/>          
   <xsl:with-param name="tdClass" select="$tdClass"/>
   <xsl:with-param name="colspan" select="number($colspan)-3"/>
   <xsl:with-param name="popup" select="false()"/>
 </xsl:call-template>      
 </tr>    
</xsl:otherwise>
</xsl:choose> 
</xsl:template> 

<!--
*******************************************************************************
* This templates prints the Contact Quick Add bar
*******************************************************************************
-->
<xsl:template name="quick-add">
<xsl:param name="fieldPrefix" select="'abperson_'" />
<script language="javascript">
  function quickAdd()
  {
    fDisplayName = document.iabform.<xsl:value-of select="$fieldPrefix"/>displayName;
    autoFillDisplayName();
    if (fDisplayName.value == '') {
      alert("<xsl:text>_At least one of the fields Lastname or Firstname must be filled.</xsl:text>");
      return;
    }
    
    email = document.iabform.<xsl:value-of select="$fieldPrefix"/>piEmail1.value;
    if( email != null &#38;&#38; email.length > 0 &#38;&#38; !checkEmail(email) ) {
      alert(i18n['Invalid Email Address']);
      return false;
    }
        
    document.iabform.prefix.value = '<xsl:value-of select="$fieldPrefix"/>';    
    document.iabform.<xsl:value-of select="$fieldPrefix"/>memberOfPIBook.value = document.iabform.actionbookid.value;
    addContact(true);
  }
  <xsl:call-template name="autoFillDisplayName"/>
</script>
<noscript></noscript>    
<table border="0" cellpadding="0" cellspacing="0" width="100%">
<tr>      
 <td><img src="{$spacer.gif}" width="10" height="1" alt=""/></td>
 <td width="98%"> 
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="TblMail">  
  <tr> 
    <td class="TblTtlTd" colspan="5" scope="col"><span class="TblTtlTxt"><xsl:text>_Add Contact</xsl:text></span></td>
  </tr>

  <tr>     
    <td class="TblTdLst" width="18%"><label for="first_name"><span class="Lbl2"><xsl:text>_First</xsl:text>:</span></label><br/>
    <input id="first_name" type="text" name="{$fieldPrefix}givenName" size="15" maxlength="45" onChange="javascipt:this.value=this.value.trim()" onBlur="javascipt:this.value=this.value.trim()"/> 
    </td>    
    <td class="TblTdLst" width="17%"><xsl:attribute name="nowrap"/><label for="last_name"><span class="Lbl2">
        <xsl:text>_Last</xsl:text>:</span></label><br/>
        <input id="last_name" type="text" name="{$fieldPrefix}sn" size="15" maxlength="45" onChange="javascipt:this.value=this.value.trim()" onBlur="javascipt:this.value=this.value.trim()"/>
    </td>    
    <td class="TblTdLst" width="18%"><xsl:attribute name="nowrap"/>
       <label for="email"><span class="Lbl2">
       <xsl:text>_Email (primary)</xsl:text>:
       </span></label><br/>
       <input id="email" type="text" name="{$fieldPrefix}piEmail1" size="15" maxlength="80" onChange="javascipt:this.value=this.value.trim()" onBlur="javascipt:this.value=this.value.trim()"/>
       <input type="hidden" name="{$fieldPrefix}piEmail1Type" value="work"/>
    </td>    
    <td class="TblTdLst" width="19%">
      <xsl:attribute name="nowrap"/>
      <label for="phone"><span class="Lbl2">
        <xsl:text>_Phone (primary)</xsl:text>:
      </span></label><br/>      
      <input id="phone" type="text" name="{$fieldPrefix}piPhone1" size="15" maxlength="30" onChange="javascipt:this.value=this.value.trim()" onBlur="javascipt:this.value=this.value.trim()"/>
      <input type="hidden" name="{$fieldPrefix}piPhone1Type" value="work" />
    </td>            
    <td class="TblTdQkAddLst" width="28%"> 
      <input class="Btn1" type="button" name="QAddButton" id="button" value="Add Contact" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="javascript:quickAdd()"  onKeyPress="javascript:quickAdd()" title="Add Contact"> 
      <xsl:attribute name="title"><xsl:text>_AddContact</xsl:text></xsl:attribute>
      <xsl:attribute name="value">
         <xsl:text>   </xsl:text><xsl:text>_Add Contact</xsl:text><xsl:text>   </xsl:text>
      </xsl:attribute>
      <xsl:attribute name="title">
        <xsl:text>_Add Contact</xsl:text>
      </xsl:attribute>
      </input> 
<script language="javascript">
document.iabform.<xsl:value-of select="$fieldPrefix"/>givenName.onkeypress = quickAddHandler;
document.iabform.<xsl:value-of select="$fieldPrefix"/>sn.onkeypress = quickAddHandler;
document.iabform.<xsl:value-of select="$fieldPrefix"/>piEmail1.onkeypress = quickAddHandler;
document.iabform.<xsl:value-of select="$fieldPrefix"/>piPhone1.onkeypress = quickAddHandler;
document.iabform.QAddButton.onkeypress = quickAddHandler;
</script>
<noscript></noscript>           
    </td>        
  </tr>  
  </table>
 </td>
 <td><img height="1" src="{$spacer.gif}"  width="10" alt=""/></td>
 </tr>
</table>
<input type="hidden" value="" name="{$fieldPrefix}displayName"/>
<input type="hidden" name="{$fieldPrefix}entrytype" value="abperson"/>
<input type="hidden" name="{$fieldPrefix}memberOfPIBook" value="{/xslui/iab/pagedsearch/searchresult/@bookid}"/>        
</xsl:template> 

<!--
*******************************************************************************
* Core of the template stylesheet search.xsl
*******************************************************************************
-->
<xsl:template match="/">
<html>
<head>
<title>
  <xsl:text>SunONE Address Book</xsl:text>
</title>

<script language="Javascript" src="../absjs/common.js"/><noscript>This is a javascript inclusion</noscript>  
<script language="Javascript" src="../absjs/contact.js"/><noscript></noscript>  
<script language="Javascript" src="../absjs/integration.js"/><noscript></noscript>  
<script language="Javascript" src="../absjs/define_images.js"/><noscript></noscript>  
<xsl:call-template name="search-template-javascript"/>
<script src="../absjs/browserVersion.js"></script><noscript></noscript>  
<script src="../absjs/scripts.js"></script><noscript></noscript>  
<script>        
    if (is_ie5up) // IE5
    {    
     document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
    }
    else if (is_gecko) // Netscape 6/7 or Mozilla
    {
      document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
    }
    else  // All others
    {
     document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
    }
</script><noscript></noscript>  
<script language="Javascript">        
  <xsl:call-template name="commonjavascript"/>  
  var gSharedObj = new Object();
  function GetSharedObject() {
    return(gSharedObj);
  }
  function AcceptData(inputArray) {
    switch (gSharedObj.action) {
      case 'addtogroup':
        addToGroup(inputArray[0]);
        break;
    }
  }

  function openAddToGroup() {
    gSharedObj.fieldsToReturn  = new Array('entryid');
    gSharedObj.action          = 'addtogroup';

    document.iabform.prefix.value = "group_";
    window.open("addtogroup-popup.xml?bookid=<xsl:value-of select="/xslui/iab/pagedsearch/searchresult/@bookid"/>&#38;select_type=radio", 
    "addtogroups", 
    "height=525,width=650,titlebar=yes,resizable=yes,scrollbars=yes");
  }

  function addToGroup(idArray) {
    if(idArray.length == 1) {
      idsToAdd  = (document.iabform.idstoadd == null)?null:
                                                     (document.iabform.idstoadd.length == null)?document.iabform.idstoadd:
                                                                                                document.iabform.idstoadd[0];
      sep = (document.iabform.valueseparator)?document.iabform.valueseparator.value:';';
      membersArray = new Array();
      document.iabform.entryid.value = idArray[0];
      buildArrayFromSelected(document.iabform.selectedentry, membersArray, 'entryid');
      buildArrayFromSelected(document.iabform.alreadyselectedentry, membersArray, 'entryid');
      if (membersArray.length &#62; 0) {
        idsToAdd.value = "";
        for (var i = 0; i &#60; membersArray.length; i++) {
          idsToAdd.value += sep+membersArray[i];
        }
        if (idsToAdd.value.indexOf(sep) == 0) idsToAdd.value = idsToAdd.value.substr(1);
        submitForm('addtogroup');
      }
    }
  }

  function goToImportExport()
  {
    document.iabform.stopsearch.value=1;
    openPopup('importexport-popup-main.xml',"importexport");    
  }
  
  function initPage() {
    onLoadAction();
    document.iabform.actionbookid.value =  '<xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/entry/@entryID"/>';
  }
</script><noscript></noscript>  
<xsl:call-template name="processAction">
  <xsl:with-param name="action">
    <xsl:value-of select="/xslui/@uiaction"/>
  </xsl:with-param>
  <xsl:with-param name="rootnode" select="/xslui/iab/alreadyselected"/>
</xsl:call-template>
</head>
<!-- Body starting here -->
<body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0" onload="initPage()">
<form method="post" name="iabform" action="search.xml" onsubmit="return false">
  <table cellspacing="0" cellpadding="0" width="100%" border="0" summary="This table contains the skip links">
   <tr>
    <td class="SkpMst"><a href="#tabs"><img src="{$spacer.gif}" height="1" width="1" border="0" alt="Skip Masthead">
                       <xsl:attribute name="title"><xsl:text>_skipMastHead</xsl:text></xsl:attribute></img></a></td>
    <td class="SkpMst"><a href="#toolbar"><img src="{$spacer.gif}" height="1" width="1" border="0" alt="Skip Global Tabs">
                       <xsl:attribute name="title"><xsl:text>_skipGlobalTabs</xsl:text></xsl:attribute></img></a></td>
    <td class="SkpMst"><a href="#listofcards"><img src="{$spacer.gif}" height="1" width="1" border="0" alt="Skip Toolbar">
                      <xsl:attribute name="title"><xsl:text>_skipToolBar</xsl:text></xsl:attribute></img></a></td>
   </tr>
  </table>
  <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
  <input type="hidden" name="uiaction" value=""/>
  <input type="hidden" name="entryid" value=""/>
  <input type="hidden" name="valueseparator" value="{$valueSeparator}"/>
  <input type="hidden" name="prefix" value=""/>     
  <input type="hidden" name="stopalreadyselected" value=""/>    
  
  <!-- Field for add to group Handling -->
  <input type="hidden" name="idstoadd" value=""/>

  <xsl:variable name="pagedSearch" select="/xslui/iab/pagedsearch"/>
  <xsl:variable name="searchResult" select="/xslui/iab/pagedsearch/searchresult"/>         
  <xsl:variable name="selectedBook" select="/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]"/>
  <xsl:variable name="xmlprofile" select="/xslui/profileinfo/xmlprofile"/>  
  <xsl:variable name="isRemoteAB" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@bookremoteurl)"/>
  <xsl:variable name="isCorporateDir" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@corporatedir)"/>
  <xsl:variable name="isIntegration" select="boolean(/xslui/usersession/@integration)"/>
  
  <input type="hidden" name="selectedbookid" value=""/>
  <input type="hidden" name="type" value="{$searchResult/@type}"/>
  
  <xsl:variable name="colspan">
   <xsl:choose>
    <xsl:when test="count($xmlprofile/layoutinfo/displayelt)=0">  
     <xsl:value-of select="4"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="count($xmlprofile/layoutinfo/displayelt) + 1"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
    
  <xsl:variable name="totalentries" select="number($searchResult/@totalentries)"/>   
  <xsl:variable name="searchmode" select="boolean(/xslui/iab/entrycontext/layoutinfo/searchmode[@value='true'])"/>  
  <xsl:variable name="aselectedentries" select="number(count(/xslui/iab/alreadyselected/*))"/>
  <xsl:variable name="taction">
    <xsl:choose>
      <xsl:when test="/xslui/@uiaction='sendemail' or /xslui/@uiaction='viewcalendar'">
        <xsl:value-of select="true()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable> 

  <!-- 0 - disable all actions, 1 - enable all actions, 2 - show only actions -->
  <xsl:variable name="showResult">
   <xsl:choose>
   <xsl:when test="not($isRemoteAB) and ($totalentries>0 or $aselectedentries>0)">
     <xsl:copy-of select="'1'"/>
   </xsl:when>
   <xsl:when test="$isRemoteAB and $searchmode and $totalentries">
     <xsl:copy-of select="'1'"/>
   </xsl:when>
   <xsl:when test="$isRemoteAB and $aselectedentries>0">
     <xsl:copy-of select="'2'"/>
   </xsl:when>
   <xsl:otherwise>
     <xsl:copy-of select="0"/>
   </xsl:otherwise>   
   </xsl:choose>
  </xsl:variable>
  
   <input type="hidden" name="wcfg_groupview" value="{/xslui/iab/entrycontext/layoutinfo/groupview/@value}"/>
  <xsl:if test="$showResult">
    <input type="hidden" name="wcfg_searchmode" value="{/xslui/iab/entrycontext/layoutinfo/searchmode/@value}"/>
  </xsl:if>
  
 
  <xsl:if test="$isRemoteAB">
    <!-- Fields for copy And Edit feature -->
    <input type="hidden" name="prefix" value="book_"/>
    <input type="hidden" name="book_entrytype" value="abook"/>
    <input type="hidden" name="book_entryID" value=""/>
  </xsl:if> 

  <xsl:call-template name="contextKeeper">
    <xsl:with-param name="pagedSearch" select="$pagedSearch"/>
  </xsl:call-template>

  <xsl:if test="$isIntegration=false">
    <xsl:call-template name="banner">
      <xsl:with-param name="displayWelcome" select="true()"/>
    </xsl:call-template>
  </xsl:if>

  <a href="tabs"></a>
  <xsl:call-template name="search-template-bookbar">
    <xsl:with-param name="bookList" select="/xslui/iab/booklist"/>
    <xsl:with-param name="selectedBook" select="$selectedBook"/>
    <xsl:with-param name="isIntegration" select="$isIntegration"/>
  </xsl:call-template>

  <xsl:call-template name="search-template-toolbar">
    <xsl:with-param name="isRemoteAB" select="$isRemoteAB"/>
    <xsl:with-param name="selectedBook" select="$selectedBook"/>
  </xsl:call-template>

  <xsl:variable name="error" select="/xslui/errormessages/error"/>
  <xsl:variable name="showerror">
    <xsl:choose>
    <xsl:when test="not($isRemoteAB)">
      <xsl:value-of select="true()"/>
    </xsl:when>
    <xsl:when test="$isRemoteAB and not($searchmode) and $error/@errnum=7">
      <xsl:value-of select="false()"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="true()"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:if test="$showerror='true'">
    <xsl:apply-templates select="$error" mode="plain">
    <xsl:with-param name="type">
      <xsl:choose>
      <xsl:when test="$error/@errnum=6 or $error/@errnum=10 or $error/@errnum=2 or $error/@errnum=3 or $error/@errnum=9">
        <xsl:value-of select="'information'"/>
      </xsl:when>
      <xsl:when test="$error/@errnum=7">
        <xsl:value-of select="'warning'"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'error'"/>
      </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
    </xsl:apply-templates>
  </xsl:if>

  <xsl:call-template name="search-template-searchbar">
    <xsl:with-param name="bookList" select="/xslui/iab/booklist"/>
    <xsl:with-param name="searchmode" select="$searchmode"/>    
    <xsl:with-param name="selectedBookID" select="$selectedBook/entry/@entryID"/> 
    <xsl:with-param name="selectedBook" select="$selectedBook"/>
    <xsl:with-param name="wildcardsearch" select="/selectedBook/entry/@entryID/@wildcardsearch"/>
  </xsl:call-template>

  <a name="listofcards"></a>
  <table border="0" cellpadding="0" cellspacing="0" width="100%" title="">
  <tr>        
    <td><img src="{$spacer.gif}" width="10" height="1" alt=""/></td>
    <td width="98%"> 
      <div class="TableDiv"> 
      <table class="TblMail" border="0" cellpadding="0" cellspacing="0" width="100%" title="">          
        <xsl:call-template name="search-template-header">          
          <xsl:with-param name="header" select="$selectedBook/entry/displayname"/>
          <xsl:with-param name="searchCriteria" select="$searchResult/@filter"/>
          <xsl:with-param name="searchmode" select="$searchmode"/>
          <xsl:with-param name="colspan" select="$colspan"/>
          <xsl:with-param name="popup" select="false()"/>        
        </xsl:call-template>
        
    <!--    <xsl:if test="$totalentries > 0 or $aselectedentries > 0">          -->
          <xsl:call-template name="search-actionbar">                
            <xsl:with-param name="searchResult" select="$searchResult"/>
            <xsl:with-param name="displaySeparators" select="1"/>
            <xsl:with-param name="colspan" select="$colspan"/>
            <xsl:with-param name="tdClass" select="'TblActTd'"/>            
            <xsl:with-param name="isRemoteAB" select="$isRemoteAB"/>
            <xsl:with-param name="showResult" select="$showResult"/>
          </xsl:call-template>          
   <!--     </xsl:if> -->
        
        <xsl:choose>
        <xsl:when test="$searchResult/@error">
          <xsl:value-of select="$searchResult/@error"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="search-template-searchresult">
            <xsl:with-param name="pagedSearch" select="$pagedSearch"/>
            <xsl:with-param name="searchmode" select="$searchmode"/> 
            <xsl:with-param name="showResult" select="$showResult"/>  
            <xsl:with-param name="totalentries" select="$totalentries"/>                                
            <xsl:with-param name="selectedbook" select="$selectedBook"/>
            <xsl:with-param name="xmlprofile" select="$xmlprofile"/>
          </xsl:call-template>
        </xsl:otherwise>
        </xsl:choose>

        <xsl:choose>
        <xsl:when test="$isRemoteAB">              
          <xsl:choose>          
            <xsl:when test="$searchmode and $totalentries > 0">
             <xsl:if test="$taction='false'">
               <xsl:call-template name="search-template-alreadyselected">
                 <xsl:with-param name="alreadySelected" select="/xslui/iab/alreadyselected"/>
                 <xsl:with-param name="colspan" select="$colspan"/>
               </xsl:call-template>
             </xsl:if>
             <tr>           
              <xsl:call-template name="search-actionbar">            
                <xsl:with-param name="searchResult" select="$searchResult"/>
                <xsl:with-param name="colspan" select="$colspan"/>
                <xsl:with-param name="tdClass" select="'TblActTdLst'"/>
                <xsl:with-param name="showResult" select="$showResult"/>
                <xsl:with-param name="isRemoteAB" select="$isRemoteAB"/>
              </xsl:call-template>
             </tr>             
            </xsl:when>
            <xsl:when test="$totalentries=0">
              <tr>
              <td colspan="4">
                <xsl:attribute name="class"><xsl:value-of select="'TblTdCl1Lst'"/></xsl:attribute> 
                <xsl:text>_No cards found. Verify or review your search criteria.</xsl:text>
              </td>
              </tr>              
              <xsl:call-template name="search-template-alreadyselected">
              <xsl:with-param name="alreadySelected" select="/xslui/iab/alreadyselected"/>
              <xsl:with-param name="colspan" select="$colspan"/>
              </xsl:call-template>
              <xsl:if test="$aselectedentries > 0">
                <tr>
                <xsl:call-template name="search-actionbar">
                <xsl:with-param name="searchResult" select="$searchResult"/>
                <xsl:with-param name="colspan" select="$colspan"/>
                <xsl:with-param name="tdClass" select="'TblActTdLst'"/>
                <xsl:with-param name="showResult" select="$showResult"/>
                <xsl:with-param name="isRemoteAB" select="$isRemoteAB"/>
                </xsl:call-template>
                </tr>
              </xsl:if>
            </xsl:when>            
            <xsl:otherwise>              
              <tr>
              <td colspan="4">
              <xsl:attribute name="class"><xsl:value-of select="'TblTdCl1Lst'"/></xsl:attribute> 
                <xsl:choose>               
                <xsl:when test="$isCorporateDir">                
                  <xsl:text>_Search corporate directory for contacts</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>_Search</xsl:text>&nbsp;<xsl:value-of select="$selectedBook/entry/displayname"/>&nbsp;<xsl:text>_for contacts</xsl:text>
                </xsl:otherwise>
                </xsl:choose>
              </td>
              </tr>              
              <xsl:if test="$taction='false'">
                <xsl:call-template name="search-template-alreadyselected">
                  <xsl:with-param name="alreadySelected" select="/xslui/iab/alreadyselected"/>
                  <xsl:with-param name="colspan" select="$colspan"/>
                </xsl:call-template>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>                          
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
          <xsl:when test="$searchmode and $totalentries = 0">
             <tr>
             <td colspan="4">
              <xsl:attribute name="class"><xsl:value-of select="'TblTdCl1Lst'"/></xsl:attribute>
              <xsl:text>_No cards found. Verify or review your search criteria.</xsl:text>
             </td>
             </tr>
              <xsl:call-template name="search-template-alreadyselected">
              <xsl:with-param name="alreadySelected" select="/xslui/iab/alreadyselected"/>
              <xsl:with-param name="colspan" select="$colspan"/>
              </xsl:call-template>
             <xsl:if test="$aselectedentries > 0">
                <tr>
                <xsl:call-template name="search-actionbar">
                <xsl:with-param name="searchResult" select="$searchResult"/>
                <xsl:with-param name="colspan" select="$colspan"/>
                <xsl:with-param name="tdClass" select="'TblActTdLst'"/>
                <xsl:with-param name="showResult" select="$showResult"/>
                <xsl:with-param name="isRemoteAB" select="$isRemoteAB"/>
                </xsl:call-template>
                </tr>
             </xsl:if>
          </xsl:when>
           <xsl:when test="$totalentries=0">             
             <tr>
             <td colspan="4">
              <xsl:attribute name="class"><xsl:value-of select="'TblTdCl1Lst'"/></xsl:attribute> 
              <xsl:text>_There are no cards in Personal Address Book to view.</xsl:text>
             </td>
             </tr>            
             <xsl:call-template name="search-template-alreadyselected">
             <xsl:with-param name="alreadySelected" select="/xslui/iab/alreadyselected"/>
             <xsl:with-param name="colspan" select="$colspan"/>
             </xsl:call-template>
             <xsl:if test="$aselectedentries > 0">
                <tr>
                <xsl:call-template name="search-actionbar">
                <xsl:with-param name="searchResult" select="$searchResult"/>
                <xsl:with-param name="colspan" select="$colspan"/>
                <xsl:with-param name="tdClass" select="'TblActTdLst'"/>
                <xsl:with-param name="showResult" select="$showResult"/>
                <xsl:with-param name="isRemoteAB" select="$isRemoteAB"/>
                </xsl:call-template>
                </tr>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>            
           <xsl:if test="$taction='false'">
             <xsl:call-template name="search-template-alreadyselected">
              <xsl:with-param name="alreadySelected" select="/xslui/iab/alreadyselected"/>
              <xsl:with-param name="colspan" select="$colspan"/>
             </xsl:call-template>
           </xsl:if>
           <xsl:call-template name="search-actionbar">            
              <xsl:with-param name="searchResult" select="$searchResult"/>
              <xsl:with-param name="colspan" select="$colspan"/>
              <xsl:with-param name="tdClass" select="'TblActTdLst'"/>            
              <xsl:with-param name="showResult" select="$showResult"/>
           </xsl:call-template>
          </xsl:otherwise>
          </xsl:choose>         
        </xsl:otherwise>
        </xsl:choose>     
      </table>
     </div>
    </td>
    <td><img height="1" src="{$spacer.gif}" width="10" alt=""/></td>
  </tr>
  </table>
       
  <table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr>
   <td><img src="{$spacer.gif}" height="10" alt=""/></td>                        
  </tr>
  </table>
  <xsl:if test="not($isRemoteAB)">
    <xsl:call-template name="quick-add">
      <xsl:with-param name="fieldPrefix" select="'abperson_'"/>
    </xsl:call-template>
  </xsl:if> 
  <table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr>
    <td><img src="{$spacer.gif}" height="10" alt=""/></td>                        
  </tr>
  </table>
</form>
</body>
</html>
</xsl:template>


<!--
*******************************************************************************
* This template displays the check mark for the already selected items in the list
*******************************************************************************
-->
<xsl:template name="displaySelect">
  <xsl:variable name="taction">
    <xsl:choose>
      <xsl:when test="/xslui/@uiaction='sendemail' or /xslui/@uiaction='viewcalendar'">
        <xsl:value-of select="true()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="false()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <td align="center" class="TblTdCl1">
    <xsl:choose>
      <xsl:when test="$taction = 'false' and entry/@entryID = /xslui/iab/alreadyselected/*[entry/@selectedfromui = 1]/entry/@entryID">
        <img src="{$checkmark_skinny.gif}" width="16" height="16">
          <xsl:attribute name="alt">
            <xsl:text>_Already Selected</xsl:text>
          </xsl:attribute>
        </img>
      </xsl:when>
      <xsl:otherwise>
        <input type="checkbox" name="selectedentry">
          <xsl:attribute name="value">
            <xsl:value-of select="entry/@entryID"/>
          </xsl:attribute>
        </input>
      </xsl:otherwise>
    </xsl:choose>
  </td>
</xsl:template>

<!--
*******************************************************************************
* This prints the error messages on the search page
* @param err The error element from which to extract the error code
*******************************************************************************
-->
<xsl:template name="error-message">
  <xsl:param name="err" select="." />

  <xsl:variable name="pbook" select="/xslui/iab/booklist/book[bookoc='piLocalBook']"/>

  <xsl:choose>    
    <xsl:when test="$err/@errnum = '2' or $err/@errnum = '3'">
      <script> printLocalizedLabel("<xsl:text>_Card Added Success Message</xsl:text>", new Array('<xsl:value-of select="$err/@displayname"/>','<xsl:value-of select="/xslui/iab/booklist/book/entry[@entryID = $err/@bookid]/displayname" />'));</script>  
      <noscript></noscript>  
    </xsl:when>
    <xsl:when test="$err/@errnum = '6'">
      <xsl:choose>
      <xsl:when test="$err/@failed != '0'">
        <xsl:text>_Some entries were deleted. Entries that did not belong to Personal Address Book were not deleted.</xsl:text>
      </xsl:when> 
      <xsl:otherwise>
        <xsl:text>_Selected entries have successfully been deleted.</xsl:text>
      </xsl:otherwise> 
      </xsl:choose>
    </xsl:when>
    <xsl:when test="$err/@errnum = '7'">            
      <script> printLocalizedLabel("<xsl:text>_Min Char Warning</xsl:text>", new Array('<xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID = $err/@bookid]/@wildcardsearch"/>'));</script>    
      <noscript></noscript>  
    </xsl:when>
    <xsl:when test="$err/@errnum = '9'">
      <script> printLocalizedLabel("<xsl:text>_Cards From Remote Book Added Success Message</xsl:text>", new Array('<xsl:value-of select="$pbook/entry/displayname"/>'));</script>   
      <noscript></noscript>  
    </xsl:when>    
    <xsl:when test="$err/@errnum = '13'">
       <b><xsl:text>_Add Book or Entry Failed</xsl:text></b>
       <b><xsl:text>&nbsp;</xsl:text></b>
       <b><xsl:text>_Quota exceeded</xsl:text></b>      
    </xsl:when>   
    <xsl:when test="$err/@errnum = '67'">
       <b><xsl:text>_Quota warning</xsl:text></b>
       <b><xsl:text>&nbsp;</xsl:text></b>
       <b><xsl:value-of select="$err/@displayname"/></b>
        <xsl:text>&nbsp;</xsl:text>
      </xsl:when>
    <xsl:when test="$err/@errnum = '257'">
      <xsl:text>_A error occured while trying to delete</xsl:text>.&nbsp;
    </xsl:when>
    <xsl:when test="$err/@errnum = '261' or $err/@errnum = '287'">        
        <script>printLocalizedLabel("<xsl:text>_Contact Addition Failure Message</xsl:text>", new Array('<xsl:value-of select="$err/@displayname"/>'));</script> 
        <noscript></noscript>  
    </xsl:when>      
    <xsl:when test="$err/@errnum = '273'">
     <script>printLocalizedLabel("<xsl:text>_Cards From Remote Book Added Failure Message</xsl:text>", new Array('<xsl:value-of select="$pbook/entry/displayname"/>'));</script>   
     <noscript></noscript>  
    </xsl:when>
    <xsl:when test="$err/@errnum = '286'">
      <xsl:text>_Timeout exceeded</xsl:text>
      <xsl:text>&nbsp;</xsl:text>
    </xsl:when>
    <xsl:when test="$err/@errnum = '512'">
      <xsl:text>_Search Limit Exceeded</xsl:text>
      <xsl:text>&nbsp;</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>_Unknown error (</xsl:text>
      <xsl:value-of select="$err/@errnum" /> 
      <xsl:text>)</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template> 
</xsl:stylesheet>

