<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="banner.xsl"/>
<xsl:include href="commonimages.xsl"/>
<xsl:include href="common-editgroup.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="context.xsl"/>
<xsl:include href="css-select.xsl"/>
<xsl:include href="errors.xsl"/>

<!--
*******************************************************************************
* Core of the template stylesheet addcontact.xsl
*******************************************************************************
-->
<xsl:template match="/">
  <html>
    <head>
      <title>
        <xsl:text>_iPlanet Address Book</xsl:text> - <xsl:text>_Edit Group</xsl:text>
      </title>

      <script language="javascript" src="../absjs/common.js"/>
      <script language="javascript">
        <xsl:call-template name="commonjavascript"/>
        <xsl:call-template name="bannerScripts"/>
        function save() {
          if((document.iabform["<xsl:value-of select="$fieldPrefix"/>displayName"].value).trim()=="")
          {
           alert("<xsl:text>_Display name cannot be blank or only whitespaces</xsl:text>");
           return;
          }
          document.iabform.<xsl:value-of select="$fieldPrefix"/>memberOfPIBook.value = '<xsl:value-of select="/xslui/iab/bookentry/group/memberofbook"/>'
          submitForm('editgroup');
        }

      function help() {
        var helpurl = '<xsl:value-of select="/xslui/@contexturi"/>/help/<xsl:text>_languagepath</xsl:text>/addressbk/edtgroup.html';
        openhelp(helpurl);
      } 

      var memberDeleted = false;
      function initPage() {
          var errornum = '<xsl:value-of select="/xslui/errormessages/error/@errnum"/>';

          if( errornum != null &#38;&#38;  errornum != '' &#38;&#38;  errornum == '11' ) {
            var type = parent.opener.document.iabform.type;
            if( type != null &#38;&#38; type.value != null &#38;&#38; type.value == 'group' )
              reloadParent(false, 'type=group'	);
            else 
              reloadParent(false);

            parent.close();
          } else {
            document.iabform.<xsl:value-of select="$fieldPrefix"/>displayName.focus();
            var queryString = '<xsl:value-of select="/xslui/@querystring"/>';
            if( queryString != null &#38;&#38; queryString.indexOf("memberdeleted") > -1 )
              memberDeleted = true;
          }
       }
     
       function cancel() {         
         if (selectWnd &amp;&amp; !selectWnd.closed) {
            var msg = '<xsl:text>_Browser pop-up(s) opened from this window are still open. Do you want to close them as well?</xsl:text>';         
            if( window.confirm(msg) ) {
              if( memberDeleted ) 
                reloadParent(false);
         
              selectWnd.close();         
              parent.close();
            }
         }
         else 
          parent.close(); 
       }
       var typesByIds = new Object();
       <xsl:for-each select="/xslui/iab/groupmembers/*">
          typesByIds['<xsl:value-of select="entry/@entryID"/>']='<xsl:value-of select="name()"/>';
       </xsl:for-each>

      </script>
      <script src="../absjs/browserVersion.js"></script>
      <script src="../absjs/scripts.js"></script>
      <script>
      if (is_ie5up) // IE5
      {
         document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
      }
      else if (is_gecko) // Netscape 6/7 or Mozilla
      {
          document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
      }
      else  // All others
      {
         document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
     }
    </script>
    </head>
    <body leftmargin="0" topmargin="0"  marginwidth="0" marginheight="0">
      <xsl:attribute name="onload">
        javascript:initPage();
      </xsl:attribute> 
      
      <form method="post" name="iabform" action="viewgroup.xml">
        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="valueseparator" value="{$valueSeparator}"/>
        <input type="hidden" name="entryid" value="{/xslui/iab/bookentry/group/entry/@entryID}"/>
        <input type="hidden" name="prefix" value="{$fieldPrefix}"/>
        <input type="hidden" name="{$fieldPrefix}entryID" value="{/xslui/iab/bookentry/group/entry/@entryID}"/>
        <input type="hidden" name="{$fieldPrefix}entrytype" value="group"/>
        <input type="hidden" name="{$fieldPrefix}memberOfPIBook" value="{/xslui/iab/pagedsearch/searchresult/@bookid}"/>        

        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>

        <table width="100%" border="0" cellspacing="0" cellpadding="0">
         <xsl:attribute name="summary">
            <xsl:text>_This table contains the page title</xsl:text>
          </xsl:attribute>
           <tbody>
              <tr>
                 <td class="PopupTitle" width="100%">
                     <span class="PopupTitleText">
                         <xsl:value-of select="/xslui/iab/bookentry/group/entry/displayname" /> 
                     </span>
                  </td>
               </tr>
           </tbody>
        </table>

        <xsl:variable name="error" select="/xslui/errormessages/error"/>
        <xsl:if test="$error/@errnum != '11'">
          <xsl:apply-templates select="$error" mode="plain"/> 
        </xsl:if>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
         <xsl:attribute name="summary">
            <xsl:text>_This table contains group properties</xsl:text>
          </xsl:attribute>
           <xsl:choose>
             <xsl:when test="/xslui/iab/entrycontext/group">
                <xsl:call-template name="groupDetails">
                   <xsl:with-param name="group" select="/xslui/iab/bookentry/group"/>
                 </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="groupDetails"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
              <xsl:when test="/xslui/iab/entrycontext/groupmembers">
                <xsl:call-template name="groupMembers">
                   <xsl:with-param name="members" select="/xslui/iab/entrycontext/groupmembers"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="groupMembers"/>
              </xsl:otherwise>
            </xsl:choose>
        </table>
        <xsl:for-each select="/xslui/iab/alreadyselected/*">
          <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
        </xsl:for-each>
        <xsl:apply-templates select="/xslui/iab/alreadyselected" mode="hidden"/>
      </form>
    </body>
  </html>
</xsl:template>
</xsl:stylesheet>
