/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLIncludeResolver;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLProcessor;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.OutputStream;
import org.w3c.dom.Document;

public class XSLProcessorPool {
    private Document _xslDoc = null;
    private XSLProcessor _xslProcessor = null;
    private XSLIncludeResolver _xslCache = null;
    private XSLXMLLogHandler _errorHandler = null;
    private String _id = null;

    public synchronized void setXSLDoc(Document document) {
        this._xslDoc = document;
        this.clear();
    }

    public Document getXSLDoc() {
        return this._xslDoc;
    }

    public void setCacheHandler(XSLIncludeResolver xSLIncludeResolver) {
        this._xslCache = xSLIncludeResolver;
        this.clear();
    }

    public void setErrorHandler(XSLXMLLogHandler xSLXMLLogHandler) {
        this._errorHandler = xSLXMLLogHandler;
        this.clear();
    }

    public void setId(String string) {
        this._id = string;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Document document, OutputStream outputStream, boolean bl) throws XSLProcessingException {
        XSLProcessor xSLProcessor;
        Document document2 = this._xslDoc;
        synchronized (document2) {
            if (this._xslProcessor == null) {
                this._xslProcessor = new XSLProcessor(this._xslDoc, this._xslCache, this._errorHandler, this._id, bl);
            }
            xSLProcessor = this._xslProcessor;
        }
        xSLProcessor.process(document, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this._xslDoc != null) {
            Document document = this._xslDoc;
            synchronized (document) {
                this._xslProcessor = null;
            }
        }
    }

    public static void main(String[] stringArray) {
        Document document = null;
        Document document2 = null;
        if (stringArray.length != 2) {
            System.err.println("Usage: XSLProcessorPool <XML file> <XSLT file>");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        XMLDOMBuilder xMLDOMBuilder = null;
        try {
            xMLDOMBuilder = new XMLDOMBuilder();
            document = xMLDOMBuilder.parse(string);
        }
        catch (XMLProcessingException xMLProcessingException) {
            System.err.println("Couldn't parse " + string + " : " + xMLProcessingException.getMessage());
            System.exit(1);
        }
        try {
            document2 = xMLDOMBuilder.parse(string2);
        }
        catch (XMLProcessingException xMLProcessingException) {
            System.err.println("Couldn't parse " + string2 + " : " + xMLProcessingException.getMessage());
            System.exit(1);
        }
        XSLProcessorPool xSLProcessorPool = null;
        try {
            xSLProcessorPool = new XSLProcessorPool();
            xSLProcessorPool.setXSLDoc(document2);
            xSLProcessorPool.process(document, System.out, false);
        }
        catch (XSLProcessingException xSLProcessingException) {
            System.err.println("Couldn't process " + string2 + " : " + xSLProcessingException.getMessage());
            System.exit(1);
        }
    }
}

