/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLIncludeResolver;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XSLProcessor {
    private Templates _templates = null;
    private static final String TRANSLETS_JAR = "iabs-translets.jar";
    private static final String TRANSLETS_PACKAGE = "com.sun.iabs.translets";
    private static final String TRANSLETS_LIBPATH_PROPERTY = "com.sun.iabs.translets.libPath";

    public XSLProcessor(Document document, XSLIncludeResolver xSLIncludeResolver, XSLXMLLogHandler xSLXMLLogHandler, String string, boolean bl) throws XSLProcessingException {
        try {
            this.init(document, xSLIncludeResolver, xSLXMLLogHandler, string, bl);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XSLProcessingException("XSLProcessor: " + transformerConfigurationException.getMessage());
        }
    }

    public XSLProcessor(Document document) throws XSLProcessingException {
        try {
            this.init(document, null, null, null, false);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XSLProcessingException("XSLProcessor: " + transformerConfigurationException.getMessage());
        }
    }

    public void process(Document document, OutputStream outputStream) throws XSLProcessingException {
        Transformer transformer = null;
        if (document == null) {
            throw new XSLProcessingException("XSLProcessor: xmlDoc null");
        }
        if (outputStream == null) {
            throw new XSLProcessingException("XSLProcessor: outputStream null");
        }
        try {
            transformer = this._templates.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XSLProcessingException("XSLProcessor: transformer could not be created : " + transformerConfigurationException.getMessage());
        }
        if (transformer == null) {
            throw new XSLProcessingException("XSLProcessor: _transformer null");
        }
        try {
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            throw new XSLProcessingException("XSLProcessor: transform failed (" + transformerException.getMessage() + ")");
        }
    }

    public static void main(String[] stringArray) {
        Document document = null;
        Document document2 = null;
        if (stringArray.length != 2) {
            System.err.println("Usage: XSLProcessor <XML file> <XSLT file>");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        XMLDOMBuilder xMLDOMBuilder = null;
        try {
            xMLDOMBuilder = new XMLDOMBuilder();
            document = xMLDOMBuilder.parse(string);
        }
        catch (XMLProcessingException xMLProcessingException) {
            System.err.println("Couldn't parse " + string + ":" + xMLProcessingException.getMessage());
            System.exit(1);
        }
        try {
            document2 = xMLDOMBuilder.parse(string2);
        }
        catch (XMLProcessingException xMLProcessingException) {
            System.err.println("Couldn't parse " + string2 + ":" + xMLProcessingException.getMessage());
            System.exit(1);
        }
        XSLProcessor xSLProcessor = null;
        try {
            xSLProcessor = new XSLProcessor(document2);
            xSLProcessor.process(document, System.out);
        }
        catch (XSLProcessingException xSLProcessingException) {
            System.err.println("Couldn't process " + string2 + " : " + xSLProcessingException.getMessage());
            System.exit(1);
        }
    }

    private void init(Document document, XSLIncludeResolver xSLIncludeResolver, XSLXMLLogHandler xSLXMLLogHandler, String string, boolean bl) throws TransformerConfigurationException {
        Object object;
        String string2 = null;
        if (bl) {
            object = "javax.xml.transform.TransformerFactory";
            String string3 = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";
            Properties properties = System.getProperties();
            properties.put(object, string3);
            System.setProperties(properties);
            string2 = properties.getProperty(TRANSLETS_LIBPATH_PROPERTY);
            if (string2 == null) {
                throw new TransformerConfigurationException("Unable to determine the destination dir for XSLTC Translets.");
            }
        }
        object = TransformerFactory.newInstance();
        if (bl) {
            ((TransformerFactory)object).setAttribute("translet-name", string);
            ((TransformerFactory)object).setAttribute("package-name", TRANSLETS_PACKAGE);
        }
        if (xSLXMLLogHandler != null) {
            ((TransformerFactory)object).setErrorListener(new XSLErrorHandler(xSLXMLLogHandler));
        }
        if (xSLIncludeResolver != null) {
            ((TransformerFactory)object).setURIResolver(new XSLURIResolver(xSLIncludeResolver));
        }
        try {
            this._templates = ((TransformerFactory)object).newTemplates(new DOMSource(document));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new TransformerConfigurationException("XSLProcessor: " + transformerConfigurationException.getMessage());
        }
    }

    private class XSLErrorHandler
    implements ErrorListener {
        private XSLXMLLogHandler _logHandler = null;

        XSLErrorHandler(XSLXMLLogHandler xSLXMLLogHandler) {
            this._logHandler = xSLXMLLogHandler;
        }

        private String getParseExceptionInfo(TransformerException transformerException) {
            int n;
            String string = transformerException.getMessageAndLocation();
            SourceLocator sourceLocator = transformerException.getLocator();
            if (sourceLocator != null && (n = sourceLocator.getLineNumber()) != 0) {
                string = string + "(line = " + n + ")";
            }
            return string;
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            this._logHandler.error("Warning: " + this.getParseExceptionInfo(transformerException));
        }

        public void error(TransformerException transformerException) throws TransformerException {
            String string = "Error: " + this.getParseExceptionInfo(transformerException);
            throw new TransformerException(string);
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(transformerException);
            throw new TransformerException(string);
        }
    }

    private class XSLURIResolver
    implements URIResolver {
        private XSLIncludeResolver _xslCache = null;

        XSLURIResolver(XSLIncludeResolver xSLIncludeResolver) {
            this._xslCache = xSLIncludeResolver;
        }

        public Source resolve(String string, String string2) throws TransformerException {
            if (this._xslCache == null) {
                throw new TransformerException("XSLURIResolver: called without a cache " + string);
            }
            Document document = null;
            try {
                document = this._xslCache.getXSLInclude(string);
            }
            catch (XSLProcessingException xSLProcessingException) {
                throw new TransformerException("XSLURIResolver: Couldn't get " + string + " : " + xSLProcessingException.getMessage());
            }
            return new DOMSource(document);
        }
    }
}

