/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathTools {
    private static ArrayList _charToSearch = new ArrayList();

    public static Node getFirstNodeByXPath(Node node, String string) throws XSLProcessingException {
        ArrayList arrayList = XPathTools.getNodesByXPath(node, string);
        if (arrayList.size() > 0) {
            return (Node)arrayList.get(0);
        }
        return null;
    }

    public static String getValueByXPath(Node node, String string) throws XSLProcessingException {
        Node node2 = null;
        if (string.startsWith("'")) {
            if (string.endsWith("'")) {
                return string.substring(1, string.length() - 1);
            }
            throw new XSLProcessingException("Missing simple quote in expression");
        }
        try {
            ArrayList arrayList = XPathTools.getNodesByXPath(node, string);
            if (arrayList.size() > 0 && (node2 = (Node)arrayList.get(0)) != null) {
                if (node2.getNodeType() == 1) {
                    for (node2 = node2.getFirstChild(); node2 != null && node2.getNodeType() != 3; node2 = node2.getNextSibling()) {
                    }
                }
                if (node2 != null) {
                    return node2.getNodeValue();
                }
            }
            return null;
        }
        catch (Exception exception) {
            throw new XSLProcessingException("Error retrieving value of node : " + exception.getMessage());
        }
    }

    public static String[] getValuesByXPath(Node node, String string) throws XSLProcessingException {
        ArrayList arrayList = XPathTools.getNodesByXPath(node, string);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = XPathTools.getValueByXPath((Node)arrayList.get(i), ".");
        }
        return stringArray;
    }

    public static ArrayList getNodesByXPath(Node node, String string) throws XSLProcessingException {
        ArrayList arrayList = new ArrayList();
        XPathTools.getNodesByXPath(node, string, arrayList);
        return arrayList;
    }

    public static void getNodesByXPath(Node node, String string, ArrayList arrayList) throws XSLProcessingException {
        block18: {
            Node node2;
            block17: {
                node2 = null;
                Object var4_4 = null;
                ArrayList arrayList2 = XPathTools.getFirstCharAndIndexOf(string, _charToSearch);
                if ((Integer)arrayList2.get(0) == -1) break block17;
                switch (((String)arrayList2.get(1)).charAt(0)) {
                    case '/': {
                        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                            if (!XPathTools.stringMatch(node2.getNodeName(), string.substring(0, (Integer)arrayList2.get(0)), true)) continue;
                            XPathTools.getNodesByXPath(node2, string.substring((Integer)arrayList2.get(0) + 1), arrayList);
                        }
                        break;
                    }
                    case '[': {
                        int n = (Integer)arrayList2.get(0);
                        boolean bl = string.substring(0, string.indexOf("]") + 1).length() < string.length();
                        if (bl) {
                            ArrayList<Node> arrayList3 = new ArrayList<Node>();
                            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                                if (!XPathTools.stringMatch(node2.getNodeName(), string.substring(0, n), true) || !XPathTools.bracketFormulaMatch(node2, string.substring(n + 1, string.indexOf("]")))) continue;
                                arrayList3.add(node2);
                            }
                            for (int i = 0; i < arrayList3.size(); ++i) {
                                XPathTools.getNodesByXPath((Node)arrayList3.get(i), string.substring(string.indexOf("]") + 2), arrayList);
                            }
                        } else {
                            while (node2 != null) {
                                if (XPathTools.stringMatch(node2.getNodeName(), string.substring(0, n), true) && XPathTools.bracketFormulaMatch(node2, string.substring(n + 1, string.indexOf("]")))) {
                                    arrayList.add(node2);
                                }
                                node2 = node2.getNextSibling();
                            }
                            break block0;
                        }
                    }
                }
                break block18;
            }
            if (string.equals(".")) {
                arrayList.add(node);
            } else if (string.startsWith("@")) {
                if (node.getNodeType() == 1 && (node2 = ((Element)node).getAttributeNode(string.substring(1))) != null) {
                    arrayList.add(node2);
                }
            } else {
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!XPathTools.stringMatch(node2.getNodeName(), string, true)) continue;
                    arrayList.add(node2);
                }
            }
        }
    }

    private static ArrayList getFirstCharAndIndexOf(String string, ArrayList arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        arrayList2.add(0, new Integer(-1));
        arrayList2.add(1, new String("#"));
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = string.indexOf((String)arrayList.get(i));
            if (n < 0 || (Integer)arrayList2.get(0) <= n && (Integer)arrayList2.get(0) != -1) continue;
            arrayList2.set(0, new Integer(n));
            arrayList2.set(1, new String((String)arrayList.get(i)));
        }
        return arrayList2;
    }

    public static boolean bracketFormulaMatch(Node node, String string) throws XSLProcessingException {
        ArrayList<String> arrayList;
        int n = string.indexOf("=");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        ArrayList arrayList2 = XPathTools.getNodesByXPath(node, string2);
        if (string3.startsWith("'")) {
            if (!string3.endsWith("'")) {
                throw new XSLProcessingException("Missing simple quote in expression : " + string);
            }
            arrayList = new ArrayList<String>();
            arrayList.add(string3.substring(1, string3.length() - 1));
        } else {
            arrayList = XPathTools.getNodesByXPath(node, string3);
            bl = true;
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            for (int j = 0; j < arrayList.size(); ++j) {
                String string4;
                String string5 = XPathTools.getValueByXPath((Node)arrayList2.get(i), ".");
                String string6 = string4 = bl ? XPathTools.getValueByXPath((Node)arrayList.get(j), ".") : (String)arrayList.get(j);
                if (string5 == null || string4 == null || !XPathTools.stringMatch(string5, string4, true)) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    private static boolean stringMatch(String string, String string2, boolean bl) {
        String string3 = new String(string2);
        int n = 0;
        if (string2.compareTo("*") == 0) {
            return true;
        }
        if (string2.indexOf("*") != -1) {
            int n2;
            int n3 = string.length();
            int n4 = string2.length();
            if (string2.startsWith("*") && string2.endsWith("*")) {
                return bl ? string.toLowerCase().indexOf(string2.toLowerCase().substring(1, n4 - 1)) != -1 : string.indexOf(string2.substring(1, n4 - 1)) != -1;
            }
            if (string2.startsWith("*")) {
                n = n3 - n4 + 1 < 0 ? n3 : n3 - n4 + 1;
                return XPathTools.stringMatch(string.substring(n), string2.substring(1), bl);
            }
            if (string2.endsWith("*")) {
                n = n3 - n4 < 0 ? n3 : n4 - 1;
                return XPathTools.stringMatch(string.substring(0, n), string2.substring(0, string2.length() - 1), bl);
            }
            String string4 = string2.substring(0, string2.indexOf("*"));
            String string5 = string2.substring(string2.indexOf("*") + 1);
            int n5 = string4.length();
            if (n3 <= Math.min(n5, n2 = string5.length())) {
                return false;
            }
            String string6 = string.substring(0, n5);
            String string7 = string.substring(n3 - n2);
            int n6 = string6.length();
            int n7 = string7.length();
            boolean bl2 = XPathTools.stringMatch(string6, string4, bl);
            boolean bl3 = XPathTools.stringMatch(string7, string5, bl);
            return bl2 && bl3;
        }
        return bl ? string.compareToIgnoreCase(string2) == 0 : string.compareTo(string2) == 0;
    }

    private static boolean stringMatch(StringBuffer stringBuffer, StringBuffer stringBuffer2, boolean bl) {
        return XPathTools.stringMatch(stringBuffer.toString(), stringBuffer2.toString(), bl);
    }

    public static void main(String[] stringArray) {
        try {
            XMLDOMBuilder xMLDOMBuilder = new XMLDOMBuilder();
            Document document = xMLDOMBuilder.newDocument();
            if (stringArray.length <= 1) {
                System.out.println("Syntaxe : SearchTest <file.xml> XPath");
                return;
            }
            document = xMLDOMBuilder.parse(new String(stringArray[0]));
            System.out.println("XML file parsed");
            ArrayList arrayList = XPathTools.getNodesByXPath(document, stringArray[1]);
            if (arrayList != null) {
                System.out.println(arrayList.size() + " matching results");
                System.out.println("Node name : " + ((Node)arrayList.get(0)).getNodeName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        _charToSearch.add("/");
        _charToSearch.add("[");
    }
}

