/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.tools.Comparer;
import com.iplanet.xslui.tools.QuickSort;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLDOMContentHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XMLSAXParser;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTranslator {
    public static final String DICTIONARY_ELT = "dictionary";
    public static final String WORD_ELT = "word";
    public static final String KEY_ATTR = "key";
    public static final String TOTRANSLATE_ELT = "translate";
    public static final String TOTRANSLATE_PREFIX = "prefix";
    private Hashtable _dictionaryTable = new Hashtable();
    private Hashtable _translateTable = new Hashtable();
    private String _toTranslatePrefix = null;
    private XMLDOMBuilder _domBuilder = null;
    private XSLXMLLogHandler _errorHandler;

    public XMLTranslator(File file, XSLXMLLogHandler xSLXMLLogHandler) throws XMLProcessingException {
        this._errorHandler = xSLXMLLogHandler;
        this._domBuilder = new XMLDOMBuilder(xSLXMLLogHandler);
        DictionarySAXParser dictionarySAXParser = new DictionarySAXParser(this._dictionaryTable, this._translateTable);
        XMLSAXParser xMLSAXParser = new XMLSAXParser(dictionarySAXParser, xSLXMLLogHandler);
        xMLSAXParser.parse(file);
        this._toTranslatePrefix = dictionarySAXParser.getPrefix();
    }

    public Document translate(Document document) throws XMLProcessingException {
        Document document2 = null;
        TranslatorContentHandler translatorContentHandler = new TranslatorContentHandler(this._dictionaryTable, this._translateTable);
        document2 = this._domBuilder.newDocument(document, translatorContentHandler);
        return document2;
    }

    public synchronized void load(File file) throws XMLProcessingException {
        ExtractSAXParser extractSAXParser = new ExtractSAXParser(this._dictionaryTable, this._translateTable, this._toTranslatePrefix);
        XMLSAXParser xMLSAXParser = new XMLSAXParser(extractSAXParser, this._errorHandler);
        xMLSAXParser.parse(file);
    }

    public void dumpToFile(File file) throws XMLProcessingException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        class IgnoreCaseComparer
        implements Comparer {
            IgnoreCaseComparer() {
            }

            public int compare(Object object, Object object2, Object object3) {
                return object2.toString().compareToIgnoreCase(object3.toString());
            }
        }
        IgnoreCaseComparer ignoreCaseComparer = new IgnoreCaseComparer();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception exception) {
            throw new XMLProcessingException("dumpToFile: can't open file: " + file.toString() + "(" + exception.getMessage() + ")");
        }
        try {
            Object object;
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write("<?xml version=\"1.0\"?>");
            outputStreamWriter.write("<dictionary>\n");
            if (this._toTranslatePrefix != null) {
                outputStreamWriter.write("  <prefix>");
                outputStreamWriter.write(this._toTranslatePrefix);
                outputStreamWriter.write("</prefix>\n");
            }
            Enumeration enumeration = this._translateTable.keys();
            while (enumeration.hasMoreElements()) {
                outputStreamWriter.write("  <translate>");
                outputStreamWriter.write((String)enumeration.nextElement());
                outputStreamWriter.write("</translate>\n");
            }
            enumeration = this._dictionaryTable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                arrayList.add((String)object);
            }
            QuickSort.sort(arrayList, ignoreCaseComparer, null);
            object = arrayList.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                outputStreamWriter.write("  <word");
                outputStreamWriter.write(" key=\"" + string);
                outputStreamWriter.write("\">");
                outputStreamWriter.write((String)this._dictionaryTable.get(string));
                outputStreamWriter.write("</word>\n");
            }
            outputStreamWriter.write("</dictionary>\n");
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            throw new XMLProcessingException("Can't write in file : " + exception.getMessage());
        }
    }

    public int size() {
        return this._dictionaryTable.size();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            throw new Exception("No file provided, can do nothing !");
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            throw new Exception("XSL file not found !");
        }
        File file2 = new File(stringArray[1]);
        if (!file2.exists()) {
            throw new Exception("Dictionary file not found !");
        }
        try {
            XMLTranslator xMLTranslator = new XMLTranslator(file2, null);
            xMLTranslator.load(file);
            xMLTranslator.dumpToFile(file2);
        }
        catch (Exception exception) {
            throw new Exception("Couldn't populate dictionary : " + exception.getMessage());
        }
    }

    private class TranslatorContentHandler
    extends XMLDOMContentHandler {
        Hashtable _dictionaryTable = null;
        Hashtable _translateTable = null;

        public TranslatorContentHandler(Hashtable hashtable, Hashtable hashtable2) {
            this._dictionaryTable = hashtable;
            this._translateTable = hashtable2;
        }

        public void elementHandler(Element element, Document document) {
            if (this._translateTable.get(element.getTagName()) == null) {
                return;
            }
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Text text;
                String string;
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 3 || (string2 = (String)this._dictionaryTable.get(string = (text = (Text)node).getData())) == null) continue;
                text.setData(string2);
            }
        }
    }

    private class ExtractSAXParser
    extends DefaultHandler {
        Hashtable _dictionaryTable = null;
        Hashtable _translateTable = null;
        boolean _inText = false;
        StringBuffer _currentValue = null;
        boolean _ignorePrefix = true;
        String _toTranslatePrefix = null;

        public ExtractSAXParser(Hashtable hashtable, Hashtable hashtable2, String string) {
            this._dictionaryTable = hashtable;
            this._translateTable = hashtable2;
            this._toTranslatePrefix = string;
            this._ignorePrefix = string == null;
        }

        public void startDocument() throws SAXException {
            this._inText = false;
            this._currentValue = new StringBuffer();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this._translateTable.get(string3) != null) {
                this._currentValue.delete(0, this._currentValue.length());
                this._inText = true;
            } else {
                this._inText = false;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this._inText) {
                String string4 = this._currentValue.toString();
                if (this._dictionaryTable.get(string4) == null && string4.length() > 0 && (this._ignorePrefix || string4.indexOf(this._toTranslatePrefix) == 0)) {
                    int n = string4 != null ? this._toTranslatePrefix.length() : 0;
                    String string5 = n == 0 ? string4 : string4.substring(n);
                    this._dictionaryTable.put(string4, string5);
                }
                this._inText = false;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this._inText) {
                this._currentValue.append(cArray, n, n2);
            }
        }
    }

    private class DictionarySAXParser
    extends DefaultHandler {
        Hashtable _dictionaryTable = null;
        Hashtable _translateTable = null;
        String _currentKey = null;
        String _toTranslatePrefix = null;
        StringBuffer _currentValue = null;
        boolean _inText;
        boolean _ignorePrefix = true;

        public DictionarySAXParser(Hashtable hashtable, Hashtable hashtable2) {
            this._dictionaryTable = hashtable;
            this._translateTable = hashtable2;
        }

        public void startDocument() throws SAXException {
            this._currentKey = null;
            this._currentValue = new StringBuffer();
            this._inText = false;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(XMLTranslator.DICTIONARY_ELT)) {
                return;
            }
            if (string3.equals(XMLTranslator.TOTRANSLATE_PREFIX)) {
                this._currentValue.delete(0, this._currentValue.length());
                this._inText = true;
                return;
            }
            if (string3.equals(XMLTranslator.TOTRANSLATE_ELT)) {
                this._currentValue.delete(0, this._currentValue.length());
                this._inText = true;
                return;
            }
            if (string3.equals(XMLTranslator.WORD_ELT)) {
                if (attributes.getLength() != 1) {
                    throw new SAXException("Wrong number of attributes for word element:" + attributes.getLength());
                }
                if (!attributes.getQName(0).equals(XMLTranslator.KEY_ATTR)) {
                    throw new SAXException("Wrong attribute name for word element:" + attributes.getLocalName(0));
                }
                this._currentKey = attributes.getValue(0);
                this._currentValue.delete(0, this._currentValue.length());
                this._inText = true;
                return;
            }
            throw new SAXException("Unknown element: " + string3);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(XMLTranslator.TOTRANSLATE_PREFIX)) {
                this._ignorePrefix = false;
                this._toTranslatePrefix = new String(this._currentValue.toString());
            }
            if (string3.equals(XMLTranslator.TOTRANSLATE_ELT)) {
                this._translateTable.put(this._currentValue.toString(), "OK");
                this._inText = false;
            }
            if (string3.equals(XMLTranslator.WORD_ELT)) {
                if (this._currentKey == null) {
                    throw new SAXException("No current Key at end of element.");
                }
                String string4 = (String)this._dictionaryTable.get(this._currentKey);
                if (string4 == null) {
                    this._dictionaryTable.put(this._currentKey, this._currentValue.toString());
                    this._currentKey = null;
                    this._inText = false;
                } else {
                    throw new SAXException("Duplicated key: " + this._currentKey);
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!this._inText) {
                return;
            }
            this._currentValue.append(cArray, n, n2);
        }

        public String getPrefix() {
            return this._toTranslatePrefix;
        }
    }
}

