/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XMLErrorHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLSAXParser {
    private XMLReader _xmlReader = null;

    public XMLSAXParser(ContentHandler contentHandler, XSLXMLLogHandler xSLXMLLogHandler) throws XMLProcessingException {
        if (contentHandler == null) {
            throw new XMLProcessingException("XMLSAXParser: no content Handler");
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this._xmlReader = sAXParser.getXMLReader();
        }
        catch (Exception exception) {
            throw new XMLProcessingException("XMLSAXParser: can't get reader (" + exception.getMessage() + ")");
        }
        this._xmlReader.setContentHandler(contentHandler);
        if (xSLXMLLogHandler != null) {
            this._xmlReader.setErrorHandler(new XMLErrorHandler(xSLXMLLogHandler));
        }
    }

    public void parse(File file) throws XMLProcessingException {
        if (file == null) {
            throw new XMLProcessingException("File is null");
        }
        String string = null;
        try {
            string = file.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new XMLProcessingException("XMLSAXParser: bad file name (" + malformedURLException.getMessage() + ")");
        }
        try {
            this._xmlReader.parse(string);
        }
        catch (SAXException sAXException) {
            throw new XMLProcessingException("XMLSAXParser: parsing error:" + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new XMLProcessingException("XMLSAXParser: io error:" + iOException.getMessage());
        }
    }

    public void parse(String string) throws XMLProcessingException {
        File file = null;
        if (string == null) {
            throw new XMLProcessingException("path is null");
        }
        if (string.length() == 0) {
            throw new XMLProcessingException("path is empty");
        }
        file = new File(string);
        this.parse(file);
    }
}

