/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private XSLXMLLogHandler _logHandler;

    XMLErrorHandler(XSLXMLLogHandler xSLXMLLogHandler) {
        this._logHandler = xSLXMLLogHandler;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this._logHandler.error("Warning: " + this.getParseExceptionInfo(sAXParseException));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
        this._logHandler.error(string);
        throw new SAXException(string);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
        this._logHandler.error(string);
        throw new SAXException(string);
    }

    private String getParseExceptionInfo(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId();
        if (string == null) {
            string = "null";
        }
        String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
        return string2;
    }
}

