/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.tools.StringUtils;
import com.iplanet.xslui.xslutil.XMLDOMContentHandler;
import com.iplanet.xslui.xslutil.XMLErrorHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDOMBuilder {
    private static DocumentBuilderFactory _documentBuilderFactory = null;
    private DocumentBuilder _documentBuilder = null;
    private static final String basicIndent = " ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLDOMBuilder() throws XMLProcessingException {
        DocumentBuilderFactory documentBuilderFactory = _documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            try {
                this._documentBuilder = _documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XMLProcessingException("XMLDOMBuilder: Couldn't get a Factory: " + parserConfigurationException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLDOMBuilder(XSLXMLLogHandler xSLXMLLogHandler) throws XMLProcessingException {
        DocumentBuilderFactory documentBuilderFactory = _documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            try {
                this._documentBuilder = _documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new XMLProcessingException("XMLDOMBuilder: Couldn't get a Factory: " + parserConfigurationException.getMessage());
            }
        }
        if (xSLXMLLogHandler != null) {
            this._documentBuilder.setErrorHandler(new XMLErrorHandler(xSLXMLLogHandler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(File file, boolean bl) throws XMLProcessingException {
        Document document = null;
        if (file == null) {
            throw new XMLProcessingException("File is null");
        }
        DocumentBuilder documentBuilder = this._documentBuilder;
        synchronized (documentBuilder) {
            try {
                document = this._documentBuilder.parse(file);
            }
            catch (SAXException sAXException) {
                throw new XMLProcessingException("parsing failed: " + sAXException.getMessage());
            }
            catch (IOException iOException) {
                throw new XMLProcessingException("parsing failed: " + iOException.getMessage());
            }
        }
        if (bl) {
            document = (Document)XMLDOMBuilder.stripWhiteSpaceNodes(document);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(InputStream inputStream, boolean bl) throws XMLProcessingException {
        Document document = null;
        if (inputStream == null) {
            throw new XMLProcessingException("InputStream is null");
        }
        InputSource inputSource = new InputSource(inputStream);
        DocumentBuilder documentBuilder = this._documentBuilder;
        synchronized (documentBuilder) {
            try {
                document = this._documentBuilder.parse(inputSource);
            }
            catch (SAXException sAXException) {
                throw new XMLProcessingException("parsing failed: " + sAXException.getMessage());
            }
            catch (IOException iOException) {
                throw new XMLProcessingException("parsing failed: " + iOException.getMessage());
            }
        }
        if (bl) {
            document = (Document)XMLDOMBuilder.stripWhiteSpaceNodes(document);
        }
        return document;
    }

    public Document parse(File file) throws XMLProcessingException {
        return this.parse(file, true);
    }

    public Document parse(String string, boolean bl) throws XMLProcessingException {
        Document document = null;
        File file = null;
        if (string == null) {
            throw new XMLProcessingException("path is null");
        }
        if (string.length() == 0) {
            throw new XMLProcessingException("path is empty");
        }
        file = new File(string);
        document = this.parse(file);
        if (document == null) {
            throw new XMLProcessingException("Couldn't parse " + string);
        }
        if (bl) {
            document = (Document)XMLDOMBuilder.stripWhiteSpaceNodes(document);
        }
        return document;
    }

    public Document parse(String string) throws XMLProcessingException {
        return this.parse(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document newDocument() {
        Document document = null;
        DocumentBuilder documentBuilder = this._documentBuilder;
        synchronized (documentBuilder) {
            document = this._documentBuilder.newDocument();
        }
        return document;
    }

    public Document newDocument(Document document) throws XMLProcessingException {
        Document document2 = (Document)this.copyNode(document, null, null);
        return document2;
    }

    public Document newDocument(Document document, XMLDOMContentHandler xMLDOMContentHandler) throws XMLProcessingException {
        Document document2 = (Document)this.copyNode(document, null, xMLDOMContentHandler);
        return document2;
    }

    public Node copyNode(Node node, Document document) throws XMLProcessingException {
        return this.copyNode(node, document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node copyNode(Node node, Document document, XMLDOMContentHandler xMLDOMContentHandler) throws XMLProcessingException {
        Object object;
        Object object2;
        Object object3 = null;
        if (node == null) {
            throw new XMLProcessingException("copyNode: origNode is null");
        }
        short s = node.getNodeType();
        if (document == null && s != 9) {
            throw new XMLProcessingException("copyNode: newDoc is null");
        }
        String string = node.getNamespaceURI();
        String string2 = node.getNodeName();
        String string3 = node.getNodeValue();
        switch (s) {
            case 2: {
                object2 = null;
                object2 = string != null ? document.createAttributeNS(string, string2) : document.createAttribute(string2);
                object2.setValue(string3);
                object3 = object2;
                break;
            }
            case 9: {
                Object object4 = this._documentBuilder;
                synchronized (object4) {
                    document = this._documentBuilder.newDocument();
                }
                object3 = document;
                break;
            }
            case 10: {
                Object object4 = (DocumentType)node;
                object = null;
                Object object5 = this._documentBuilder;
                synchronized (object5) {
                    object = this._documentBuilder.getDOMImplementation();
                }
                object3 = object5 = object.createDocumentType(object4.getName(), object4.getPublicId(), object4.getSystemId());
                break;
            }
            case 1: {
                Node node2;
                if (xMLDOMContentHandler != null && xMLDOMContentHandler.SkipElementHandler(node)) {
                    return null;
                }
                Element element = null;
                element = string != null ? document.createElementNS(string, string2) : document.createElement(string2);
                if (xMLDOMContentHandler != null) {
                    xMLDOMContentHandler.preElementHandler(element, document);
                }
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    node2 = (Attr)this.copyNode(namedNodeMap.item(i), document, xMLDOMContentHandler);
                    if (node2 == null) continue;
                    element.setAttributeNode((Attr)node2);
                }
                object3 = element;
                break;
            }
            case 3: {
                object3 = document.createTextNode(string3);
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                object3 = document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 8: {
                Node node2 = (Comment)node;
                object3 = document.createComment(node2.getData());
                break;
            }
            default: {
                throw new XMLProcessingException("copyNode: can't copy Node of type: " + node.getNodeType());
            }
        }
        if (s != 3 && s != 2 && s != 10 && (object2 = node.getChildNodes()).getLength() != 0) {
            for (int i = 0; i < object2.getLength(); ++i) {
                if (object2.item(i) == null || (object = this.copyNode(object2.item(i), document, xMLDOMContentHandler)) == null || object.getNodeType() == 10) continue;
                object3.appendChild((Node)object);
            }
        }
        if (xMLDOMContentHandler != null) {
            switch (s) {
                case 2: {
                    xMLDOMContentHandler.attributeHandler((Attr)object3, document);
                    break;
                }
                case 1: {
                    xMLDOMContentHandler.elementHandler((Element)object3, document);
                    break;
                }
            }
        }
        return object3;
    }

    public void copyChildren(Node node, Node node2) throws XMLProcessingException {
        Document document = node2.getOwnerDocument();
        NodeList nodeList = null;
        nodeList = node.getChildNodes();
        if (nodeList.getLength() != 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3;
                if (nodeList.item(i) == null || (node3 = this.copyNode(nodeList.item(i), document)) == null) continue;
                node2.appendChild(node3);
            }
        }
    }

    public void copyAttributes(Element element, Element element2) throws XMLProcessingException {
        Document document = element2.getOwnerDocument();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)this.copyNode(namedNodeMap.item(i), document);
            if (attr == null) continue;
            element2.setAttributeNode(attr);
        }
    }

    public static void dumpNode(Node node, String string) throws XMLProcessingException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            XMLDOMBuilder.unparse(node, bufferedWriter, 0);
            bufferedWriter.flush();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLProcessingException("Can't open file : " + iOException.getMessage());
        }
    }

    public static void dumpNode(Node node, OutputStream outputStream) throws XMLProcessingException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            XMLDOMBuilder.unparse(node, bufferedWriter, 0);
            bufferedWriter.write("\n");
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new XMLProcessingException("Can't create out : " + iOException.getMessage());
        }
    }

    public static void dumpChildrenOfNode(Node node, OutputStream outputStream) throws XMLProcessingException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                XMLDOMBuilder.unparse(node2, bufferedWriter, 0);
                bufferedWriter.write("\n");
                bufferedWriter.flush();
            }
        }
        catch (IOException iOException) {
            throw new XMLProcessingException("Can't create out : " + iOException.getMessage());
        }
    }

    public static void dumpChildrenOfNode(Node node, String string) throws XMLProcessingException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            XMLDOMBuilder.dumpChildrenOfNode(node, fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLProcessingException("Can't open file : " + iOException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        Document document = null;
        if (stringArray.length != 1) {
            System.err.println("Usage: XMLDOMBuilder <XML file>");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            XMLDOMBuilder xMLDOMBuilder = new XMLDOMBuilder();
            document = xMLDOMBuilder.parse(string);
            System.err.println("Result: ");
            XMLDOMBuilder.dumpNode((Node)document, System.err);
        }
        catch (XMLProcessingException xMLProcessingException) {
            System.err.println("Couldn't parse " + string + " (" + xMLProcessingException.getMessage() + ")");
            System.exit(1);
        }
    }

    public void insertNodeFromString(Document document, Node node, String string) throws XMLProcessingException {
        try {
            Node node2;
            Document document2 = this.createDocFromString(string);
            if (document2 != null && (node2 = document2.getFirstChild()) != null) {
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    node.appendChild(document.importNode(node3, true));
                }
            }
        }
        catch (Exception exception) {
            throw new XMLProcessingException("Can not insert node from XML string : " + exception.getMessage());
        }
    }

    private Document createDocFromString(String string) throws XMLProcessingException {
        Document document = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>");
        stringBuffer.append("<dummyDocument>");
        stringBuffer.append(string);
        stringBuffer.append("</dummyDocument>");
        try {
            StringReader stringReader = new StringReader(stringBuffer.toString());
            stringReader.ready();
            InputSource inputSource = new InputSource(stringReader);
            document = this._documentBuilder.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new XMLProcessingException("Error while handling the stream : " + iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XMLProcessingException("Error while parsing the stream : " + sAXException.getMessage());
        }
        return document;
    }

    private void dump(Node node, StreamResult streamResult) throws XMLProcessingException {
        Transformer transformer = null;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XMLProcessingException("dump: " + transformerConfigurationException.getMessage());
        }
        try {
            transformer.transform(new DOMSource(node), streamResult);
        }
        catch (TransformerException transformerException) {
            throw new XMLProcessingException("dump: transform failed (" + transformerException.getMessage() + ")");
        }
    }

    private static void unparse(Node node, Writer writer, int n) throws XMLProcessingException {
        short s = node.getNodeType();
        try {
            switch (s) {
                case 2: {
                    String string = node.getNodeValue();
                    if (string == null) {
                        writer.write(basicIndent + node.getNodeName() + "=\"!!!null!!!\"");
                        break;
                    }
                    writer.write(basicIndent + node.getNodeName() + "=\"" + XMLDOMBuilder.escape(string, true) + "\"");
                    break;
                }
                case 4: {
                    throw new XMLProcessingException("Tag exception : CDATA");
                }
                case 8: {
                    break;
                }
                case 11: {
                    throw new XMLProcessingException("Tag exception : DOC_FRAG");
                }
                case 9: {
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    if (node.hasChildNodes()) {
                        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                            writer.write("\n");
                            XMLDOMBuilder.unparse(node2, writer, n);
                        }
                    }
                    break;
                }
                case 10: {
                    writer.write("<!DOCTYPE " + node.getNodeName() + ">\n");
                    break;
                }
                case 1: {
                    Object object;
                    Node node3;
                    writer.write("<" + node.getNodeName());
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        node3 = namedNodeMap.item(i);
                        object = node3.getNodeValue();
                        if (object == null) {
                            writer.write(basicIndent + node3.getNodeName() + "=\"!!!null!!!\"");
                            continue;
                        }
                        writer.write(basicIndent + node3.getNodeName() + "=\"" + XMLDOMBuilder.escape((String)object, true) + "\"");
                    }
                    if (node.hasChildNodes()) {
                        writer.write(">");
                        object = node.getFirstChild();
                        Node node4 = node.getLastChild();
                        for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                            if (node3.getNodeType() != 3) {
                                if (node3 == object) {
                                    writer.write("\n");
                                    XMLDOMBuilder.outputIndentation(writer, n + 1);
                                } else if (node3.getPreviousSibling() != null && node3.getPreviousSibling().getNodeType() != 3) {
                                    writer.write("\n");
                                    XMLDOMBuilder.outputIndentation(writer, n + 1);
                                }
                            }
                            XMLDOMBuilder.unparse(node3, writer, n + 1);
                        }
                        if (object.getNodeType() != 3 && node4.getNodeType() != 3) {
                            writer.write("\n");
                            XMLDOMBuilder.outputIndentation(writer, n);
                        }
                        writer.write("</" + node.getNodeName() + ">");
                        break;
                    }
                    writer.write(" />");
                    break;
                }
                case 6: {
                    throw new XMLProcessingException("Tag exception : ENTITY");
                }
                case 5: {
                    throw new XMLProcessingException("Tag exception : ENTTIY_REF");
                }
                case 12: {
                    throw new XMLProcessingException("Tag exception : NOTATION");
                }
                case 7: {
                    XMLDOMBuilder.outputIndentation(writer, n);
                    writer.write("<?" + node.getNodeName() + basicIndent + node.getNodeValue());
                    if (node.hasChildNodes()) {
                        writer.write(">");
                        XMLDOMBuilder.unparse(node.getFirstChild(), writer, n + 1);
                        writer.write("\n");
                        XMLDOMBuilder.outputIndentation(writer, n);
                        writer.write("</" + node.getNodeName() + ">");
                        break;
                    }
                    writer.write(" ?>\n");
                    break;
                }
                case 3: {
                    String string = node.getNodeValue();
                    writer.write(XMLDOMBuilder.escape(string));
                    break;
                }
                default: {
                    throw new XMLProcessingException("Tag exception : UNSUPPORTED NODE : " + s);
                }
            }
        }
        catch (Exception exception) {
            throw new XMLProcessingException("An error occured while dumping : " + exception.getMessage());
        }
    }

    private static void outputIndentation(Writer writer, int n) throws XMLProcessingException {
        try {
            for (int i = 0; i < n; ++i) {
                writer.write(basicIndent);
            }
        }
        catch (IOException iOException) {
            throw new XMLProcessingException("IO error while outputing indentation : " + iOException.getMessage());
        }
    }

    private static Node stripWhiteSpaceNodes(Node node) {
        boolean bl = false;
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.hasChildNodes()) {
                XMLDOMBuilder.stripWhiteSpaceNodes(node2);
            }
            if (node2.getNodeType() == 3 && node2.getNodeValue() != null && (node2.getNodeValue().trim().length() == 0 || node2.getNodeValue().trim().endsWith("\n") || node2.getNodeValue().trim().startsWith("\n")) && (node2.getPreviousSibling() != null || node2.getNextSibling() != null)) {
                node.removeChild(node2);
                bl = true;
            }
            node2 = bl ? node.getFirstChild() : node2.getNextSibling();
            bl = false;
        }
        return node;
    }

    private static String escape(String string, boolean bl) {
        String string2 = StringUtils.replaceSubstring(string, "&", "&amp;");
        string2 = StringUtils.replaceSubstring(string2, "<", "&lt;");
        string2 = StringUtils.replaceSubstring(string2, ">", "&gt;");
        if (bl) {
            string2 = StringUtils.replaceSubstring(string2, "\"", "&quot;");
        }
        return string2;
    }

    private static String escape(String string) {
        return XMLDOMBuilder.escape(string, false);
    }

    static {
        _documentBuilderFactory = DocumentBuilderFactory.newInstance();
        _documentBuilderFactory.setValidating(false);
        _documentBuilderFactory.setIgnoringComments(true);
        _documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        _documentBuilderFactory.setCoalescing(true);
        _documentBuilderFactory.setExpandEntityReferences(true);
        _documentBuilderFactory.setNamespaceAware(true);
    }
}

