/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyReader {
    public static final String CONFIG_CLASS_SUFFIX = ".class";
    public static final String CONFIG_CONFIGPATH_SUFFIX = ".configpath";
    private File _configFile = null;
    private Properties _config = null;
    static /* synthetic */ Class class$java$io$File;

    public PropertyReader(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("PropertyReader: config is not a file: " + file.toString());
        }
        this._configFile = file;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            throw new IOException("PropertyReader: couldn't open configuration file" + file.toString() + " : " + exception.getMessage());
        }
        this._config = new Properties();
        try {
            this._config.load(fileInputStream);
        }
        catch (IOException iOException) {
            throw new IOException("PropertyReader: cant load config " + file.toString() + " : " + iOException.getMessage());
        }
    }

    public PropertyReader(File file, String string) throws IOException {
        this._configFile = new File(file, string);
        if (!this._configFile.isFile()) {
            throw new IOException("PropertyReader: config is not a file: " + this._configFile.toString());
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this._configFile);
        }
        catch (Exception exception) {
            throw new IOException("PropertyReader: couldn't open configuration file" + this._configFile.toString() + " : " + exception.getMessage());
        }
        this._config = new Properties();
        try {
            this._config.load(fileInputStream);
        }
        catch (IOException iOException) {
            throw new IOException("PropertyReader: cant load config " + this._configFile.toString() + " : " + iOException.getMessage());
        }
    }

    public final String getStringProperty(String string, String string2) {
        String string3 = this._config.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    public final String getLowerCaseStringProperty(String string, String string2) {
        String string3 = this._config.getProperty(string, string2);
        if (string3 != null) {
            return string3.toLowerCase();
        }
        return null;
    }

    public final String[] getStringArrayProperty(String string, String string2) {
        String string3 = this.getStringProperty(string, string2);
        if (string3 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public final int getIntProperty(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(this.getStringProperty(string, ""));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
        }
        return n2;
    }

    public final boolean getBooleanProperty(String string, String string2) {
        return Boolean.valueOf(this.getStringProperty(string, string2));
    }

    public final File getFileProperty(String string, String string2) {
        String string3 = this.getStringProperty(string, string2);
        if (string3 == null || string3.length() <= 0) {
            return null;
        }
        File file = new File(string3);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getConfigPath(), string3);
    }

    public final Object getObjectProperty(String string, boolean bl) throws IOException, InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        Serializable serializable;
        String string2 = this.getStringProperty(string + CONFIG_CLASS_SUFFIX, null);
        if (string2 == null) {
            return null;
        }
        Object object = null;
        Method method = null;
        try {
            serializable = Class.forName(string2);
            object = serializable.newInstance();
        }
        catch (Exception exception) {
            throw new IOException("getObjectProperty: couldn't load " + string2 + " : " + exception.getMessage());
        }
        if (!bl) {
            return object;
        }
        try {
            method = object.getClass().getMethod("init", class$java$io$File == null ? (class$java$io$File = PropertyReader.class$("java.io.File")) : class$java$io$File);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = this.getFileProperty(string + CONFIG_CONFIGPATH_SUFFIX, null);
        if (serializable != null && method != null) {
            boolean bl2 = false;
            bl2 = (Boolean)method.invoke(object, serializable);
            if (!bl2) {
                throw new IOException("getObject: couldn't init " + string2);
            }
        }
        return object;
    }

    public final Enumeration getKeyProperty(String string, String string2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<?> enumeration = this._config.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3;
            int n;
            int n2;
            String string4 = (String)enumeration.nextElement();
            if (!string4.startsWith(string) || !string4.endsWith(string2) || (n2 = string4.indexOf(".")) == (n = string4.lastIndexOf(".")) || (string3 = string4.substring(n2 + 1, n)) == null || string3.length() <= 0) continue;
            hashtable.put(string3, string3);
        }
        return hashtable.keys();
    }

    public final Enumeration getKeyPropertyBySuffix(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration<?> enumeration = this._config.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2;
            int n;
            int n2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.endsWith(string) || (n2 = string3.indexOf(".")) != (n = string3.lastIndexOf(".")) || (string2 = string3.substring(0, n2)) == null || string2.length() <= 0) continue;
            hashtable.put(string2, string2);
        }
        return hashtable.keys();
    }

    public final File getConfigFile() {
        return this._configFile;
    }

    public final File getConfigPath() {
        return this._configFile.getParentFile();
    }

    public final Properties getProperties() {
        return this._config;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

