/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import com.iplanet.xslui.tools.MultipartHttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MultipartRequest {
    private Hashtable _paramTable = null;
    private Hashtable _fileTable = null;

    public MultipartRequest(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("null inputStream");
        }
        this._paramTable = new Hashtable();
        this._fileTable = new Hashtable();
        MimeMessage mimeMessage = null;
        MimeMultipart mimeMultipart = null;
        try {
            mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)new Properties(), null), inputStream);
        }
        catch (MessagingException messagingException) {
            throw new IOException("MimeMessage creation failed: " + messagingException.getMessage());
        }
        try {
            mimeMultipart = (MimeMultipart)mimeMessage.getContent();
        }
        catch (MessagingException messagingException) {
            throw new IOException("getContent failed: " + messagingException.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("getContent failed: not Mime content-type " + classCastException.getMessage());
        }
        try {
            MultipartHttpServletRequest.parseMultiPart(mimeMultipart, this._paramTable, this._fileTable);
        }
        catch (IOException iOException) {
            throw new IOException("parseMultiPart has thrown IOException: " + iOException.getMessage());
        }
        catch (MessagingException messagingException) {
            throw new IOException("parseMultiPart has thrown MessagingException: " + messagingException.getMessage());
        }
    }

    public String getParameter(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = (String[])this._paramTable.get(string);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getParameterValues(String string) {
        if (string == null) {
            return null;
        }
        return (String[])this._paramTable.get(string);
    }

    public Enumeration getParameterNames() {
        return this._paramTable.keys();
    }

    public Enumeration getFileParameterNames() {
        return this._fileTable.keys();
    }

    public InputStream getFileParameter(String string) {
        if (string == null) {
            return null;
        }
        return (InputStream)this._fileTable.get(string);
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        return MultipartHttpServletRequest.inputStreamToString(inputStream);
    }
}

